/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.core.util.DocumentUtil;
import com.ableneo.liferay.portal.setup.core.util.IdMode;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public final class ResolverUtil {
    public static final int ID_TYPE_ID = 0;
    public static final int ID_TYPE_UUID = 1;
    public static final int ID_TYPE_RESOURCE = 2;
    public static final int ID_TYPE_FILE = 3;
    public static final String IDTYPE = "%%IDTYPE%%";
    public static final String LOOKUPTYPE = "%%LOOKUPTYPE%%";
    public static final String CLOSING_TAG = "$}}";
    public static final String ARTICLE_BY_ART_ID = "{{$ARTICLE-%%IDTYPE%%-BY-ARTICLE-ID=";
    public static final String TEMPLATE_BY_KEY = "{{$%%PREFIX%%-TEMPLATE-%%IDTYPE%%-BY-KEY=";
    public static final String STRUCTURE_BY_KEY = "{{$%%PREFIX%%-STRUCTURE-%%IDTYPE%%-BY-KEY=";
    public static final String FILE_REFERENCE_URL = "{{$FILE-URL=";
    public static final String FILE_REFERENCE_ID = "{{$FILE-ID=";
    public static final String FILE_REFERENCE_UUID = "{{$FILE-UUID=";
    public static final String CLASS_ID_BY_NAME = "{{$CLASS-ID-BY-NAME=";
    public static final String PAGE_ID_BY_FRIENDLY_URL = "{{$%%PTYPE%%-PAGE-%%LAYOUTID%%-BY-FRIENDLY_URL=";
    public static final String DDL_REC_SET_BY_KEY = "{{$DDL-REC-SET-ID-BY-KEY=";
    public static final String TEMPLATE_CATEGORY = "{{$CATEGORY-ID-BY-VOCABULARY-AND-PATH=";
    public static final String ID_OF_SITE_WITH_NAME_KEY = "{{$ID_OF_SITE_WITH_NAME=";
    public static final String VALUE_SPLIT = "::";
    public static final String ID_OF_ORG_USER_GROUP_WITH_NAME_KEY = "{{$%%IDTYPE%%_OF_%%LOOKUPTYPE%%_WITH_NAME=";
    public static final String LAYOUTID = "%%LAYOUTID%%";
    private static final Log LOG = LogFactoryUtil.getLog(ResolverUtil.class);
    private static final String COULD_NOT_RESOLVE_SITE_NAME = "Could not resolve site name, as the syntax is offended, closing tag (%2$s) is missing for %1$s";

    private ResolverUtil() {
    }

    public static String lookupAll(long groupId, long company, String value, String resolverHint) {
        String retVal = ResolverUtil.lookupSiteIdWithName(resolverHint, value, company);
        retVal = ResolverUtil.lookupStructureOrTemplateIdWithKey(retVal, resolverHint, groupId, company, false, "ART", true, JournalArticle.class);
        retVal = ResolverUtil.lookupStructureOrTemplateIdWithKey(retVal, resolverHint, groupId, company, false, "ART", false, JournalArticle.class);
        retVal = ResolverUtil.lookupStructureOrTemplateIdWithKey(retVal, resolverHint, groupId, company, true, "ART", false, JournalArticle.class);
        retVal = ResolverUtil.lookupStructureOrTemplateIdWithKey(retVal, resolverHint, groupId, company, true, "ART", true, JournalArticle.class);
        retVal = ResolverUtil.lookupStructureOrTemplateIdWithKey(retVal, resolverHint, groupId, company, true, "ADT", true, AssetEntry.class);
        retVal = ResolverUtil.lookupStructureOrTemplateIdWithKey(retVal, resolverHint, groupId, company, false, "ADT", true, AssetEntry.class);
        retVal = ResolverUtil.substituteCategoryNameWithCategoryId(retVal, resolverHint, groupId, company);
        retVal = ResolverUtil.lookupArticleWithArticleId(retVal, resolverHint, groupId, company, 0);
        retVal = ResolverUtil.lookupArticleWithArticleId(retVal, resolverHint, groupId, company, 1);
        retVal = ResolverUtil.lookupArticleWithArticleId(retVal, resolverHint, groupId, company, 2);
        retVal = ResolverUtil.substituteFileReferencesWithURL(retVal, resolverHint, groupId, company, groupId, 3);
        retVal = ResolverUtil.substituteFileReferencesWithURL(retVal, resolverHint, groupId, company, groupId, 0);
        retVal = ResolverUtil.substituteFileReferencesWithURL(retVal, resolverHint, groupId, company, groupId, 1);
        retVal = ResolverUtil.getClassIdByName(retVal, resolverHint);
        retVal = ResolverUtil.lookupPageIdWithFriendlyUrl(retVal, resolverHint, groupId, company, true, IdMode.ID);
        retVal = ResolverUtil.lookupPageIdWithFriendlyUrl(retVal, resolverHint, groupId, company, false, IdMode.ID);
        retVal = ResolverUtil.lookupPageIdWithFriendlyUrl(retVal, resolverHint, groupId, company, true, IdMode.PLID);
        retVal = ResolverUtil.lookupPageIdWithFriendlyUrl(retVal, resolverHint, groupId, company, false, IdMode.PLID);
        retVal = ResolverUtil.lookupPageIdWithFriendlyUrl(retVal, resolverHint, groupId, company, true, IdMode.UUID);
        retVal = ResolverUtil.lookupPageIdWithFriendlyUrl(retVal, resolverHint, groupId, company, false, IdMode.UUID);
        retVal = ResolverUtil.lookupDDLRecordSetId(retVal, resolverHint, groupId, company);
        retVal = ResolverUtil.lookupOrgOrUserGroupIdWithName(resolverHint, retVal, company, false, false);
        retVal = ResolverUtil.lookupOrgOrUserGroupIdWithName(resolverHint, retVal, company, true, false);
        retVal = ResolverUtil.lookupOrgOrUserGroupIdWithName(resolverHint, retVal, company, false, true);
        retVal = ResolverUtil.lookupOrgOrUserGroupIdWithName(resolverHint, retVal, company, true, true);
        return retVal;
    }

    public static String getClassIdByName(String value, String locationHint) {
        String valueCopy;
        String retVal = valueCopy = value;
        while (valueCopy != null && valueCopy.trim().indexOf(CLASS_ID_BY_NAME) > -1) {
            int pos = valueCopy.trim().indexOf(CLASS_ID_BY_NAME);
            int pos2 = valueCopy.indexOf(CLOSING_TAG, pos + 1);
            String name = "";
            if (pos2 > -1) {
                try {
                    name = valueCopy.substring(pos + CLASS_ID_BY_NAME.length(), pos2);
                    long groupId = ClassNameLocalServiceUtil.getClassNameId((String)name);
                    valueCopy = retVal = valueCopy.substring(0, pos) + groupId + valueCopy.substring(pos2 + CLOSING_TAG.length(), valueCopy.length());
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("Could not resolve class %1$s for %2$s", name, locationHint), (Throwable)ex);
                }
                continue;
            }
            LOG.warn((Object)String.format(COULD_NOT_RESOLVE_SITE_NAME, locationHint, CLOSING_TAG));
            break;
        }
        return retVal;
    }

    public static long getSiteGroupIdByName(String siteName, long company, String locationName) {
        long siteGroupId = 0L;
        if (siteName.equalsIgnoreCase("global")) {
            try {
                siteGroupId = GroupLocalServiceUtil.getCompanyGroup((long)company).getGroupId();
            }
            catch (PortalException e) {
                LOG.error((Object)"Id of global site could not be retrieved!", (Throwable)e);
            }
        } else {
            try {
                siteGroupId = GroupLocalServiceUtil.getGroup((long)company, (String)ResolverUtil.getSiteName(siteName)).getGroupId();
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Id of site %1$s could not be retrieved for %2$s", siteName, locationName), (Throwable)e);
            }
        }
        return siteGroupId;
    }

    private static String getSiteName(String siteName) {
        if (siteName.equalsIgnoreCase("default") || siteName.equals("")) {
            return "Guest";
        }
        return siteName;
    }

    public static String substituteFileReferencesWithURL(String content, String locationHint, long groupId, long company, long repoId, int refType) {
        String openingTag = FILE_REFERENCE_URL;
        if (refType == 0) {
            openingTag = FILE_REFERENCE_ID;
        } else if (refType == 1) {
            openingTag = FILE_REFERENCE_UUID;
        }
        String result = content;
        int pos = result.indexOf(openingTag);
        while (pos > -1) {
            FileEntry fe;
            int pos2 = result.indexOf(CLOSING_TAG, pos);
            if (pos2 < 0) {
                LOG.error((Object)String.format("No closing Tag, pos %1$s in file %2$s", pos, locationHint));
                break;
            }
            long siteGroupId = groupId;
            String filePath = result.substring(pos + openingTag.length(), pos2).trim();
            String[] refSegs = ResolverUtil.separateSiteRef(filePath);
            if (!refSegs[0].equals("")) {
                siteGroupId = ResolverUtil.getSiteGroupIdByName(refSegs[0], company, locationHint);
                filePath = refSegs[1];
            }
            if ((fe = DocumentUtil.findDocument(filePath, siteGroupId, repoId)) == null) {
                LOG.error((Object)String.format("Referred file %1$s is not found in documents and media.", filePath));
                result = result.substring(0, pos) + " <file-not-found /> " + result.substring(pos2 + CLOSING_TAG.length(), result.length());
            } else {
                String fileEntryRef = " <file-not-found /> ";
                try {
                    fileEntryRef = refType == 0 ? Long.toString(fe.getFileEntryId()) : (refType == 1 ? fe.getUuid() : DLUtil.getPreviewURL((FileEntry)fe, (FileVersion)fe.getFileVersion(), null, (String)""));
                }
                catch (PortalException e) {
                    LOG.error((Object)String.format("URL of referred file %1$s cannot be retrieved.", filePath));
                }
                result = result.substring(0, pos) + fileEntryRef + result.substring(pos2 + CLOSING_TAG.length(), result.length());
            }
            pos = result.indexOf(openingTag, pos + 1);
        }
        return result;
    }

    public static String substituteCategoryNameWithCategoryId(String content, String locationHint, long groupId, long company) {
        String result = content;
        String openingTag = TEMPLATE_CATEGORY;
        if (result.startsWith(openingTag)) {
            String[] values = result.replace(CLOSING_TAG, "").split(VALUE_SPLIT);
            if (values.length == 4) {
                long groupIdResolved = groupId;
                try {
                    groupIdResolved = ResolverUtil.getSiteGroupIdByName(values[1], company, locationHint);
                    String category = ResolverUtil.resolveVocabularyName(locationHint, values, groupIdResolved);
                    if (category != null) {
                        return category;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Could not resolve site name for %1$s", locationHint), (Throwable)e);
                }
            } else {
                LOG.error((Object)"Categories to be susbstited is not in correct format : SiteName::Vocabulary::CategoriesPath");
            }
        }
        return result;
    }

    private static String resolveVocabularyName(String locationHint, String[] values, long groupIdResolved) {
        try {
            AssetVocabulary assetVocabulary = AssetVocabularyLocalServiceUtil.getGroupVocabulary((long)groupIdResolved, (String)values[2]);
            String[] categoryIds = values[3].split("/");
            String category = ResolverUtil.resolveCategoryId(locationHint, assetVocabulary, categoryIds);
            if (category != null) {
                return category;
            }
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Could not resolve vocabulary name for %1$s", locationHint), (Throwable)e);
        }
        return null;
    }

    private static String resolveCategoryId(String locationHint, AssetVocabulary assetVocabulary, String[] categoryIds) {
        try {
            AssetCategory category = assetVocabulary.getCategories().stream().filter(vocabularyCategory -> vocabularyCategory.getName().equals(categoryIds[0])).findFirst().orElseThrow(PortalException::new);
            for (int i = 1; i < categoryIds.length; ++i) {
                String categoryName = categoryIds[i];
                category = AssetCategoryLocalServiceUtil.getChildCategories((long)category.getCategoryId()).stream().filter(childrenCategory -> childrenCategory.getName().equals(categoryName)).findFirst().orElseThrow(PortalException::new);
            }
            return String.valueOf(category.getCategoryId());
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Could not resolve category path for %1$s", locationHint), (Throwable)e);
            return null;
        }
    }

    public static String lookupSiteIdWithName(String locationHint, String value, long company) {
        String valueCopy;
        String retVal = valueCopy = value;
        while (valueCopy != null && valueCopy.trim().indexOf(ID_OF_SITE_WITH_NAME_KEY) > -1) {
            int pos = valueCopy.trim().indexOf(ID_OF_SITE_WITH_NAME_KEY);
            int pos2 = valueCopy.indexOf(CLOSING_TAG, pos + 1);
            if (pos2 > -1) {
                try {
                    String name = valueCopy.substring(pos + ID_OF_SITE_WITH_NAME_KEY.length(), pos2);
                    long groupId = ResolverUtil.getSiteGroupIdByName(name, company, locationHint);
                    valueCopy = retVal = valueCopy.substring(0, pos) + groupId + valueCopy.substring(pos2 + CLOSING_TAG.length(), valueCopy.length());
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("Could not resolve site name for %1$s", locationHint), (Throwable)ex);
                }
                continue;
            }
            LOG.warn((Object)String.format(COULD_NOT_RESOLVE_SITE_NAME, locationHint, CLOSING_TAG));
            break;
        }
        return retVal;
    }

    public static String lookupOrgOrUserGroupIdWithName(String locationHint, String value, long company, boolean uuid, boolean org) {
        String valueCopy;
        String retVal = valueCopy = value;
        String searchString = ID_OF_ORG_USER_GROUP_WITH_NAME_KEY;
        searchString = uuid ? searchString.replace(IDTYPE, "UUID") : searchString.replace(IDTYPE, "ID");
        searchString = org ? searchString.replace(LOOKUPTYPE, "ORG") : searchString.replace(LOOKUPTYPE, "USER_GROUP");
        while (valueCopy != null && valueCopy.trim().indexOf(searchString) > -1) {
            int pos = valueCopy.trim().indexOf(searchString);
            int pos2 = valueCopy.indexOf(CLOSING_TAG, pos + 1);
            if (pos2 > -1) {
                try {
                    String name = valueCopy.substring(pos + searchString.length(), pos2);
                    String replacementId = "NOT FOUND";
                    if (org) {
                        Organization o = ResolverUtil.getOrganization(name, company, name);
                        if (o != null) {
                            replacementId = uuid ? o.getUuid() : Long.toString(o.getOrganizationId());
                        }
                    } else {
                        UserGroup ug = ResolverUtil.getUserGroup(name, company, name);
                        if (ug != null) {
                            replacementId = uuid ? ug.getUuid() : Long.toString(ug.getUserGroupId());
                        }
                    }
                    valueCopy = retVal = valueCopy.substring(0, pos) + replacementId + valueCopy.substring(pos2 + CLOSING_TAG.length(), valueCopy.length());
                }
                catch (Exception ex) {
                    String type = "user group";
                    if (org) {
                        type = "organization";
                    }
                    LOG.error((Object)String.format("Could not resolve  %1$s name for %2$s", type, locationHint), (Throwable)ex);
                }
                continue;
            }
            String type = "user group";
            if (org) {
                type = "organization";
            }
            LOG.warn((Object)String.format("Could not resolve %1$s name, as the syntax is offendended, closing (%3$s) is missing for %2$s", type, locationHint, CLOSING_TAG));
            break;
        }
        return retVal;
    }

    public static String lookupArticleWithArticleId(String content, String locationHint, long groupId, long company, int typeOfId) {
        String contentCopy;
        String retVal = contentCopy = content;
        long siteGroupId = groupId;
        int pos = -1;
        String lookup = ARTICLE_BY_ART_ID;
        if (typeOfId == 0) {
            lookup = lookup.replace(IDTYPE, "ID");
        } else if (typeOfId == 1) {
            lookup = lookup.replace(IDTYPE, "UUID");
        } else if (typeOfId == 2) {
            lookup = lookup.replace(IDTYPE, "RESID");
        }
        while (contentCopy != null && contentCopy.indexOf(lookup) > -1) {
            pos = contentCopy.indexOf(lookup);
            int pos2 = contentCopy.indexOf(CLOSING_TAG, pos + 1);
            if (pos2 > -1) {
                String name = contentCopy.substring(pos + lookup.length(), pos2);
                String[] refSegs = ResolverUtil.separateSiteRef(name);
                if (!refSegs[0].equals("")) {
                    siteGroupId = ResolverUtil.getSiteGroupIdByName(refSegs[0], company, locationHint);
                    name = refSegs[1];
                }
                String templateId = "";
                try {
                    JournalArticle ja = JournalArticleLocalServiceUtil.fetchLatestArticle((long)siteGroupId, (String)name, (int)0);
                    if (ja != null) {
                        if (typeOfId == 0) {
                            templateId = Long.toString(ja.getId());
                        } else if (typeOfId == 1) {
                            templateId = ja.getUuid();
                        } else if (typeOfId == 2) {
                            templateId = Long.toString(ja.getResourcePrimKey());
                        }
                    } else {
                        LOG.error((Object)String.format("Article with article id %1$s not found for %2$s", name, locationHint));
                        templateId = "!!NOTFOUND!!";
                    }
                }
                catch (SystemException e) {
                    LOG.error((Object)String.format("Article with article id %1$s not found for %2$s", name, locationHint), (Throwable)e);
                }
                contentCopy = retVal = contentCopy.substring(0, pos) + templateId + contentCopy.substring(pos2 + CLOSING_TAG.length(), contentCopy.length());
                continue;
            }
            LOG.warn((Object)String.format("Could not resolve template, as the syntax is offended, closing (%1$s) is missing for %2$s abort parsing, as this is possibly an error!", CLOSING_TAG, locationHint));
            break;
        }
        return retVal;
    }

    public static String lookupPageIdWithFriendlyUrl(String content, String locationHint, long groupId, long company, boolean isPrivate, IdMode mode) {
        String contentCopy = content;
        String lookUp = PAGE_ID_BY_FRIENDLY_URL;
        lookUp = isPrivate ? lookUp.replace("%%PTYPE%%", "PRIV") : lookUp.replace("%%PTYPE%%", "PUB");
        switch (mode) {
            case ID: {
                lookUp = lookUp.replace(LAYOUTID, "PLID");
                break;
            }
            case PLID: {
                lookUp = lookUp.replace(LAYOUTID, "ID");
                break;
            }
            case UUID: {
                lookUp = lookUp.replace(LAYOUTID, "UUID");
            }
        }
        int pos = contentCopy.indexOf(lookUp);
        while (pos > -1) {
            int pos2 = contentCopy.indexOf(CLOSING_TAG, pos);
            if (pos2 < 0) {
                LOG.error((Object)String.format("No closing Tag, pos %1$s for %2$s", pos, locationHint));
                break;
            }
            long siteGroupId = groupId;
            String fUrl = contentCopy.substring(pos + lookUp.length(), pos2).trim();
            String[] refSegs = ResolverUtil.separateSiteRef(fUrl);
            if (!refSegs[0].equals("")) {
                siteGroupId = ResolverUtil.getSiteGroupIdByName(refSegs[0], company, locationHint);
                fUrl = refSegs[1];
            }
            String pageId = "NOT FOUND";
            Layout l = null;
            try {
                l = LayoutLocalServiceUtil.getFriendlyURLLayout((long)siteGroupId, (boolean)isPrivate, (String)fUrl);
            }
            catch (PortalException | SystemException e) {
                LOG.error(e);
            }
            if (l == null) {
                LOG.error((Object)String.format("Referred page %1$s is not found .", fUrl));
                contentCopy = contentCopy.substring(0, pos) + " PAGE NOT FOUND!! " + contentCopy.substring(pos2 + CLOSING_TAG.length(), contentCopy.length());
            } else {
                switch (mode) {
                    case ID: {
                        pageId = Long.toString(l.getLayoutId());
                        break;
                    }
                    case PLID: {
                        pageId = Long.toString(l.getPlid());
                        break;
                    }
                    case UUID: {
                        pageId = l.getUuid();
                    }
                }
                contentCopy = contentCopy.substring(0, pos) + pageId + contentCopy.substring(pos2 + CLOSING_TAG.length(), contentCopy.length());
            }
            pos = contentCopy.indexOf(lookUp, pos + 1);
        }
        return contentCopy;
    }

    public static String lookupDDLRecordSetId(String content, String locationHint, long groupId, long company) {
        String contentCopy = content;
        String lookUp = DDL_REC_SET_BY_KEY;
        int pos = contentCopy.indexOf(lookUp);
        while (pos > -1) {
            int pos2 = contentCopy.indexOf(CLOSING_TAG, pos);
            if (pos2 < 0) {
                LOG.error((Object)String.format("No closing Tag, pos %1$s for %2$s", pos, locationHint));
                break;
            }
            long siteGroupId = groupId;
            String recordsetId = contentCopy.substring(pos + lookUp.length(), pos2).trim();
            String[] refSegs = ResolverUtil.separateSiteRef(recordsetId);
            if (!refSegs[0].equals("")) {
                siteGroupId = ResolverUtil.getSiteGroupIdByName(refSegs[0], company, locationHint);
                recordsetId = refSegs[1];
            }
            DDLRecordSet rs = null;
            try {
                rs = DDLRecordSetLocalServiceUtil.getRecordSet((long)siteGroupId, (String)recordsetId);
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Error retrieving referred DDL structure %1$s.", recordsetId));
            }
            if (rs == null) {
                LOG.error((Object)String.format("Referred DDL structure %1$s is not found .", recordsetId));
                contentCopy = contentCopy.substring(0, pos) + " PAGE NOT FOUND!! " + contentCopy.substring(pos2 + CLOSING_TAG.length(), contentCopy.length());
            } else {
                String pageId = Long.toString(rs.getRecordSetId());
                contentCopy = contentCopy.substring(0, pos) + pageId + contentCopy.substring(pos2 + CLOSING_TAG.length(), contentCopy.length());
            }
            pos = contentCopy.indexOf(lookUp, pos + 1);
        }
        return contentCopy;
    }

    public static String lookupStructureOrTemplateIdWithKey(String content, String locationHint, long groupId, long company, boolean uuid, String commandPrefix, boolean isTemplate, Class referredClass) {
        String contentCopy;
        String retVal = contentCopy = content;
        long siteGroupId = groupId;
        int pos = -1;
        String lookup = TEMPLATE_BY_KEY;
        if (!isTemplate) {
            lookup = STRUCTURE_BY_KEY;
        }
        lookup = uuid ? lookup.replace(IDTYPE, "UUID") : lookup.replace(IDTYPE, "ID");
        lookup = lookup.replace("%%PREFIX%%", commandPrefix);
        while (contentCopy != null && contentCopy.indexOf(lookup) > -1) {
            pos = contentCopy.indexOf(lookup);
            int pos2 = contentCopy.indexOf(CLOSING_TAG);
            if (pos2 > -1) {
                String name = contentCopy.substring(pos + lookup.length(), pos2);
                String[] refSegs = ResolverUtil.separateSiteRef(name);
                if (!refSegs[0].equals("")) {
                    siteGroupId = ResolverUtil.getSiteGroupIdByName(refSegs[0], company, locationHint);
                    name = refSegs[1];
                }
                String templateId = "";
                try {
                    templateId = uuid ? (isTemplate ? ResolverUtil.getTemplateUUID(name) : ResolverUtil.getStructureUUID(name, siteGroupId, referredClass)) : (isTemplate ? Long.toString(ResolverUtil.getTemplateId(name, siteGroupId, referredClass)) : Long.toString(ResolverUtil.getStructureId(name, siteGroupId, referredClass.getName(), false)));
                }
                catch (PortalException | SystemException e) {
                    LOG.error((Object)String.format("Template with key contentCopy %1$s not found for %2$s", name, locationHint));
                    LOG.error(e);
                }
                contentCopy = retVal = contentCopy.substring(0, pos) + templateId + contentCopy.substring(pos2 + CLOSING_TAG.length(), contentCopy.length());
                continue;
            }
            LOG.warn((Object)("Could not resolve template, as the syntax is offended, closing $}} is missing for " + locationHint + " abort parsing, as this is possibly an error!"));
            break;
        }
        return retVal;
    }

    public static long getStructureId(String structureKey, long groupId, String className, boolean includeAncestorStructures) throws PortalException {
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)className);
        DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)groupId, (long)classNameId, (String)structureKey, (boolean)includeAncestorStructures);
        return structure.getStructureId();
    }

    public static String getStructureUUID(String structureKey, long groupId, Class clazz) throws PortalException {
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((Class)clazz);
        DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)groupId, (long)classNameId, (String)structureKey);
        return structure.getUuid();
    }

    public static long getTemplateId(String templateKey, long groupId, Class clazz) throws PortalException {
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((Class)clazz);
        DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)groupId, (long)classNameId, (String)templateKey);
        return template.getTemplateId();
    }

    public static Organization getOrganization(String name, long companyId, String locationHint) {
        Organization o = null;
        try {
            o = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)name);
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Could not retrieve organization %1$s in context %2$s", name, locationHint));
        }
        return o;
    }

    public static UserGroup getUserGroup(String name, long companyId, String locationHint) {
        UserGroup o = null;
        try {
            o = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)name);
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Could not retrieve organization %1$s in context %2$s", name, locationHint));
        }
        return o;
    }

    public static String getTemplateUUID(String templateKey) {
        DynamicQuery dq = DDMTemplateLocalServiceUtil.dynamicQuery().add(PropertyFactoryUtil.forName((String)"templateKey").eq((Object)templateKey));
        List templateList = new ArrayList();
        String uuid = "NOT FOUND!!!!";
        try {
            templateList = DDMTemplateLocalServiceUtil.dynamicQuery((DynamicQuery)dq);
            if (templateList != null && !templateList.isEmpty() && templateList.get(0) != null) {
                uuid = ((DDMTemplate)templateList.get(0)).getUuid();
            }
        }
        catch (SystemException e) {
            LOG.error((Object)String.format("Tempate with key %1$s not found !!", templateKey), (Throwable)e);
        }
        return uuid;
    }

    private static String[] separateSiteRef(String content) {
        int siteNameEndPos;
        String contentCopy = content;
        String[] retVal = new String[]{"", contentCopy};
        if (contentCopy.startsWith(VALUE_SPLIT) && (siteNameEndPos = contentCopy.indexOf(VALUE_SPLIT, 2)) > -1) {
            String siteName = contentCopy.substring(2, siteNameEndPos);
            contentCopy = contentCopy.substring(siteNameEndPos + 2, contentCopy.length()).trim();
            retVal[0] = siteName;
            retVal[1] = contentCopy;
        }
        return retVal;
    }
}

