/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core.util;

import com.ableneo.liferay.portal.setup.core.util.FilePathUtil;
import com.ableneo.liferay.portal.setup.core.util.FolderUtil;
import com.ableneo.liferay.portal.setup.core.util.MimeTypeMapper;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;

public final class DocumentUtil {
    private static final Log LOG = LogFactoryUtil.getLog(DocumentUtil.class);

    private DocumentUtil() {
    }

    public static FileEntry findDocument(String documentName, String folderPath, long groupId, long repoId) {
        Folder folder = FolderUtil.findFolder(groupId, repoId, folderPath, false);
        FileEntry entry = null;
        if (folder != null) {
            try {
                entry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folder.getFolderId(), (String)documentName);
            }
            catch (NoSuchFileEntryException e) {
                LOG.info((Object)String.format("Document not found: %1$s", documentName));
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Error while trying to find document: %1$s", documentName));
            }
        }
        return entry;
    }

    public static FileEntry findDocument(String documentName, long groupId, long repoId) {
        String title = FilePathUtil.getFileName(documentName);
        String getPath = FilePathUtil.getPath(documentName);
        Folder folder = FolderUtil.findFolder(groupId, repoId, getPath, false);
        FileEntry entry = null;
        if (folder != null) {
            try {
                entry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folder.getFolderId(), (String)title);
            }
            catch (PortalException e) {
                LOG.error((Throwable)e);
            }
        }
        return entry;
    }

    public static void updateFile(FileEntry fe, byte[] content, long userId, String sourceFileName) {
        try {
            DLVersionNumberIncrease inc = DLVersionNumberIncrease.AUTOMATIC;
            DLAppLocalServiceUtil.updateFileEntry((long)userId, (long)fe.getFileEntryId(), (String)sourceFileName, (String)fe.getMimeType(), (String)fe.getTitle(), (String)fe.getDescription(), (String)"update content", (DLVersionNumberIncrease)inc, (byte[])content, (ServiceContext)new ServiceContext());
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Can not update Liferay Document entry with ID:%1$s", fe.getFileEntryId()), (Throwable)e);
        }
    }

    public static void moveFile(FileEntry fe, long folderId, long userId) {
        try {
            DLAppLocalServiceUtil.moveFileEntry((long)userId, (long)fe.getFolderId(), (long)folderId, (ServiceContext)new ServiceContext());
        }
        catch (PortalException e) {
            LOG.error((Throwable)e);
        }
    }

    public static FileEntry createDocument(long groupId, long folderId, String fileName, String title, long userId, long repoId, byte[] content) {
        String fname = FilePathUtil.getFileName(fileName);
        String extension = FilePathUtil.getExtension(fname);
        String mtype = MimeTypeMapper.getInstance().getMimeType(extension);
        FileEntry fileEntry = null;
        try {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
        }
        catch (NoSuchFileEntryException nsfee) {
            LOG.info((Object)String.format("Document not found: %1$s", title));
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Error while trying to get file: %1$s", title));
        }
        if (fileEntry == null) {
            try {
                fileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)repoId, (long)folderId, (String)fname, (String)mtype, (String)title, (String)title, (String)"Ableneo import", (byte[])content, (ServiceContext)new ServiceContext());
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Error while trying to add file entry: %1$s", title), (Throwable)e);
            }
        }
        return fileEntry;
    }
}

