/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupArticles;
import com.ableneo.liferay.portal.setup.core.SetupCategorization;
import com.ableneo.liferay.portal.setup.core.SetupDocumentFolders;
import com.ableneo.liferay.portal.setup.core.SetupDocuments;
import com.ableneo.liferay.portal.setup.core.SetupPages;
import com.ableneo.liferay.portal.setup.core.SetupSites;
import com.ableneo.liferay.portal.setup.core.SetupWebFolders;
import com.ableneo.liferay.portal.setup.core.util.CustomFieldSettingUtil;
import com.ableneo.liferay.portal.setup.domain.CustomFieldSetting;
import com.ableneo.liferay.portal.setup.domain.Organization;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SetupOrganizations {
    private static final Log LOG = LogFactoryUtil.getLog(SetupOrganizations.class);

    private SetupOrganizations() {
    }

    public static void setupOrganizations(Iterable<Organization> organizations, com.liferay.portal.kernel.model.Organization parentOrg, Group parentGroup) {
        for (Organization organization : organizations) {
            try {
                com.liferay.portal.kernel.model.Organization liferayOrg = null;
                Group liferayGroup = null;
                long groupId = -1L;
                long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                try {
                    com.liferay.portal.kernel.model.Organization org = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)organization.getName());
                    liferayGroup = org.getGroup();
                    groupId = org.getGroupId();
                    liferayOrg = org;
                    LOG.info((Object)String.format("Setup: Organization %1$s already exist in system, not creating...", organization.getName()));
                }
                catch (PortalException | SystemException e) {
                    LOG.debug((Object)"Organization does not exist.", e);
                }
                if (groupId == -1L) {
                    LOG.info((Object)String.format("Setup: Organization %1$s does not exist in system, creating...", organization.getName()));
                    com.liferay.portal.kernel.model.Organization newOrganization = OrganizationLocalServiceUtil.addOrganization((long)SetupConfigurationThreadLocal.getRunAsUserId(), (long)0L, (String)organization.getName(), (String)"organization", (long)0L, (long)0L, (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, (String)"Created by setup module.", (boolean)false, (ServiceContext)new ServiceContext());
                    SetupOrganizations.addOrganizationUser(newOrganization, UserLocalServiceUtil.getUser((long)SetupConfigurationThreadLocal.getRunAsUserId()));
                    liferayOrg = newOrganization;
                    liferayGroup = liferayOrg.getGroup();
                    groupId = newOrganization.getGroupId();
                    LOG.info((Object)String.format("New Organization created. Group ID: %1$s", groupId));
                }
                if (parentOrg != null && liferayOrg != null && organization.isMaintainOrganizationHierarchy()) {
                    liferayOrg.setParentOrganizationId(parentOrg.getOrganizationId());
                    OrganizationLocalServiceUtil.updateOrganization((com.liferay.portal.kernel.model.Organization)liferayOrg);
                } else if (liferayOrg != null && organization.isMaintainOrganizationHierarchy()) {
                    liferayOrg.setParentOrganizationId(0L);
                    OrganizationLocalServiceUtil.updateOrganization((com.liferay.portal.kernel.model.Organization)liferayOrg);
                }
                SetupOrganizations.setCustomFields(groupId, organization, liferayOrg);
                LOG.info((Object)"Organization custom fields set up.");
                Site orgSite = organization.getSite();
                if (orgSite == null) {
                    LOG.info((Object)"Organization has no site defined. All is set.");
                } else if (orgSite.isDefault() || orgSite.getName() == null || orgSite.getName().isEmpty()) {
                    LOG.error((Object)"It is not possible to set global or default within organization. Skipping site setup.");
                } else {
                    LOG.info((Object)"Setting up site for organization.");
                    liferayGroup.setSite(true);
                    liferayGroup.setName(orgSite.getName());
                    GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
                    liferayGroup = liferayOrg.getGroup();
                    if (liferayGroup != null && orgSite.getSiteFriendlyUrl() != null && !orgSite.getSiteFriendlyUrl().isEmpty()) {
                        liferayGroup.setFriendlyURL(orgSite.getSiteFriendlyUrl());
                        GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
                        liferayGroup = liferayOrg.getGroup();
                    }
                    if (parentGroup != null && liferayGroup != null && orgSite.isMaintainSiteHierarchy()) {
                        liferayGroup.setParentGroupId(parentGroup.getGroupId());
                        GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
                    } else if (liferayGroup != null && orgSite.isMaintainSiteHierarchy()) {
                        liferayGroup.setParentGroupId(0L);
                        GroupLocalServiceUtil.updateGroup((Group)liferayGroup);
                    }
                    SetupConfigurationThreadLocal.configureGroupExecutionContext(liferayGroup);
                    LOG.info((Object)"Setting organization site content...");
                    SetupDocumentFolders.setupDocumentFolders(orgSite, groupId);
                    LOG.info((Object)"Document Folders setting finished.");
                    SetupDocuments.setupSiteDocuments(orgSite, groupId);
                    LOG.info((Object)"Documents setting finished.");
                    SetupPages.setupSitePages(orgSite, groupId);
                    LOG.info((Object)"Organization Pages setting finished.");
                    SetupWebFolders.setupWebFolders(orgSite, groupId);
                    LOG.info((Object)"Web folders setting finished.");
                    SetupCategorization.setupVocabularies(orgSite.getVocabulary(), groupId);
                    LOG.info((Object)"Organization Categories setting finished.");
                    SetupArticles.setupSiteArticles(orgSite.getArticle(), orgSite.getAdt(), orgSite.getDdlRecordset(), groupId);
                    LOG.info((Object)"Organization Articles setting finished.");
                    SetupSites.setCustomFields(groupId, orgSite.getCustomFieldSetting());
                    LOG.info((Object)"Organization site custom fields set up.");
                }
                List<Organization> orgs = organization.getOrganization();
                SetupOrganizations.setupOrganizations(orgs, liferayOrg, liferayGroup);
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Error by setting up organization %1$s", organization.getName()), (Throwable)e);
            }
        }
    }

    private static void setCustomFields(long groupId, Organization org, com.liferay.portal.kernel.model.Organization liferayOrg) {
        Class<com.liferay.portal.kernel.model.Organization> clazz = com.liferay.portal.kernel.model.Organization.class;
        String resolverHint = "Resolving customized value for page " + org.getName() + " failed for key %%key%% and value %%value%%";
        for (CustomFieldSetting cfs : org.getCustomFieldSetting()) {
            String key = cfs.getKey();
            String value = cfs.getValue();
            long company = SetupConfigurationThreadLocal.getRunInCompanyId();
            CustomFieldSettingUtil.setExpandoValue(resolverHint.replace("%%key%%", key).replace("%%value%%", value), groupId, company, clazz, liferayOrg.getOrganizationId(), key, value);
        }
    }

    public static void deleteOrganization(List<Organization> organizations, String deleteMethod) {
        switch (deleteMethod) {
            case "excludeListed": {
                Map<String, Organization> toBeDeletedOrganisations = SetupOrganizations.convertOrganisationListToHashMap(organizations);
                try {
                    for (com.liferay.portal.kernel.model.Organization organisation : OrganizationLocalServiceUtil.getOrganizations((int)-1, (int)-1)) {
                        if (toBeDeletedOrganisations.containsKey(organisation.getName())) continue;
                        try {
                            OrganizationLocalServiceUtil.deleteOrganization((long)organisation.getOrganizationId());
                            LOG.info((Object)String.format("Deleting Organisation %1$s", organisation.getName()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error by deleting Organisation !", (Throwable)e);
                        }
                    }
                    break;
                }
                catch (SystemException e) {
                    LOG.error((Object)"Error by retrieving organisations!", (Throwable)e);
                    break;
                }
            }
            case "onlyListed": {
                for (Organization organisation : organizations) {
                    String name = organisation.getName();
                    try {
                        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                        com.liferay.portal.kernel.model.Organization o = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)name);
                        OrganizationLocalServiceUtil.deleteOrganization((com.liferay.portal.kernel.model.Organization)o);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error by deleting Organisation !", (Throwable)e);
                    }
                    LOG.info((Object)String.format("Deleting Organisation %1$s", name));
                }
                break;
            }
            default: {
                LOG.error((Object)String.format("Unknown delete method : %1$s", deleteMethod));
            }
        }
    }

    public static void addOrganizationUser(com.liferay.portal.kernel.model.Organization organization, User user) {
        LOG.info((Object)String.format("Adding user with screenName: %1$sto organization with name: %2$s", user.getScreenName(), organization.getName()));
        OrganizationLocalServiceUtil.addUserOrganization((long)user.getUserId(), (com.liferay.portal.kernel.model.Organization)organization);
    }

    public static void addOrganizationUsers(com.liferay.portal.kernel.model.Organization organization, User ... users) {
        for (int i = 0; i < users.length; ++i) {
            SetupOrganizations.addOrganizationUser(organization, users[i]);
        }
    }

    private static Map<String, Organization> convertOrganisationListToHashMap(List<Organization> objects) {
        HashMap<String, Organization> map = new HashMap<String, Organization>();
        for (Organization organization : objects) {
            map.put(organization.getName(), organization);
        }
        return map;
    }
}

