/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.domain.CustomFieldSetting;
import com.ableneo.liferay.portal.setup.domain.Menu;
import com.ableneo.liferay.portal.setup.domain.MenuItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalServiceUtil;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalServiceUtil;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class SetupMenus {
    private static final Log LOG = LogFactoryUtil.getLog(SetupMenus.class);

    private SetupMenus() {
    }

    public static void setMenus(long groupId, List<Menu> menus) {
        if (menus != null) {
            for (Menu menu : menus) {
                SetupMenus.setMenu(groupId, menu);
            }
        }
    }

    private static void setMenu(long groupId, Menu newMenu) {
        if (newMenu == null) {
            LOG.error((Object)"NULL menu in menu list! Skip.");
            return;
        }
        long userId = SetupConfigurationThreadLocal.getRunAsUserId();
        ServiceContext serviceContext = new ServiceContext();
        String name = newMenu.getName();
        LOG.info((Object)("Adding menu '" + name + "'"));
        List existingMenus = SiteNavigationMenuLocalServiceUtil.getSiteNavigationMenus((long)groupId);
        SiteNavigationMenu menu = null;
        for (SiteNavigationMenu existingMenu : existingMenus) {
            if (!name.equals(existingMenu.getName())) continue;
            LOG.info((Object)(" i '" + name + "' already there"));
            menu = existingMenu;
            break;
        }
        if (menu != null && newMenu.isClearBeforehand()) {
            try {
                LOG.info((Object)(" i '" + name + "' clear-items.."));
                SiteNavigationMenuItemLocalServiceUtil.deleteSiteNavigationMenuItems((long)menu.getPrimaryKey());
            }
            catch (Exception e) {
                LOG.error((Object)("Could not clear existing menu items of '" + name + "'"), (Throwable)e);
                return;
            }
        }
        if (menu == null) {
            LOG.info((Object)(" i '" + name + "' create.."));
            try {
                menu = SiteNavigationMenuLocalServiceUtil.addSiteNavigationMenu((long)userId, (long)groupId, (String)name, (ServiceContext)serviceContext);
                LOG.info((Object)(" i '" + name + "' create OK"));
            }
            catch (PortalException e) {
                LOG.error((Object)("Could not create new menu '" + name + "'"), (Throwable)e);
                return;
            }
        }
        SetupMenus.createMenuItems(groupId, newMenu, userId, serviceContext, menu);
    }

    private static void createMenuItems(long groupId, Menu newMenu, long userId, ServiceContext serviceContext, SiteNavigationMenu menu) {
        LOG.info((Object)("Adding menu-items for '" + menu.getName() + "'"));
        long parentMenuId = menu.getPrimaryKey();
        long parentMenuItem = 0L;
        for (MenuItem newMenuItem : newMenu.getMenuItem()) {
            SiteNavigationMenuItem menuItem = null;
            menuItem = SetupMenus.createMenuItem(groupId, userId, serviceContext, parentMenuId, parentMenuItem, newMenuItem);
            if (menuItem == null || newMenuItem.getMenuItem().isEmpty()) continue;
            SetupMenus.createMenuItems(groupId, userId, serviceContext, menu, menuItem, newMenuItem);
        }
    }

    private static void createMenuItems(long groupId, long userId, ServiceContext serviceContext, SiteNavigationMenu parentMenu, SiteNavigationMenuItem parentMenuItem, MenuItem addFromMenuItems) {
        String parentName = parentMenuItem.getName();
        LOG.info((Object)(" i creating sub-menu-items under '" + parentName + "'"));
        long parentMenuId = parentMenu.getPrimaryKey();
        long parentMenuItemId = parentMenuItem.getPrimaryKey();
        for (MenuItem newMenuItem : addFromMenuItems.getMenuItem()) {
            SiteNavigationMenuItem menuItem = null;
            menuItem = SetupMenus.createMenuItem(groupId, userId, serviceContext, parentMenuId, parentMenuItemId, newMenuItem);
            if (menuItem == null || newMenuItem.getMenuItem().isEmpty()) continue;
            SetupMenus.createMenuItems(groupId, userId, serviceContext, parentMenu, menuItem, newMenuItem);
        }
    }

    private static SiteNavigationMenuItem createMenuItem(long groupId, long userId, ServiceContext serviceContext, long parentMenuId, long parentMenuItem, MenuItem newMenuItem) {
        String type = newMenuItem.getType();
        type = false == newMenuItem.getMenuItem().isEmpty() ? "node" : (type == null || "".equals(type) ? "url" : "url");
        LOG.info((Object)(" i setting item '" + newMenuItem.getName() + "' as '" + type + "': [" + newMenuItem.getTypeSettings() + "]"));
        String typeSettings = newMenuItem.getTypeSettings();
        SiteNavigationMenuItem savedItem = null;
        try {
            List items = SiteNavigationMenuItemLocalServiceUtil.getSiteNavigationMenuItems((long)parentMenuId, (long)parentMenuItem);
            for (SiteNavigationMenuItem item : items) {
                if (!item.getName().equals(newMenuItem.getName())) continue;
                LOG.info((Object)("existing menu-item[" + newMenuItem.getName() + "]"));
                savedItem = item;
                break;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not list/find existing menu item '" + newMenuItem.getName() + "', CREATE NEW : "), (Throwable)e);
        }
        if (savedItem == null) {
            try {
                serviceContext.setUuid(UUID.randomUUID().toString());
                LOG.info((Object)("Inserting menu-item[" + newMenuItem.getName() + "]"));
                savedItem = SiteNavigationMenuItemLocalServiceUtil.addSiteNavigationMenuItem((long)userId, (long)groupId, (long)parentMenuId, (long)parentMenuItem, (String)type, (String)typeSettings, (ServiceContext)serviceContext);
            }
            catch (PortalException e) {
                LOG.error((Object)("Can not add menu item '" + newMenuItem.getName() + "' : "), (Throwable)e);
                return null;
            }
        }
        try {
            LOG.info((Object)("Updating menu-item[" + newMenuItem.getName() + "] @" + savedItem.getPrimaryKey() + ""));
            savedItem.setName(newMenuItem.getName());
            savedItem.setType(type);
            savedItem.setTypeSettings(typeSettings);
            savedItem = SiteNavigationMenuItemLocalServiceUtil.updateSiteNavigationMenuItem((SiteNavigationMenuItem)savedItem);
        }
        catch (Exception e) {
            LOG.error((Object)("Can not update menu item '" + newMenuItem.getName() + "' : "), (Throwable)e);
            return null;
        }
        for (CustomFieldSetting cfs : newMenuItem.getCustomFieldSetting()) {
            savedItem.getExpandoBridge().setAttribute(cfs.getKey(), (Serializable)((Object)cfs.getValue()), false);
        }
        return savedItem;
    }

    private static SiteNavigationMenuItem getExistingFromList(MenuItem newMenuItem, List<SiteNavigationMenuItem> currentItems) {
        if (newMenuItem == null || currentItems.isEmpty()) {
            return null;
        }
        for (SiteNavigationMenuItem item : currentItems) {
            if (!newMenuItem.getName().equals(item.getName())) continue;
            return item;
        }
        return null;
    }
}

