/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.util.DocumentUtil;
import com.ableneo.liferay.portal.setup.core.util.FolderUtil;
import com.ableneo.liferay.portal.setup.core.util.ResourcesUtil;
import com.ableneo.liferay.portal.setup.domain.Document;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SetupDocuments {
    private static final Logger LOG = LoggerFactory.getLogger(SetupDocuments.class);
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS = new HashMap();

    private SetupDocuments() {
    }

    public static void setupSiteDocuments(Site site, long groupId) {
        for (Document doc : site.getDocument()) {
            String folderPath = doc.getDocumentFolderName();
            String documentName = doc.getDocumentFilename();
            String documentTitle = doc.getDocumentTitle();
            String filenameInFilesystem = doc.getFileSystemName();
            long userId = SetupConfigurationThreadLocal.getRunAsUserId();
            long company = SetupConfigurationThreadLocal.getRunInCompanyId();
            switch (doc.getFileUploadType()) {
                case GENERAL: {
                    break;
                }
                case LOGO_IMAGE: {
                    try {
                        Group controlPanelGroup = GroupLocalServiceUtil.loadGetGroup((long)company, (String)"Control Panel");
                        groupId = controlPanelGroup.getGroupId();
                        break;
                    }
                    catch (PortalException e) {
                        LOG.error("Can not get group for Control Panel and company " + company + ":", (Throwable)e);
                        return;
                    }
                }
                default: {
                    LOG.error("Can not understand enum value '" + (Object)((Object)doc.getFileUploadType()) + "' as upload-type.. check dependencies, implement on need!");
                    return;
                }
            }
            long repoId = groupId;
            FileEntry fe = DocumentUtil.findDocument(documentName, folderPath, groupId, groupId);
            byte[] fileBytes = null;
            try {
                fileBytes = ResourcesUtil.getFileBytes(filenameInFilesystem);
            }
            catch (IOException e) {
                LOG.error(String.format("Can not read file: %1$s. Skipping file", filenameInFilesystem));
                continue;
            }
            if (fileBytes == null) continue;
            if (fe == null) {
                Folder folder = null;
                if (Validator.isBlank((String)folderPath)) {
                    folder = FolderUtil.findFolder(groupId, repoId, folderPath, true);
                } else {
                    try {
                        folder = DLAppLocalServiceUtil.getMountFolder((long)repoId);
                    }
                    catch (PortalException e) {
                        LOG.warn("Mount folder not found for file [{}], stopped creating the document.", (Object)documentName, (Object)e);
                    }
                }
                if (folder != null) {
                    LOG.info("{} is not found! It will be created! (c: {},grp: {}", new Object[]{documentName, company, groupId});
                    fe = DocumentUtil.createDocument(groupId, folder.getFolderId(), documentName, documentTitle, userId, repoId, fileBytes);
                }
            } else {
                LOG.info(documentName + " is found! Content will be updated! (c:" + company + ",grp:" + groupId + " ");
                DocumentUtil.updateFile(fe, fileBytes, userId, documentName);
            }
            SetupPermissions.updatePermission(String.format("Document %1$s/%2$s", folderPath, documentName), company, fe.getFileEntryId(), DLFileEntry.class, doc.getRolePermissions(), DEFAULT_PERMISSIONS);
        }
    }

    static {
        ArrayList<String> actionsOwner = new ArrayList<String>();
        actionsOwner.add("ADD_DISCUSSION");
        actionsOwner.add("DELETE");
        actionsOwner.add("DELETE_DISCUSSION");
        actionsOwner.add("OVERRIDE_CHECKOUT");
        actionsOwner.add("PERMISSIONS");
        actionsOwner.add("UPDATE");
        actionsOwner.add("UPDATE_DISCUSSION");
        actionsOwner.add("VIEW");
        DEFAULT_PERMISSIONS.put("Owner", actionsOwner);
        ArrayList<String> actionsUser = new ArrayList<String>();
        actionsUser.add("VIEW");
        DEFAULT_PERMISSIONS.put("User", actionsUser);
        ArrayList<String> actionsGuest = new ArrayList<String>();
        actionsGuest.add("VIEW");
        DEFAULT_PERMISSIONS.put("Guest", actionsGuest);
        ArrayList<String> actionsViewer = new ArrayList<String>();
        actionsViewer.add("VIEW");
        DEFAULT_PERMISSIONS.put("Site Member", actionsViewer);
    }
}

