/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.util.FolderUtil;
import com.ableneo.liferay.portal.setup.domain.DocumentFolder;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.repository.model.Folder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class SetupDocumentFolders {
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS = new HashMap();

    private SetupDocumentFolders() {
    }

    public static void setupDocumentFolders(Site group, long groupId) {
        for (DocumentFolder df : group.getDocumentFolder()) {
            boolean create = df.isCreateIfNotExists();
            String folderName = df.getFolderName();
            long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            Folder folder = FolderUtil.findFolder(groupId, groupId, folderName, create);
            SetupPermissions.updatePermission(String.format("Document folder %1$s", folderName), companyId, folder.getFolderId(), DLFolder.class, df.getRolePermissions(), DEFAULT_PERMISSIONS);
        }
    }

    static {
        ArrayList<String> actionsOwner = new ArrayList<String>();
        actionsOwner.add("VIEW");
        actionsOwner.add("UPDATE");
        actionsOwner.add("PERMISSIONS");
        actionsOwner.add("DELETE");
        actionsOwner.add("ADD_SUBFOLDER");
        actionsOwner.add("ADD_SHORTCUT");
        actionsOwner.add("ADD_DOCUMENT");
        actionsOwner.add("ACCESS");
        actionsOwner.add("SUBSCRIBE");
        DEFAULT_PERMISSIONS.put("Owner", actionsOwner);
        ArrayList<String> actionsUser = new ArrayList<String>();
        actionsUser.add("VIEW");
        DEFAULT_PERMISSIONS.put("User", actionsUser);
        ArrayList<String> actionsGuest = new ArrayList<String>();
        actionsGuest.add("VIEW");
        DEFAULT_PERMISSIONS.put("Guest", actionsGuest);
        ArrayList<String> actionsViewer = new ArrayList<String>();
        actionsViewer.add("VIEW");
        DEFAULT_PERMISSIONS.put("Site Member", actionsViewer);
    }
}

