/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.domain.CustomFields;
import com.ableneo.liferay.portal.setup.domain.RolePermissionType;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalServiceUtil;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public final class SetupCustomFields {
    private static final Log LOG = LogFactoryUtil.getLog(SetupCustomFields.class);

    private SetupCustomFields() {
    }

    public static void setupExpandoFields(List<CustomFields.Field> fields) {
        for (CustomFields.Field field : fields) {
            String className = field.getClassName();
            LOG.info((Object)("Add field " + field.getName() + "(" + className + ") to expando bridge"));
            long runInCompanyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            ExpandoBridge bridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)runInCompanyId, (String)className);
            SetupCustomFields.addAttributeToExpandoBridge(bridge, field);
        }
    }

    private static List<ExpandoColumn> getAllExpandoColumns(List<CustomFields.Field> customFields) {
        ArrayList<ExpandoColumn> all = new ArrayList<ExpandoColumn>();
        TreeSet<String> tables = new TreeSet<String>();
        for (CustomFields.Field field : customFields) {
            try {
                long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                ExpandoTable table = ExpandoTableLocalServiceUtil.getDefaultTable((long)companyId, (String)field.getClassName());
                if (table == null || tables.contains(table.getName())) continue;
                tables.add(table.getName());
                List columns = ExpandoColumnLocalServiceUtil.getColumns((long)companyId, (String)field.getClassName(), (String)table.getName());
                all.addAll(columns);
            }
            catch (PortalException | SystemException e) {
                LOG.error((Object)String.format("Error in getAllExpandoColumns().%1$s", e.getMessage()));
            }
        }
        return all;
    }

    private static void addAttributeToExpandoBridge(ExpandoBridge bridge, CustomFields.Field field) {
        String name = field.getName();
        try {
            int fieldTypeKey = SetupCustomFields.getFieldTypeKey(field.getType());
            if (bridge.hasAttribute(name)) {
                long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn((long)companyId, (String)bridge.getClassName(), (String)"CUSTOM_FIELDS", (String)name);
                ExpandoColumnLocalServiceUtil.updateColumn((long)column.getColumnId(), (String)name, (int)fieldTypeKey, (Object)SetupCustomFields.getAttributeFromString(fieldTypeKey, field.getDefaultData()));
            } else {
                bridge.addAttribute(name, fieldTypeKey, SetupCustomFields.getAttributeFromString(fieldTypeKey, field.getDefaultData()));
            }
            UnicodeProperties properties = bridge.getAttributeProperties(name);
            properties.setProperty("index-type", Integer.toString(SetupCustomFields.getIndexedType(field.getIndexed())));
            properties.setProperty("display-type", SetupCustomFields.getDisplayType(field.getDisplayType()));
            properties.setProperty("localize-field-name", Boolean.FALSE.toString());
            properties.setProperty("localize-field", String.valueOf(field.isLocalizedValue()));
            bridge.setAttributeProperties(name, properties);
            SetupCustomFields.setCustomFieldPermission(field.getRolePermission(), bridge, name);
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("Could not set custom attribute: %1$s", name), e);
        }
    }

    private static void setCustomFieldPermission(List<RolePermissionType> rolePermissions, ExpandoBridge bridge, String fieldName) {
        LOG.info((Object)("Set read permissions on  field " + fieldName + " for " + rolePermissions.size() + " rolePermissions"));
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn((long)companyId, (String)bridge.getClassName(), (String)"CUSTOM_FIELDS", (String)fieldName);
        block8: for (RolePermissionType rolePermission : rolePermissions) {
            String permission;
            String roleName = rolePermission.getRoleName();
            switch (permission = rolePermission.getPermission()) {
                case "update": {
                    SetupPermissions.addReadWrightRight(roleName, ExpandoColumn.class.getName(), String.valueOf(column.getColumnId()));
                    LOG.info((Object)String.format("Added update permission on field %1$s for role %2$s", fieldName, roleName));
                    continue block8;
                }
                case "view": {
                    SetupPermissions.addReadRight(roleName, ExpandoColumn.class.getName(), String.valueOf(column.getColumnId()));
                    LOG.info((Object)String.format("Added read permission on field %1$s for role %2$s", fieldName, roleName));
                    continue block8;
                }
            }
            LOG.info((Object)("Unknown permission:" + permission + ". No permission added on field " + fieldName + " for role " + roleName));
        }
    }

    public static void deleteCustomField(CustomFields.Field customField, String deleteMethod) {
        SetupCustomFields.deleteCustomFields(Arrays.asList(customField), deleteMethod);
    }

    public static void deleteCustomFields(List<CustomFields.Field> customFields, String deleteMethod) {
        block8: {
            block7: {
                if (!"excludeListed".equals(deleteMethod)) break block7;
                List<String> skipFields = SetupCustomFields.attributeNamesList(customFields);
                List<ExpandoColumn> expandoColumns = SetupCustomFields.getAllExpandoColumns(customFields);
                if (expandoColumns == null) break block8;
                for (ExpandoColumn expandoColumn : expandoColumns) {
                    if (skipFields.contains(expandoColumn.getName())) continue;
                    try {
                        ExpandoColumnLocalServiceUtil.deleteColumn((long)expandoColumn.getColumnId());
                    }
                    catch (PortalException | SystemException e) {
                        LOG.error((Object)String.format("Could not delete CustomField %1$s", expandoColumn.getName()), e);
                    }
                }
                break block8;
            }
            if (deleteMethod.equals("onlyListed")) {
                for (CustomFields.Field field : customFields) {
                    try {
                        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
                        ExpandoTable table = ExpandoTableLocalServiceUtil.getDefaultTable((long)companyId, (String)field.getClassName());
                        ExpandoColumnLocalServiceUtil.deleteColumn((long)companyId, (String)field.getClassName(), (String)table.getName(), (String)field.getName());
                    }
                    catch (PortalException | SystemException e) {
                        LOG.error((Object)String.format("Could not delete Custom Field %1$s", field.getName()), e);
                        continue;
                    }
                    LOG.info((Object)String.format("custom field %1$s deleted ", field.getName()));
                }
            }
        }
    }

    private static int getFieldTypeKey(String name) {
        if ("stringArray".equals(name)) {
            return 16;
        }
        if ("string".equals(name)) {
            return 15;
        }
        if ("int".equals(name)) {
            return 9;
        }
        if ("boolean".equals(name)) {
            return 1;
        }
        if ("date".equals(name)) {
            return 3;
        }
        if ("long".equals(name)) {
            return 11;
        }
        if ("double".equals(name)) {
            return 5;
        }
        if ("float".equals(name)) {
            return 7;
        }
        LOG.error((Object)String.format("bad setup name: %1$s", name));
        return -1;
    }

    private static List<String> attributeNamesList(List<CustomFields.Field> customFields) {
        ArrayList<String> names = new ArrayList<String>();
        for (CustomFields.Field f : customFields) {
            if (f.getName() == null) continue;
            names.add(f.getName());
        }
        return names;
    }

    private static int getIndexedType(String indexed) {
        if ("none".equals(indexed)) {
            return 0;
        }
        if ("text".equals(indexed)) {
            return 1;
        }
        if ("keyword".equals(indexed)) {
            return 2;
        }
        LOG.error((Object)String.format("cannot get unknown index type: %1$s", indexed));
        return 0;
    }

    private static String getDisplayType(String displayType) {
        if ("checkbox".equals(displayType)) {
            return "checkbox";
        }
        if ("radio".equals(displayType)) {
            return "radio";
        }
        if ("selection-list".equals(displayType)) {
            return "selection-list";
        }
        if ("text-box".equals(displayType)) {
            return "text-box";
        }
        if ("input-field".equals(displayType)) {
            return "input-field";
        }
        LOG.error((Object)String.format("cannot get unknown display type: %1$s", displayType));
        return "text-box";
    }

    public static Serializable getAttributeFromString(int type, String attribute) {
        if (attribute == null) {
            return null;
        }
        if (type == 1) {
            return Boolean.valueOf(GetterUtil.getBoolean((String)attribute));
        }
        if (type == 2) {
            return GetterUtil.getBooleanValues((String[])StringUtil.split((String)attribute));
        }
        if (type == 3) {
            return GetterUtil.getDate((String)attribute, (DateFormat)SetupCustomFields.getDateFormat());
        }
        if (type == 4) {
            return GetterUtil.getDateValues((String[])StringUtil.split((String)attribute), (DateFormat)SetupCustomFields.getDateFormat());
        }
        if (type == 5) {
            return Double.valueOf(GetterUtil.getDouble((String)attribute));
        }
        if (type == 6) {
            return GetterUtil.getDoubleValues((String[])StringUtil.split((String)attribute));
        }
        if (type == 7) {
            return Float.valueOf(GetterUtil.getFloat((String)attribute));
        }
        if (type == 8) {
            return GetterUtil.getFloatValues((String[])StringUtil.split((String)attribute));
        }
        if (type == 9) {
            return Integer.valueOf(GetterUtil.getInteger((String)attribute));
        }
        if (type == 10) {
            return GetterUtil.getIntegerValues((String[])StringUtil.split((String)attribute));
        }
        if (type == 11) {
            return Long.valueOf(GetterUtil.getLong((String)attribute));
        }
        if (type == 12) {
            return GetterUtil.getLongValues((String[])StringUtil.split((String)attribute));
        }
        if (type == 13) {
            return Short.valueOf(GetterUtil.getShort((String)attribute));
        }
        if (type == 14) {
            return GetterUtil.getShortValues((String[])StringUtil.split((String)attribute));
        }
        if (type == 16) {
            return StringUtil.split((String)attribute);
        }
        return attribute;
    }

    private static DateFormat getDateFormat() {
        return DateUtil.getISO8601Format();
    }
}

