/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup.core;

import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.util.ResolverUtil;
import com.ableneo.liferay.portal.setup.core.util.ResourcesUtil;
import com.ableneo.liferay.portal.setup.core.util.TaggingUtil;
import com.ableneo.liferay.portal.setup.core.util.TranslationMapUtil;
import com.ableneo.liferay.portal.setup.core.util.WebFolderUtil;
import com.ableneo.liferay.portal.setup.domain.Adt;
import com.ableneo.liferay.portal.setup.domain.Article;
import com.ableneo.liferay.portal.setup.domain.ArticleTemplate;
import com.ableneo.liferay.portal.setup.domain.DdlRecordset;
import com.ableneo.liferay.portal.setup.domain.RelatedAsset;
import com.ableneo.liferay.portal.setup.domain.RelatedAssets;
import com.ableneo.liferay.portal.setup.domain.RolePermissions;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.ableneo.liferay.portal.setup.domain.StructureType;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetLinkLocalServiceUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.dynamic.data.mapping.exception.TemplateDuplicateTemplateKeyException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class SetupArticles {
    private static final Log LOG = LogFactoryUtil.getLog(SetupArticles.class);
    private static final HashMap<String, List<String>> DEFAULT_PERMISSIONS = new HashMap();
    private static final HashMap<String, List<String>> DEFAULT_DDM_PERMISSIONS = new HashMap();
    private static final int ARTICLE_PUBLISH_YEAR = 2008;
    private static final int MIN_DISPLAY_ROWS = 10;

    private SetupArticles() {
    }

    public static void setupSiteStructuresAndTemplates(Site site, long groupId) throws PortalException {
        List<ArticleTemplate> articleTemplates;
        List<StructureType> ddlStructures;
        List<StructureType> articleStructures = site.getArticleStructure();
        if (articleStructures != null && !articleStructures.isEmpty()) {
            long classNameId = ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class);
            for (StructureType structureType : articleStructures) {
                SetupArticles.addDDMStructure(structureType, groupId, classNameId);
            }
        }
        if ((ddlStructures = site.getDdlStructure()) != null && !ddlStructures.isEmpty()) {
            long classNameId = ClassNameLocalServiceUtil.getClassNameId(DDLRecordSet.class);
            for (StructureType structure : ddlStructures) {
                LOG.info((Object)String.format("Adding DDL structure %1$s", structure.getName()));
                SetupArticles.addDDMStructure(structure, groupId, classNameId);
            }
        }
        if ((articleTemplates = site.getArticleTemplate()) != null) {
            for (ArticleTemplate articleTemplate : articleTemplates) {
                try {
                    SetupArticles.addDDMTemplate(articleTemplate, groupId);
                }
                catch (TemplateDuplicateTemplateKeyException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public static void setupSiteArticles(List<Article> articles, List<Adt> adts, List<DdlRecordset> recordSets, long groupId) throws PortalException {
        if (articles != null) {
            for (Article article : articles) {
                SetupArticles.addJournalArticle(article, groupId);
            }
        }
        if (adts != null) {
            for (Adt template : adts) {
                try {
                    SetupArticles.addDDMTemplate(template, groupId);
                }
                catch (TemplateDuplicateTemplateKeyException | IOException e) {
                    LOG.error((Object)String.format("Error in adding ADT: %1$s", template.getName()), e);
                }
            }
        }
        if (recordSets != null) {
            for (DdlRecordset recordSet : recordSets) {
                try {
                    SetupArticles.addDDLRecordSet(recordSet, groupId);
                }
                catch (TemplateDuplicateTemplateKeyException e) {
                    LOG.error((Object)String.format("Error in adding DDLRecordSet: %1$s", recordSet.getName()), (Throwable)e);
                }
            }
        }
    }

    public static void addDDMStructure(StructureType structure, long groupId, long classNameId) throws PortalException {
        LOG.info((Object)String.format("Adding Article structure %1$s", structure.getName()));
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        Locale siteDefaultLocale = null;
        try {
            siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
        }
        catch (PortalException e) {
            LOG.error((Throwable)e);
        }
        String name = SetupArticles.getStructureNameOrKey(structure);
        nameMap.put(LocaleUtil.US, name);
        nameMap.put(siteDefaultLocale, name);
        HashMap descMap = new HashMap();
        String content = null;
        DDMForm ddmForm = null;
        DDMFormLayout ddmFormLayout = null;
        try {
            content = ResourcesUtil.getFileContent(structure.getPath());
            ddmForm = DDMUtil.getDDMForm((String)content);
            if (ddmForm == null) {
                LOG.error((Object)"Can not parse given structure JSON content into Liferay DDMForm.");
                return;
            }
            ddmFormLayout = DDMUtil.getDefaultDDMFormLayout((DDMForm)ddmForm);
        }
        catch (IOException e) {
            LOG.error((Object)String.format("Error Reading Structure File content for: %1$s", structure.getName()));
            return;
        }
        catch (PortalException e) {
            LOG.error((Object)"Can not parse given structure JSON content into Liferay DDMForm.", (Throwable)e);
            return;
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Other error while trying to get content of the structure file. Possibly wrong filesystem path (%1$s)?", structure.getPath()), (Throwable)e);
            return;
        }
        Locale contentDefaultLocale = ddmForm.getDefaultLocale();
        if (!contentDefaultLocale.equals(siteDefaultLocale)) {
            nameMap.put(contentDefaultLocale, name);
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)classNameId, (String)structure.getKey());
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        if (ddmStructure != null) {
            LOG.info((Object)"Structure already exists and will be overwritten.");
            if (structure.getParent() != null && !structure.getParent().isEmpty()) {
                LOG.info((Object)String.format("Setting up parent structure: %1$s", structure.getName()));
                DDMStructure parentStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)classNameId, (String)structure.getParent(), (boolean)true);
                if (parentStructure != null) {
                    ddmStructure.setParentStructureId(parentStructure.getStructureId());
                } else {
                    LOG.info((Object)String.format("Parent structure not found: %1$s", structure.getName()));
                }
            }
            DDMStructure ddmStructureSaved = DDMStructureLocalServiceUtil.updateStructure((long)runAsUserId, (long)ddmStructure.getStructureId(), (long)ddmStructure.getParentStructureId(), nameMap, descMap, (DDMForm)ddmForm, (DDMFormLayout)ddmFormLayout, (ServiceContext)new ServiceContext());
            LOG.info((Object)String.format("Template successfully updated: %1$s", structure.getName()));
            SetupPermissions.updatePermission(String.format("Structure %1$s", structure.getKey()), companyId, ddmStructureSaved.getStructureId(), DDMStructure.class.getName() + "-" + JournalArticle.class.getName(), structure.getRolePermissions(), DEFAULT_DDM_PERMISSIONS);
            return;
        }
        DDMStructure newStructure = DDMStructureLocalServiceUtil.addStructure((long)runAsUserId, (long)groupId, (String)structure.getParent(), (long)classNameId, (String)structure.getKey(), nameMap, descMap, (DDMForm)ddmForm, (DDMFormLayout)ddmFormLayout, (String)StorageType.JSON.getValue(), (int)0, (ServiceContext)new ServiceContext());
        SetupPermissions.updatePermission(String.format("Structure %1$s", structure.getKey()), companyId, newStructure.getStructureId(), DDMStructure.class.getName() + "-" + JournalArticle.class.getName(), structure.getRolePermissions(), DEFAULT_DDM_PERMISSIONS);
        LOG.info((Object)String.format("Added Article structure: %1$s", newStructure.getName()));
    }

    private static String getStructureNameOrKey(StructureType structure) {
        if (structure.getName() == null) {
            return structure.getName();
        }
        return structure.getKey();
    }

    public static void addDDMTemplate(ArticleTemplate template, long groupId) throws PortalException {
        String script;
        LOG.info((Object)String.format("Adding Article template %1$s", template.getName()));
        long classNameId = ClassNameLocalServiceUtil.getClassNameId(DDMStructure.class);
        long resourceClassnameId = ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class);
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
        String name = template.getName();
        if (name == null) {
            name = template.getKey();
        }
        nameMap.put(siteDefaultLocale, name);
        nameMap.put(LocaleUtil.US, name);
        HashMap descMap = new HashMap();
        try {
            script = ResourcesUtil.getFileContent(template.getPath());
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error Reading Template File content for: %1$s", template.getName()));
            return;
        }
        long classPK = 0L;
        if (template.getArticleStructureKey() != null) {
            try {
                classPK = ResolverUtil.getStructureId(template.getArticleStructureKey(), groupId, JournalArticle.class.getName(), true);
            }
            catch (PortalException e) {
                LOG.error((Object)String.format("Given article structure with ID: %1$s can not be found. Therefore, article template can not be added/changed.", template.getArticleStructureKey()), (Throwable)e);
                return;
            }
        }
        DDMTemplate ddmTemplate = null;
        try {
            ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)groupId, (long)classNameId, (String)template.getKey());
        }
        catch (SystemException e) {
            LOG.error((Object)String.format("Error while trying to find template with key: %1$s", template.getKey()), (Throwable)e);
        }
        if (ddmTemplate != null) {
            LOG.info((Object)"Template already exists and will be overwritten.");
            ddmTemplate.setNameMap(nameMap);
            ddmTemplate.setLanguage(template.getLanguage());
            ddmTemplate.setScript(script);
            ddmTemplate.setClassPK(classPK);
            ddmTemplate.setCacheable(template.isCacheable());
            DDMTemplateLocalServiceUtil.updateDDMTemplate((DDMTemplate)ddmTemplate);
            LOG.info((Object)String.format("Template successfully updated: %1$s", ddmTemplate.getName()));
            return;
        }
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        DDMTemplate newTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)runAsUserId, (long)groupId, (long)classNameId, (long)classPK, (long)resourceClassnameId, (String)template.getKey(), nameMap, descMap, (String)"display", null, (String)template.getLanguage(), (String)script, (boolean)template.isCacheable(), (boolean)false, null, null, (ServiceContext)new ServiceContext());
        LOG.info((Object)String.format("Added Article template: %1$s", newTemplate.getName()));
    }

    public static void addDDMTemplate(Adt template, long groupId) throws PortalException, IOException {
        LOG.info((Object)String.format("Adding ADT %1$s", template.getName()));
        long classNameId = PortalUtil.getClassNameId((String)template.getClassName());
        long resourceClassnameId = Validator.isBlank((String)template.getResourceClassName()) ? ClassNameLocalServiceUtil.getClassNameId(JournalArticle.class) : ClassNameLocalServiceUtil.getClassNameId((String)template.getResourceClassName());
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
        String name = template.getName();
        if (name == null) {
            name = template.getTemplateKey();
        }
        nameMap.put(LocaleUtil.US, name);
        nameMap.put(siteDefaultLocale, name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(siteDefaultLocale, template.getDescription());
        String language = template.getLanguage() == null ? "ftl" : template.getLanguage();
        DDMTemplate ddmTemplate = null;
        try {
            ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)groupId, (long)classNameId, (String)template.getTemplateKey());
        }
        catch (SystemException e) {
            LOG.error((Object)String.format("Error while trying to find ADT with key: %1$s", template.getTemplateKey()));
        }
        String script = ResourcesUtil.getFileContent(template.getPath());
        if (ddmTemplate != null) {
            LOG.info((Object)"Template already exists and will be overwritten.");
            ddmTemplate.setLanguage(language);
            ddmTemplate.setNameMap(nameMap);
            ddmTemplate.setDescriptionMap(descriptionMap);
            ddmTemplate.setClassName(template.getClassName());
            ddmTemplate.setCacheable(template.isCacheable());
            ddmTemplate.setScript(script);
            DDMTemplateLocalServiceUtil.updateDDMTemplate((DDMTemplate)ddmTemplate);
            LOG.info((Object)String.format("ADT successfully updated: %1$s", ddmTemplate.getName()));
            return;
        }
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        DDMTemplate newTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)runAsUserId, (long)groupId, (long)classNameId, (long)0L, (long)resourceClassnameId, (String)template.getTemplateKey(), nameMap, descriptionMap, (String)"display", null, (String)language, (String)script, (boolean)true, (boolean)false, null, null, (ServiceContext)new ServiceContext());
        LOG.info((Object)String.format("Added ADT: %1$s", newTemplate.getName()));
    }

    public static void getJournalArticleByPath(String folder, String file) {
    }

    public static long getCreateFolderId(String folder, long groupId, RolePermissions roles) {
        long folderId = 0L;
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        if (folder != null && !"".equals(folder)) {
            JournalFolder jf = WebFolderUtil.findWebFolder(companyId, groupId, runAsUserId, folder, "", true, roles);
            if (jf == null) {
                LOG.warn((Object)("Specified webfolder " + folder + " of not found! Will put article into web content root folder!"));
            } else {
                folderId = jf.getFolderId();
            }
        }
        return folderId;
    }

    public static void addJournalArticle(Article article, long groupId) {
        LOG.info((Object)String.format("Adding Journal Article %1$s", article.getTitle()));
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        long companyId = SetupConfigurationThreadLocal.getRunInCompanyId();
        String content = null;
        long folderId = SetupArticles.getCreateFolderId(article.getArticleFolderPath(), groupId, article.getRolePermissions());
        try {
            content = ResourcesUtil.getFileContent(article.getPath());
            content = ResolverUtil.lookupAll(groupId, companyId, content, article.getPath());
            LOG.info((Object)String.format(" - Article File content for article ID: %1$s : path:%2$s", article.getArticleId(), article.getPath()));
        }
        catch (IOException e) {
            LOG.error((Object)String.format("Error Reading Article File content for article ID: %1$s", article.getArticleId()));
        }
        Map<Locale, String> titleMap = TranslationMapUtil.getTranslationMap(article.getTitleTranslation(), groupId, article.getTitle(), String.format(" Article with title %1$s", article.getArticleId()));
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)content));
        if (!titleMap.containsKey(articleDefaultLocale)) {
            titleMap.put(articleDefaultLocale, article.getTitle());
        }
        Map<Locale, String> descriptionMap = null;
        if (article.getArticleDescription() != null && !article.getArticleDescription().isEmpty() && !(descriptionMap = TranslationMapUtil.getTranslationMap(article.getDescriptionTranslation(), groupId, article.getArticleDescription(), String.format(" Article with description %1$s", article.getArticleId()))).containsKey(articleDefaultLocale)) {
            descriptionMap.put(articleDefaultLocale, article.getArticleDescription());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        JournalArticle journalArticle = null;
        boolean generatedId = article.getArticleId().isEmpty();
        if (generatedId) {
            LOG.info((Object)String.format("Article %1$s will have autogenerated ID.", article.getTitle()));
        } else {
            journalArticle = SetupArticles.getJournalArticle(article.getArticleId(), folderId, groupId, article.getArticleFolderPath());
        }
        try {
            if (journalArticle == null) {
                try {
                    journalArticle = JournalArticleLocalServiceUtil.addArticle((long)runAsUserId, (long)groupId, (long)folderId, (long)0L, (long)0L, (String)article.getArticleId(), (boolean)generatedId, (double)1.0, titleMap, descriptionMap, (String)content, (String)article.getArticleStructureKey(), (String)article.getArticleTemplateKey(), (String)"", (int)1, (int)1, (int)2008, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (boolean)true, (int)0, (int)0, (int)0, (int)0, (int)0, (boolean)true, (boolean)true, (boolean)false, (String)"", null, null, (String)"", (ServiceContext)serviceContext);
                    LOG.info((Object)String.format("Added JournalArticle %1$s with ID: %2$s", journalArticle.getTitle(), journalArticle.getArticleId()));
                    Indexer bi = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                    if (bi != null) {
                        bi.reindex((Object)journalArticle);
                    }
                }
                catch (PortalException e) {
                    LOG.error((Object)String.format("Error while trying to add Article with Title: %1$s", article.getTitle()), (Throwable)e);
                }
            } else {
                try {
                    LOG.info((Object)("Article " + article.getTitle() + " with article ID: " + article.getArticleId() + " already exists. Will be overwritten."));
                    journalArticle.setTitleMap(titleMap);
                    journalArticle.setContent(content);
                    journalArticle.setDescriptionMap(descriptionMap);
                    JournalArticleLocalServiceUtil.updateJournalArticle((JournalArticle)journalArticle);
                    if (journalArticle.getFolderId() != folderId) {
                        JournalArticleLocalServiceUtil.moveArticle((long)groupId, (String)journalArticle.getArticleId(), (long)folderId, (ServiceContext)ServiceContextThreadLocal.getServiceContext());
                    }
                    LOG.info((Object)String.format("Updated JournalArticle: %1$s", journalArticle.getTitle()));
                }
                catch (PortalException e) {
                    LOG.error((Object)String.format("Error while trying to update Article with Title: %1$s", article.getTitle()), (Throwable)e);
                }
            }
            if (journalArticle != null) {
                TaggingUtil.associateTagsAndCategories(groupId, article, journalArticle);
                SetupArticles.processRelatedAssets(article, journalArticle, runAsUserId, groupId, companyId);
                SetupPermissions.updatePermission(String.format("Article %1$s", journalArticle.getArticleId()), companyId, journalArticle.getResourcePrimKey(), JournalArticle.class, article.getRolePermissions(), DEFAULT_PERMISSIONS);
                article.setArticleId(String.valueOf(journalArticle.getId()));
            } else {
                LOG.error((Object)String.format("Error while trying to add/update Article-Permission with Title: %1$s; see previous error.", article.getTitle()));
            }
        }
        catch (PortalException e) {
            LOG.error((Object)String.format("Error while trying to add/update Article-Permission with Title: %1$s", article.getTitle()), (Throwable)e);
        }
    }

    public static JournalArticle getJournalArticle(String articleId, long folderId, long groupId, String folderPathForTheLog) {
        JournalArticle journalArticle = null;
        try {
            List articlesInFolder = JournalArticleLocalServiceUtil.getArticles((long)groupId, (long)folderId);
            if (articlesInFolder == null || articlesInFolder.isEmpty()) {
                LOG.warn((Object)String.format("No such article : %1$s / %2$s (%3$s)", folderPathForTheLog, articleId, folderId));
                return null;
            }
            ArrayList<JournalArticle> withSameArticleId = new ArrayList<JournalArticle>();
            for (JournalArticle art : articlesInFolder) {
                LOG.info((Object)(" - " + folderPathForTheLog + "/" + art.getArticleId()));
                if (!articleId.equalsIgnoreCase(art.getArticleId())) continue;
                if (art.getStatus() == 0) {
                    LOG.info((Object)String.format(" - found article [%1$s] with same name [%1$s]", articleId));
                    withSameArticleId.add(art);
                    continue;
                }
                LOG.info((Object)String.format(" - found article which is not 'approved' [%1$s], leave-alone", articleId));
            }
            if (!withSameArticleId.isEmpty()) {
                if (withSameArticleId.size() == 1) {
                    LOG.info((Object)String.format("FOUND article with ID: %1$s and directory:%2$s (%3$s)", articleId, folderPathForTheLog, folderId));
                    journalArticle = (JournalArticle)withSameArticleId.get(0);
                } else {
                    LOG.warn((Object)String.format("MULTIPLE article with ID: %1$s and directory:%2$s (%3$s)", articleId, folderPathForTheLog, folderId));
                    for (int i = 0; i < withSameArticleId.size(); ++i) {
                        JournalArticle ja = (JournalArticle)withSameArticleId.get(i);
                        if (ja.getLastPublishDate() == null) continue;
                        if (journalArticle == null) {
                            journalArticle = ja;
                            continue;
                        }
                        if (ja.getLastPublishDate() == null || !ja.getLastPublishDate().after(journalArticle.getLastPublishDate())) continue;
                        journalArticle = ja;
                    }
                    if (journalArticle == null) {
                        LOG.warn((Object)String.format("No article amongst multiple: %1$s and directory:%2$s (%3$s)", articleId, folderPathForTheLog, folderId));
                    } else {
                        LOG.info((Object)String.format("SELECTED article with ID: %1$s and directory:%2$s (%3$s)", articleId, folderPathForTheLog, folderId));
                    }
                }
            } else {
                LOG.warn((Object)String.format("Cannot find article with ID: %1$s and directory:%2$s (%3$s)", articleId, folderPathForTheLog, folderId));
            }
        }
        catch (SystemException e) {
            LOG.error((Object)String.format("Error while trying to find article with ID: %1$s", articleId), (Throwable)e);
        }
        return journalArticle;
    }

    private static void addDDLRecordSet(DdlRecordset recordSet, long groupId) throws PortalException {
        LOG.info((Object)String.format("Adding DDLRecordSet %1$s", recordSet.getName()));
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
        nameMap.put(siteDefaultLocale, recordSet.getName());
        HashMap<Locale, String> descMap = new HashMap<Locale, String>();
        descMap.put(siteDefaultLocale, recordSet.getDescription());
        DDLRecordSet ddlRecordSet = null;
        try {
            ddlRecordSet = DDLRecordSetLocalServiceUtil.fetchRecordSet((long)groupId, (String)recordSet.getKey());
        }
        catch (SystemException e) {
            LOG.error((Object)String.format("Error while trying to find DDLRecordSet with key: %1$s", recordSet.getKey()), (Throwable)e);
        }
        if (ddlRecordSet != null) {
            LOG.info((Object)"DDLRecordSet already exists and will be overwritten.");
            ddlRecordSet.setNameMap(nameMap);
            ddlRecordSet.setDescriptionMap(descMap);
            ddlRecordSet.setDDMStructureId(ResolverUtil.getStructureId(recordSet.getDdlStructureKey(), groupId, DDLRecordSet.class.getName(), false));
            DDLRecordSetLocalServiceUtil.updateDDLRecordSet((DDLRecordSet)ddlRecordSet);
            LOG.info((Object)String.format("DDLRecordSet successfully updated: %1$s", recordSet.getName()));
            return;
        }
        long runAsUserId = SetupConfigurationThreadLocal.getRunAsUserId();
        DDLRecordSet newDDLRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)runAsUserId, (long)groupId, (long)ResolverUtil.getStructureId(recordSet.getDdlStructureKey(), groupId, DDLRecordSet.class.getName(), false), (String)recordSet.getDdlStructureKey(), nameMap, descMap, (int)10, (int)0, (ServiceContext)new ServiceContext());
        LOG.info((Object)String.format("Added DDLRecordSet: %1$s", newDDLRecordSet.getName()));
    }

    public static Long getJournalAssetEntryId(JournalArticle ja) {
        try {
            AssetEntry ae = AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)ja.getResourcePrimKey());
            return ae.getEntryId();
        }
        catch (PortalException | SystemException e) {
            LOG.error((Object)String.format("Problem clearing related assets of article %1$s", ja.getArticleId()), e);
            return null;
        }
    }

    public static void processRelatedAssets(Article article, JournalArticle ja, long runAsUserId, long groupId, long companyId) {
        if (article.getRelatedAssets() != null) {
            RelatedAssets ras = article.getRelatedAssets();
            AssetEntry ae = null;
            if (ras.isClearAllAssets()) {
                try {
                    ae = AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)ja.getResourcePrimKey());
                    AssetLinkLocalServiceUtil.deleteLinks((long)ae.getEntryId());
                }
                catch (PortalException | SystemException e) {
                    LOG.error((Object)String.format("Problem clearing related assets of article %1$s", ja.getArticleId()), e);
                }
            }
            if (ras.getRelatedAsset() != null && !ras.getRelatedAsset().isEmpty()) {
                List<RelatedAsset> ra = ras.getRelatedAsset();
                for (RelatedAsset r : ra) {
                    String clazz = r.getAssetClass();
                    String clazzPrimKey = r.getAssetClassPrimaryKey();
                    String resolverHint = "Related asset for article " + ja.getArticleId() + " clazz " + clazz + ", primary key " + clazzPrimKey;
                    clazzPrimKey = ResolverUtil.lookupAll(groupId, companyId, clazzPrimKey, resolverHint);
                    long id = 0L;
                    try {
                        id = Long.parseLong(clazzPrimKey);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Class primary key is not parseable as long value.", (Throwable)ex);
                    }
                    try {
                        AssetEntry ae2 = AssetEntryLocalServiceUtil.getEntry((String)clazz, (long)id);
                        AssetLinkLocalServiceUtil.addLink((long)runAsUserId, (long)ae.getEntryId(), (long)ae2.getEntryId(), (int)0, (int)1);
                    }
                    catch (PortalException | SystemException e) {
                        LOG.error((Object)("Problem resolving related asset of article " + ja.getArticleId() + " with clazz " + clazz + " primary key " + clazzPrimKey), e);
                    }
                }
            }
        }
    }

    static {
        ArrayList<String> actionsOwner = new ArrayList<String>();
        actionsOwner.add("VIEW");
        actionsOwner.add("ADD_DISCUSSION");
        actionsOwner.add("DELETE");
        actionsOwner.add("DELETE_DISCUSSION");
        actionsOwner.add("EXPIRE");
        actionsOwner.add("PERMISSIONS");
        actionsOwner.add("UPDATE");
        actionsOwner.add("UPDATE_DISCUSSION");
        ArrayList<String> ddmActionsOwner = new ArrayList<String>();
        ddmActionsOwner.add("VIEW");
        ddmActionsOwner.add("DELETE");
        ddmActionsOwner.add("UPDATE");
        ddmActionsOwner.add("PERMISSIONS");
        DEFAULT_PERMISSIONS.put("Owner", actionsOwner);
        DEFAULT_DDM_PERMISSIONS.put("Owner", ddmActionsOwner);
        ArrayList<String> actionsUser = new ArrayList<String>();
        actionsUser.add("VIEW");
        DEFAULT_PERMISSIONS.put("User", actionsUser);
        DEFAULT_DDM_PERMISSIONS.put("User", actionsUser);
        ArrayList<String> actionsGuest = new ArrayList<String>();
        actionsGuest.add("VIEW");
        DEFAULT_PERMISSIONS.put("Guest", actionsGuest);
        DEFAULT_DDM_PERMISSIONS.put("Guest", actionsGuest);
        ArrayList<String> actionsViewer = new ArrayList<String>();
        actionsViewer.add("VIEW");
        DEFAULT_PERMISSIONS.put("Site Member", actionsViewer);
        DEFAULT_DDM_PERMISSIONS.put("Site Member", actionsViewer);
    }
}

