/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SetupConfigurationThreadLocal {
    private static final Logger LOG = LoggerFactory.getLogger(SetupConfigurationThreadLocal.class);
    private static final ThreadLocal<Long> _runAsUserId = new CentralizedThreadLocal(SetupConfigurationThreadLocal.class + "._runAsUserId", () -> {
        try {
            return UserLocalServiceUtil.getDefaultUserId((long)PortalUtil.getDefaultCompanyId());
        }
        catch (PortalException e) {
            LOG.error("Failed to get default user id", (Throwable)e);
            return null;
        }
    });
    private static final ThreadLocal<Long> _runInCompanyId = new CentralizedThreadLocal(SetupConfigurationThreadLocal.class + "._runInCompanyId", PortalUtil::getDefaultCompanyId);
    private static final ThreadLocal<Long> _runInGroupId = new CentralizedThreadLocal(SetupConfigurationThreadLocal.class + "._runInGroupId", () -> {
        try {
            return GroupLocalServiceUtil.getGroup((long)PortalUtil.getDefaultCompanyId(), (String)"Guest").getGroupId();
        }
        catch (PortalException e) {
            LOG.error("Failed to get Guest group id for default company", (Throwable)e);
            return null;
        }
    });
    private static final ThreadLocal<Bundle> _callerBundle = new CentralizedThreadLocal(SetupConfigurationThreadLocal.class + "._callerBundle", null);

    private SetupConfigurationThreadLocal() {
    }

    public static Long getRunAsUserId() {
        return _runAsUserId.get();
    }

    public static void setRunAsUserId(Long runAsUserId) {
        _runAsUserId.set(runAsUserId);
    }

    public static Long getRunInCompanyId() {
        return _runInCompanyId.get();
    }

    public static void setRunInCompanyId(Long runInCompanyId) {
        _runInCompanyId.set(runInCompanyId);
    }

    public static Long getRunInGroupId() {
        return _runInGroupId.get();
    }

    public static void setRunInGroupId(Long runInGroupId) {
        _runInGroupId.set(runInGroupId);
    }

    public static Bundle getCallerBundle() {
        return _callerBundle.get();
    }

    public static void setCallerBundle(Bundle callerBundle) {
        _callerBundle.set(callerBundle);
    }

    public static void cleanUp(String originalPrincipalName, PermissionChecker originalPermissionChecker, Locale originalScopeGroupLocale) {
        _runInCompanyId.remove();
        _runAsUserId.remove();
        _runInGroupId.remove();
        _callerBundle.remove();
        PrincipalThreadLocal.setName((String)originalPrincipalName);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)originalPermissionChecker);
        LocaleThreadLocal.setSiteDefaultLocale((Locale)originalScopeGroupLocale);
    }

    static void configureThreadLocalContent(String runAsUserEmail, long companyId, Group group) throws PortalException {
        Objects.requireNonNull(group);
        SetupConfigurationThreadLocal.configureGroupExecutionContext(group);
        SetupConfigurationThreadLocal.configureThreadLocalContent(runAsUserEmail, companyId, (Bundle)null);
    }

    public static void configureGroupExecutionContext(Group group) {
        Objects.requireNonNull(group);
        SetupConfigurationThreadLocal.setRunInGroupId(group.getGroupId());
        LocaleThreadLocal.setDefaultLocale((Locale)Locale.forLanguageTag(group.getDefaultLanguageId()));
    }

    static void configureThreadLocalContent(String runAsUserEmail, long companyId, Bundle callerBundle) throws PortalException {
        if (Validator.isBlank((String)runAsUserEmail)) {
            SetupConfigurationThreadLocal.setRunInCompanyId(companyId);
            SetupConfigurationThreadLocal.setCallerBundle(callerBundle);
            SetupConfigurationThreadLocal.setRandomAdminPermissionCheckerForThread();
            LOG.info("Using default administrator.");
        } else {
            User user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)runAsUserEmail);
            SetupConfigurationThreadLocal.setRunAsUserId(user.getUserId());
            SetupConfigurationThreadLocal.setRunInCompanyId(companyId);
            SetupConfigurationThreadLocal.setCallerBundle(callerBundle);
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            LOG.info("Execute setup module as user {}", (Object)runAsUserEmail);
        }
    }

    private static void setRandomAdminPermissionCheckerForThread() {
        User adminUser = SetupConfigurationThreadLocal.getRandomAdminUser();
        SetupConfigurationThreadLocal.setRunAsUserId(Objects.requireNonNull(adminUser).getUserId());
        PrincipalThreadLocal.setName((long)adminUser.getUserId());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)adminUser);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
    }

    private static User getRandomAdminUser() {
        String administratorRoleName = "Administrator";
        try {
            Long runInCompanyId = SetupConfigurationThreadLocal.getRunInCompanyId();
            Role adminRole = RoleLocalServiceUtil.getRole((long)runInCompanyId, (String)"Administrator");
            List adminUsers = UserLocalServiceUtil.getRoleUsers((long)adminRole.getRoleId());
            if (adminUsers == null || adminUsers.isEmpty()) {
                throw new IllegalStateException("No user with Administrator role found for company: " + runInCompanyId);
            }
            return (User)adminUsers.get(0);
        }
        catch (PortalException | SystemException e) {
            throw new IllegalStateException("Cannot obtain Liferay role for role name: Administrator", e);
        }
    }
}

