/*
 * Decompiled with CFR 0.152.
 */
package com.ableneo.liferay.portal.setup;

import com.ableneo.liferay.portal.setup.MarshallUtil;
import com.ableneo.liferay.portal.setup.SetupConfigurationThreadLocal;
import com.ableneo.liferay.portal.setup.core.SetupCustomFields;
import com.ableneo.liferay.portal.setup.core.SetupOrganizations;
import com.ableneo.liferay.portal.setup.core.SetupPages;
import com.ableneo.liferay.portal.setup.core.SetupPermissions;
import com.ableneo.liferay.portal.setup.core.SetupPortal;
import com.ableneo.liferay.portal.setup.core.SetupRoles;
import com.ableneo.liferay.portal.setup.core.SetupSites;
import com.ableneo.liferay.portal.setup.core.SetupUserGroups;
import com.ableneo.liferay.portal.setup.core.SetupUsers;
import com.ableneo.liferay.portal.setup.domain.Company;
import com.ableneo.liferay.portal.setup.domain.Configuration;
import com.ableneo.liferay.portal.setup.domain.CustomFields;
import com.ableneo.liferay.portal.setup.domain.ObjectsToBeDeleted;
import com.ableneo.liferay.portal.setup.domain.Organization;
import com.ableneo.liferay.portal.setup.domain.Role;
import com.ableneo.liferay.portal.setup.domain.Setup;
import com.ableneo.liferay.portal.setup.domain.Site;
import com.ableneo.liferay.portal.setup.domain.User;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LiferaySetup {
    private static final Logger LOG = LoggerFactory.getLogger(LiferaySetup.class);

    private LiferaySetup() {
    }

    public static boolean setup(File file) throws FileNotFoundException {
        Setup setup = MarshallUtil.unmarshall(file);
        return LiferaySetup.setup(setup, null);
    }

    public static boolean setup(InputStream inputStream, Bundle callerBundle) {
        Setup setup = MarshallUtil.unmarshall(inputStream);
        return LiferaySetup.setup(setup, callerBundle);
    }

    public static boolean setup(InputStream inputStream) {
        Setup setup = MarshallUtil.unmarshall(inputStream);
        return LiferaySetup.setup(setup, null);
    }

    public static boolean setup(Setup setup) {
        return LiferaySetup.setup(setup, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setup(Setup setup, Bundle callerBundle) {
        if (setup == null) {
            throw new IllegalArgumentException("Setup object cannot be null, without Setup object I cannot set up any data.");
        }
        Configuration configuration = setup.getConfiguration();
        String runAsUserEmail = configuration.getRunAsUserEmail();
        String originalPrincipalName = PrincipalThreadLocal.getName();
        PermissionChecker originalPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        Locale originalScopeGroupLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            if (!configuration.getCompany().isEmpty()) {
                for (Company company : configuration.getCompany()) {
                    long companyId;
                    long l = companyId = company.getCompanyid() != null ? company.getCompanyid() : LiferaySetup.getCompanyIdFromCompanyWebId(company);
                    if (companyId == -1L) {
                        LOG.error("Could not find company: {}", (Object)company);
                        continue;
                    }
                    SetupConfigurationThreadLocal.configureThreadLocalContent(runAsUserEmail, companyId, callerBundle);
                    LiferaySetup.executeSetupConfiguration(setup);
                    if (company.getGroupName().isEmpty()) {
                        company.getGroupName().add("Guest");
                    }
                    for (String groupName : company.getGroupName()) {
                        LiferaySetup.setupGroup(setup, runAsUserEmail, companyId, groupName);
                    }
                }
            } else {
                LiferaySetup.setupGroup(setup, runAsUserEmail, SetupConfigurationThreadLocal.getRunInCompanyId(), "Guest");
            }
        }
        catch (PortalException | RuntimeException e) {
            LOG.error("An error occured while executing the portal setup", e);
            boolean bl = false;
            return bl;
        }
        finally {
            SetupConfigurationThreadLocal.cleanUp(originalPrincipalName, originalPermissionChecker, originalScopeGroupLocale);
        }
        return true;
    }

    private static void setupGroup(Setup setup, String runAsUserEmail, long companyId, String groupName) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)companyId, (String)groupName);
        SetupConfigurationThreadLocal.configureThreadLocalContent(runAsUserEmail, PortalUtil.getDefaultCompanyId(), group);
        LiferaySetup.setupPortalGroup(setup);
    }

    private static void setupPortalGroup(Setup setup) {
        if (setup.getUsers() != null) {
            LOG.info("Setting up {} users", (Object)setup.getUsers().getUser().size());
            SetupUsers.setupUsers(setup.getUsers().getUser());
        }
        if (setup.getPageTemplates() != null) {
            SetupPages.setupPageTemplates(setup.getPageTemplates());
        }
        if (setup.getRoles() != null) {
            LOG.info("Setting up {} roles", (Object)setup.getRoles().getRole().size());
            SetupRoles.setupRoles(setup.getRoles().getRole());
        }
        LOG.info("Setup of portal groups finished");
    }

    private static long getCompanyIdFromCompanyWebId(Company company) {
        String companyWebId = null;
        try {
            companyWebId = company.getCompanywebid();
            return CompanyLocalServiceUtil.getCompanyByWebId((String)companyWebId).getCompanyId();
        }
        catch (PortalException | SystemException e) {
            LOG.error("Couldn't find company: {}", (Object)company, (Object)e);
            return -1L;
        }
    }

    private static void executeSetupConfiguration(Setup setup) throws PortalException {
        if (setup.getDeleteLiferayObjects() != null) {
            LOG.info("Deleting {} object categories", (Object)setup.getDeleteLiferayObjects().getObjectsToBeDeleted().size());
            LiferaySetup.deleteObjects(setup.getDeleteLiferayObjects().getObjectsToBeDeleted());
        }
        if (setup.getPortal() != null) {
            LOG.info("Setting up Portal");
            SetupPortal.setupPortal(setup.getPortal());
        }
        if (setup.getCustomFields() != null) {
            LOG.info("Setting up {} custom fields", (Object)setup.getCustomFields().getField().size());
            SetupCustomFields.setupExpandoFields(setup.getCustomFields().getField());
        }
        if (setup.getOrganizations() != null) {
            LOG.info("Setting up {} organizations", (Object)setup.getOrganizations().getOrganization().size());
            SetupOrganizations.setupOrganizations(setup.getOrganizations().getOrganization(), null, null);
        }
        if (setup.getUserGroups() != null) {
            LOG.info("Setting up {} User Groups", (Object)setup.getUserGroups().getUserGroup().size());
            SetupUserGroups.setupUserGroups(setup.getUserGroups().getUserGroup());
        }
        if (setup.getResourcePermissions() != null) {
            LOG.info("Setting up {} resource permissions", (Object)setup.getResourcePermissions().getResource().size());
            SetupPermissions.setupPortletPermissions(setup.getResourcePermissions());
        }
        if (setup.getSites() != null) {
            LOG.info("Setting up {} sites", (Object)setup.getSites().getSite().size());
            SetupSites.setupSites(setup.getSites().getSite(), null);
        }
        LOG.info("Setup finished");
    }

    private static void deleteObjects(List<ObjectsToBeDeleted> objectsToBeDeleted) {
        for (ObjectsToBeDeleted otbd : objectsToBeDeleted) {
            if (otbd.getRoles() != null) {
                List<Role> roles = otbd.getRoles().getRole();
                SetupRoles.deleteRoles(roles, otbd.getDeleteMethod());
            }
            if (otbd.getUsers() != null) {
                List<User> users = otbd.getUsers().getUser();
                SetupUsers.deleteUsers(users, otbd.getDeleteMethod());
            }
            if (otbd.getOrganizations() != null) {
                List<Organization> organizations = otbd.getOrganizations().getOrganization();
                SetupOrganizations.deleteOrganization(organizations, otbd.getDeleteMethod());
            }
            if (otbd.getCustomFields() != null) {
                List<CustomFields.Field> customFields = otbd.getCustomFields().getField();
                SetupCustomFields.deleteCustomFields(customFields, otbd.getDeleteMethod());
            }
            if (otbd.getSites() == null) continue;
            List<Site> siteList = otbd.getSites().getSite();
            SetupSites.deleteSite(siteList, otbd.getDeleteMethod());
        }
    }
}

