/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.joyhonest.wifination.DeviceFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.simple.eventbus.EventBus;

public class MyUsbCamera {
    private boolean DEBUG = true;
    private final String TAG = "MyUsbCamera";
    private static final String ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.serenegiant.USB_PERMISSION." + this.hashCode();
    public static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static MyUsbCamera myUsbCamera;
    private UsbManager usbManager;
    private boolean bRegisterUsb = false;
    private final WeakReference<Context> mWeakContext;
    private PendingIntent mPermissionIntent = null;
    private List<DeviceFilter> mDeviceFilters = new ArrayList<DeviceFilter>();
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (MyUsbCamera.this.ACTION_USB_PERMISSION.equals(action)) {
                UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                if (intent.getBooleanExtra("permission", false)) {
                    if (device2 != null) {
                        EventBus.getDefault().post((Object)device2, "Connected_UsbCamera");
                    }
                } else {
                    EventBus.getDefault().post((Object)device2, "Connected_UsbCamera_Fail");
                }
            } else if (MyUsbCamera.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                UsbDevice device3 = (UsbDevice)intent.getParcelableExtra("device");
                EventBus.getDefault().post((Object)device3, "Attached_UsbCamera");
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                EventBus.getDefault().post((Object)device, "Detached_UsbCamera");
            }
        }
    };

    private MyUsbCamera(Context context) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public static MyUsbCamera getInstance(Context context) {
        if (myUsbCamera == null) {
            myUsbCamera = new MyUsbCamera(context);
            myUsbCamera._regisgerUsb();
        }
        return myUsbCamera;
    }

    public static void Release() {
        if (myUsbCamera != null) {
            myUsbCamera._release();
        }
    }

    private void _regisgerUsb() {
        if (this.bRegisterUsb) {
            return;
        }
        if (this.mPermissionIntent == null) {
            Context context;
            if (this.DEBUG) {
                Log.i((String)"MyUsbCamera", (String)"register:");
            }
            if ((context = (Context)this.mWeakContext.get()) != null) {
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
                IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                filter.addAction(ACTION_USB_DEVICE_ATTACHED);
                filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                context.getApplicationContext().registerReceiver(this.mUsbReceiver, filter);
                this.bRegisterUsb = true;
            }
        }
    }

    private void _unregisgerUsb() {
        if (!this.bRegisterUsb) {
            return;
        }
        Context context = (Context)this.mWeakContext.get();
        try {
            if (context != null) {
                context.unregisterReceiver(this.mUsbReceiver);
            }
        }
        catch (Exception e) {
            Log.w((String)"MyUsbCamera", (Throwable)e);
        }
        this.bRegisterUsb = false;
    }

    private void _release() {
        this._unregisgerUsb();
    }

    public List<UsbDevice> getDeviceList(List<DeviceFilter> filters) throws IllegalStateException {
        HashMap deviceList = this.usbManager.getDeviceList();
        String fileName = Environment.getExternalStorageDirectory().getAbsolutePath() + "/MyUsbCamera/failed_devices.txt";
        File logFile = new File(fileName);
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fw != null) {
            pw = new PrintWriter(fw);
        }
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            if (filters == null || filters.isEmpty()) {
                result.addAll(deviceList.values());
            } else {
                block8: for (UsbDevice device : deviceList.values()) {
                    for (DeviceFilter filter : filters) {
                        if (filter != null && filter.matches(device) || filter != null && filter.mSubclass == device.getDeviceSubclass()) {
                            if (filter.isExclude) continue block8;
                            result.add(device);
                            continue block8;
                        }
                        String devModel = Build.MODEL;
                        String devSystemVersion = Build.VERSION.RELEASE;
                        String devClass = String.valueOf(device.getDeviceClass());
                        String subClass = String.valueOf(device.getDeviceSubclass());
                        try {
                            if (pw == null) continue;
                            StringBuilder sb = new StringBuilder();
                            sb.append(devModel);
                            sb.append("/");
                            sb.append(devSystemVersion);
                            sb.append(":");
                            sb.append("class=" + devClass + ", subclass=" + subClass);
                            pw.println(sb.toString());
                            pw.flush();
                            fw.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (pw != null) {
            pw.close();
        }
        if (fw != null) {
            try {
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<UsbDevice> getUsbDeviceList() {
        return null;
    }

    public synchronized boolean requestPermission(UsbDevice device) {
        boolean result = false;
        if (this.usbManager == null) {
            EventBus.getDefault().post((Object)device, "Connected_UsbCamera_Cancel");
        } else if (device != null) {
            if (this.usbManager.hasPermission(device)) {
                EventBus.getDefault().post((Object)device, "Connected_UsbCamera");
            } else {
                try {
                    this.usbManager.requestPermission(device, this.mPermissionIntent);
                }
                catch (Exception e) {
                    Log.w((String)"MyUsbCamera", (Throwable)e);
                    EventBus.getDefault().post((Object)device, "Connected_UsbCamera_Cancel");
                    result = true;
                }
            }
        } else {
            EventBus.getDefault().post((Object)device, "Connected_UsbCamera_Cancel");
            result = true;
        }
        return result;
    }

    public void requestPermission(int index) {
        List<UsbDevice> devList = this.getUsbDeviceList();
        if (devList == null || devList.size() == 0) {
            return;
        }
        int count = devList.size();
        if (index >= count) {
            return;
        }
        this.requestPermission(this.getUsbDeviceList().get(index));
    }
}

