/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.graphics.Matrix;
import com.joyhonest.wifination.Logger;

public class ImageUtils {
    private static final Logger LOGGER = new Logger();

    public static Matrix getTransformationMatrix(int srcWidth, int srcHeight, int dstWidth, int dstHeight, int applyRotation, boolean maintainAspectRatio) {
        int inHeight;
        Matrix matrix = new Matrix();
        if (applyRotation != 0) {
            if (applyRotation % 90 != 0) {
                LOGGER.w("Rotation of %d % 90 != 0", applyRotation);
            }
            matrix.postTranslate((float)(-srcWidth) / 2.0f, (float)(-srcHeight) / 2.0f);
            matrix.postRotate((float)applyRotation);
        }
        boolean transpose = (Math.abs(applyRotation) + 90) % 180 == 0;
        int inWidth = transpose ? srcHeight : srcWidth;
        int n = inHeight = transpose ? srcWidth : srcHeight;
        if (inWidth != dstWidth || inHeight != dstHeight) {
            float scaleFactorX = (float)dstWidth / (float)inWidth;
            float scaleFactorY = (float)dstHeight / (float)inHeight;
            if (maintainAspectRatio) {
                float scaleFactor = Math.max(scaleFactorX, scaleFactorY);
                matrix.postScale(scaleFactor, scaleFactor);
            } else {
                matrix.postScale(scaleFactorX, scaleFactorY);
            }
        }
        if (applyRotation != 0) {
            matrix.postTranslate((float)dstWidth / 2.0f, (float)dstHeight / 2.0f);
        }
        return matrix;
    }
}

