/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.util.Log;
import com.joyhonest.wifination.wifination;
import java.util.ArrayList;
import java.util.List;
import org.simple.eventbus.EventBus;

public class GP4225_Device {
    int nInxCount = 0;
    int[] nCountX = new int[10];
    int[] nCountY = new int[10];
    int[] nCountZ = new int[10];
    public int nMode;
    public boolean bSD;
    public boolean bSDRecording;
    public long nSDAllSize;
    public long nSDAvaildSize;
    public int VideosCount;
    public int LockedCount;
    public int PhotoCount;
    public int nBattery;
    public boolean bAdjfocus = false;
    public int nSDRecordTime = 0;
    public String sVer = "";
    byte[] bytes = new byte[32];

    public GP4225_Device() {
        for (int x = 0; x < 10; ++x) {
            this.nCountX[x] = 0;
            this.nCountY[x] = 0;
            this.nCountZ[x] = 0;
        }
        this.nBattery = -1;
        this.VideosCount = 0;
        this.LockedCount = 0;
        this.PhotoCount = 0;
        this.bSD = false;
        this.nSDAllSize = -1L;
        this.nSDAvaildSize = -1L;
        this.bSDRecording = false;
        this.nMode = 0;
    }

    public boolean GP4225_PressData(byte[] data) {
        if (data == null) {
            return false;
        }
        if (data.length <= 10) {
            return false;
        }
        if ((data[0] & 0xFF) != 70 || (data[1] & 0xFF) != 68 || (data[2] & 0xFF) != 87 || (data[3] & 0xFF) != 78) {
            return false;
        }
        String sFileName = "";
        byte nStatus = 0;
        int m_cmd = data[4] & 255 + (data[5] & 0xFF) * 256;
        int s_cmd = data[6] & 255 + (data[7] & 0xFF) * 256;
        int n_len = data[8] & 255 + (data[9] & 0xFF) * 256;
        if (n_len == 0) {
            return false;
        }
        if (n_len + 10 > data.length) {
            return false;
        }
        if (m_cmd == 0 && s_cmd == 1) {
            this.nMode = data[10] & 0xFF;
            this.bSD = (data[11] & 1) == 0;
            this.bSDRecording = (data[11] & 2) != 0;
            this.VideosCount = (data[12] & 0xFF) + (data[13] & 0xFF) * 256 + (data[14] & 0xFF) * 65536 + (data[15] & 0xFF) * 0x1000000;
            this.LockedCount = (data[16] & 0xFF) + (data[17] & 0xFF) * 256 + (data[18] & 0xFF) * 65536 + (data[19] & 0xFF) * 0x1000000;
            this.PhotoCount = (data[20] & 0xFF) + (data[21] & 0xFF) * 256 + (data[22] & 0xFF) * 65536 + (data[23] & 0xFF) * 0x1000000;
            if (n_len >= 26) {
                this.nSDAllSize = (long)((data[24] & 0xFF) + (data[25] & 0xFF) * 256 + (data[26] & 0xFF) * 65536 + (data[27] & 0xFF) * 0x1000000) + (long)(data[34] & 0xFF) * 0x100000000L;
                this.nSDAvaildSize = (long)((data[28] & 0xFF) + (data[29] & 0xFF) * 256 + (data[30] & 0xFF) * 65536 + (data[31] & 0xFF) * 0x1000000) + (long)(data[35] & 0xFF) * 0x100000000L;
            }
            this.nBattery = data[32] & 0xFF;
            this.bAdjfocus = data[33] != 0;
            this.nSDRecordTime = (data[36] & 0xFF) + (data[37] & 0xFF) * 256 + (data[38] & 0xFF) * 65536 + (data[39] & 0xFF) * 0x1000000;
            EventBus.getDefault().post((Object)"", "GP4225_GetStatus");
            return true;
        }
        if (m_cmd == 2) {
            if (s_cmd == 1 || s_cmd == 2 || s_cmd == 3) {
                int nStartInx = (data[10] & 0xFF) + (data[11] & 0xFF) * 256;
                int nEndInx = (data[12] & 0xFF) + (data[13] & 0xFF) * 256;
                GetFiles FF = new GetFiles();
                FF.files = new ArrayList<MyFile>();
                for (int ii = 0; ii <= nEndInx - nStartInx; ++ii) {
                    int inx = 46 + ii * 68;
                    int nLen = (data[inx] & 0xFF) + (data[inx + 1] & 0xFF) * 256 + (data[inx + 2] & 0xFF) * 65536 + (data[inx + 3] & 0xFF) * 0x1000000;
                    inx += 4;
                    int da = 0;
                    for (int xx = 0; xx < 32; ++xx) {
                        if (data[inx + xx] == 0) continue;
                        ++da;
                    }
                    sFileName = "";
                    if (da != 0) {
                        System.arraycopy(data, inx, this.bytes, 0, da);
                        sFileName = new String(this.bytes, 0, da);
                    }
                    MyFile file = new MyFile("", sFileName, nLen);
                    file.nInx1 = nStartInx;
                    file.nInx2 = nEndInx;
                    FF.files.add(file);
                }
                EventBus.getDefault().post((Object)FF, "GP4225_RevFiles");
            }
            return true;
        }
        if (m_cmd == 9) {
            nStatus = data[10];
            sFileName = "";
            if (n_len > 64) {
                int nLen = 0;
                for (int xx = 0; xx < 32 && data[xx + 11 + 32] != 0; ++xx) {
                    ++nLen;
                }
                if (nLen != 0) {
                    sFileName = new String(data, 43, nLen);
                }
            }
            switch (s_cmd) {
                case 1: {
                    MyFile file = new MyFile("", sFileName, nStatus);
                    EventBus.getDefault().post((Object)file, "GP4225_DeleteFile");
                    break;
                }
                case 2: {
                    Integer i = nStatus;
                    EventBus.getDefault().post((Object)i, "GP4225_DeleteAllFile");
                }
            }
            return true;
        }
        if (m_cmd == 32) {
            boolean bOK = true;
            switch (s_cmd) {
                case 1: {
                    byte[] bytes = new byte[n_len];
                    System.arraycopy(data, 10, bytes, 0, n_len);
                    Log.e((String)"\u540c\u6b65\u65f6\u95f4", (String)"OK");
                    EventBus.getDefault().post((Object)bytes, "GP4225_GetDeviceDateTime");
                    break;
                }
                case 2: {
                    byte a = data[10];
                    Integer aa = a;
                    Log.e((String)"\u6c34\u5370", (String)(a + ""));
                    EventBus.getDefault().post((Object)aa, "GP4225_GetDeviceOsdStatus");
                    break;
                }
                case 3: {
                    byte a = data[10];
                    Integer aa = a;
                    Log.e((String)"\u56fe\u50cf", (String)(a + ""));
                    EventBus.getDefault().post((Object)aa, "GP4225_GetDeviceReversaltatus");
                    break;
                }
                case 4: {
                    byte a = data[10];
                    Integer aa = a;
                    Log.e((String)"\u5f55\u50cf\u65f6\u95f4", (String)(a + ""));
                    EventBus.getDefault().post((Object)aa, "GP4225_GetDeviceRecordTime");
                    break;
                }
                case 7: {
                    byte a = data[10];
                    Integer aa = a;
                    Log.e((String)"Format", (String)(a + ""));
                    EventBus.getDefault().post((Object)aa, "GP4225_WifiChannel");
                    break;
                }
                case 8: {
                    byte a = data[10];
                    Integer aa = a;
                    Log.e((String)"Format", (String)(a + ""));
                    EventBus.getDefault().post((Object)aa, "GP4225_FormatSD_Status");
                    break;
                }
                case 9: {
                    byte[] bytes = new byte[n_len];
                    System.arraycopy(data, 10, bytes, 0, n_len);
                    this.sVer = new String(bytes);
                    Log.e((String)"ABC", (String)this.sVer);
                    EventBus.getDefault().post((Object)this.sVer, "GP4225_GetFireWareVersion");
                    break;
                }
                case 10: {
                    byte a = data[10];
                    Integer aa = a;
                    EventBus.getDefault().post((Object)aa, "GP4225_Reset_Status");
                    break;
                }
                case 11: {
                    int val = (data[10] & 0xFF) + (data[11] & 0xFF) * 256;
                    val >>= 4;
                    Integer aa = val &= 0x3FF;
                    EventBus.getDefault().post((Object)aa, "GP4225_34_GetAdjFocus");
                    break;
                }
                case 14: {
                    byte a = data[10];
                    Integer aa = a;
                    EventBus.getDefault().post((Object)aa, "GP4225_GetLed");
                    break;
                }
                case 16: {
                    byte a = data[10];
                    Integer aa = a;
                    EventBus.getDefault().post((Object)aa, "GP4225_GetResolution");
                    break;
                }
                case 18: {
                    if (n_len != 8) break;
                    int status = data[10] & 255 + (data[11] & 0xFF) * 256;
                    data[13] = (data[13] & 8) != 0 ? (byte)(data[13] | 0xF8) : (byte)(data[13] & 7);
                    data[15] = (data[15] & 8) != 0 ? (byte)(data[15] | 0xF8) : (byte)(data[15] & 7);
                    data[17] = (data[17] & 8) != 0 ? (byte)(data[17] | 0xF8) : (byte)(data[17] & 7);
                    int yy = data[12] & 0xFF | data[13] * 256;
                    int xx = data[14] & 0xFF | data[15] * 256;
                    int zz = data[16] & 0xFF | data[17] * 256;
                    zz = -zz;
                    wifination.naSetGsensor2SDK(xx, yy, zz);
                    G_SensorData sensorData = new G_SensorData(status, xx, yy, zz);
                    EventBus.getDefault().post((Object)sensorData, "GP4225_GetGSensorData");
                    break;
                }
                case 19: {
                    byte a = data[10];
                    Integer aa = a;
                    EventBus.getDefault().post((Object)aa, "GP4225_GetAC_Data");
                    break;
                }
                default: {
                    bOK = false;
                }
            }
            return bOK;
        }
        return false;
    }

    private void F_Push(int x, int y, int z) {
        if (this.nInxCount < 10) {
            this.nCountX[this.nInxCount] = x;
            this.nCountY[this.nInxCount] = y;
            this.nCountZ[this.nInxCount] = z;
            ++this.nInxCount;
        } else {
            for (int i = 1; i < 10; ++i) {
                this.nCountX[i - 1] = this.nCountX[i];
                this.nCountY[i - 1] = this.nCountY[i];
                this.nCountZ[i - 1] = this.nCountZ[i];
            }
            this.nCountX[9] = x;
            this.nCountY[9] = y;
            this.nCountZ[9] = z;
        }
    }

    public class GetFiles {
        public List<MyFile> files;
    }

    public class MyFile {
        public String sPath;
        public String sFileName;
        public int nLength;
        public int nInx1;
        public int nInx2;

        public MyFile(String sPath_, String sFileName_, int nLength_) {
            this.sPath = sPath_;
            this.sFileName = sFileName_;
            this.nLength = nLength_;
            this.nInx1 = 0;
            this.nInx2 = 0;
        }
    }

    public class G_SensorData {
        public int nStatus;
        public int XX;
        public int YY;
        public int ZZ;

        public G_SensorData(int nS, int x, int y, int z) {
            this.nStatus = nS;
            this.XX = x;
            this.YY = y;
            this.ZZ = z;
        }
    }
}

