/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import com.joyhonest.wifination.AudioCodec;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AudioEncoder
implements AudioCodec {
    private Worker mWorker;
    private final String TAG = "AudioEncoder";
    private byte[] mFrameByte;

    public void start() {
        if (this.mWorker == null) {
            this.mWorker = new Worker();
            this.mWorker.setRunning(true);
            this.mWorker.start();
        }
    }

    public void stop() {
        if (this.mWorker != null) {
            this.mWorker.setRunning(false);
            this.mWorker = null;
        }
    }

    private static native boolean naSentVoiceData(byte[] var0, int var1);

    private class Worker
    extends Thread {
        private int mFrameSize = 2048;
        private byte[] mBuffer;
        private boolean isRunning = false;
        private MediaCodec mEncoder;
        private AudioRecord mRecord;
        MediaCodec.BufferInfo mBufferInfo;

        private Worker() {
        }

        @Override
        public void run() {
            if (!this.prepare()) {
                Log.d((String)"AudioEncoder", (String)"\u97f3\u9891\u7f16\u7801\u5668\u521d\u59cb\u5316\u5931\u8d25");
                this.isRunning = false;
            }
            int re = 0;
            while (this.isRunning) {
                re = this.mRecord.read(this.mBuffer, 0, this.mFrameSize);
                this.encode(this.mBuffer);
            }
            this.release();
        }

        public void setRunning(boolean run) {
            this.isRunning = run;
        }

        private void release() {
            if (this.mEncoder != null) {
                this.mEncoder.stop();
                this.mEncoder.release();
            }
            if (this.mRecord != null) {
                this.mRecord.stop();
                this.mRecord.release();
                this.mRecord = null;
            }
        }

        private boolean prepare() {
            try {
                this.mBufferInfo = new MediaCodec.BufferInfo();
                this.mEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)44100, (int)1);
                mediaFormat.setInteger("bitrate", 705600);
                mediaFormat.setInteger("sample-rate", 44100);
                mediaFormat.setInteger("channel-count", 1);
                mediaFormat.setInteger("aac-profile", 2);
                this.mEncoder.configure(mediaFormat, null, null, 1);
                this.mEncoder.start();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            try {
                int buffSize;
                int minBufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2) * 2;
                this.mRecord = new AudioRecord(1, 44100, 16, 2, minBufferSize);
                this.mFrameSize = buffSize = Math.min(4096, minBufferSize);
                this.mBuffer = new byte[this.mFrameSize];
                this.mRecord.startRecording();
            }
            catch (Exception e) {
                this.mRecord = null;
                this.mEncoder = null;
                return false;
            }
            return true;
        }

        private void encode(byte[] data) {
            ByteBuffer[] inputBuffers = this.mEncoder.getInputBuffers();
            ByteBuffer[] outputBuffers = this.mEncoder.getOutputBuffers();
            int inputBufferId = this.mEncoder.dequeueInputBuffer(50000L);
            if (inputBufferId >= 0) {
                ByteBuffer bb = inputBuffers[inputBufferId];
                bb.put(data, 0, data.length);
                long pts = 1L;
                this.mEncoder.queueInputBuffer(inputBufferId, 0, data.length, pts, 0);
            }
            MediaCodec.BufferInfo aBufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = this.mEncoder.dequeueOutputBuffer(aBufferInfo, 10000L);
            while (outputBufferIndex >= 0) {
                ByteBuffer bb = outputBuffers[outputBufferIndex];
                bb.rewind();
                byte[] dataA = new byte[aBufferInfo.size];
                bb.get(dataA, 0, dataA.length);
                AudioEncoder.naSentVoiceData(dataA, aBufferInfo.size);
                this.mEncoder.releaseOutputBuffer(outputBufferIndex, false);
                outputBufferIndex = this.mEncoder.dequeueOutputBuffer(aBufferInfo, 0L);
            }
        }

        private void addADTStoPacket(byte[] packet, int packetLen) {
            int profile = 2;
            int freqIdx = 4;
            int chanCfg = 2;
            packet[0] = -1;
            packet[1] = -7;
            packet[2] = (byte)((profile - 1 << 6) + (freqIdx << 2) + (chanCfg >> 2));
            packet[3] = (byte)(((chanCfg & 3) << 6) + (packetLen >> 11));
            packet[4] = (byte)((packetLen & 0x7FF) >> 3);
            packet[5] = (byte)(((packetLen & 7) << 5) + 31);
            packet[6] = -4;
        }
    }
}

