/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.simple.eventbus.EventBus;

public class GP4225_Device {
    public int nMode = 0;
    public int nSD = 0;
    public int VideosCount = 0;
    public int LockedCount = 0;
    public int PhotoCount = 0;
    public List<MyFile> PhotoFileList = new ArrayList<MyFile>();
    public List<MyFile> LockedFileList = new ArrayList<MyFile>();
    public List<MyFile> VideoFileList = new ArrayList<MyFile>();

    private void F_AddFile(int i, MyFile file) {
        if (i == 1) {
            this.VideoFileList.add(file);
        }
        if (i == 2) {
            this.LockedFileList.add(file);
        }
        if (i == 3) {
            this.PhotoFileList.add(file);
        }
    }

    public void F_ClearAllList() {
        this.VideoFileList.clear();
        this.LockedFileList.clear();
        this.PhotoFileList.clear();
    }

    public boolean GP4225_PressData(byte[] data) {
        if (data == null) {
            return false;
        }
        if (data.length < 10) {
            return false;
        }
        if ((data[0] & 0xFF) != 70 || (data[1] & 0xFF) != 68 || (data[2] & 0xFF) != 87 || (data[3] & 0xFF) != 78) {
            return false;
        }
        String sFileName = "";
        int m_cmd = data[4] & 255 + (data[5] & 0xFF) * 256;
        int s_cmd = data[6] & 255 + (data[7] & 0xFF) * 256;
        int n_len = data[8] & 255 + (data[9] & 0xFF) * 256;
        if (m_cmd == 0 && s_cmd == 1) {
            this.nMode = data[10] & 0xFF;
            this.nSD = data[11] & 0xFF;
            this.VideosCount = (data[12] & 0xFF) + (data[13] & 0xFF) * 256 + (data[14] & 0xFF) * 65536 + (data[15] & 0xFF) * 0x1000000;
            this.LockedCount = (data[16] & 0xFF) + (data[17] & 0xFF) * 256 + (data[18] & 0xFF) * 65536 + (data[19] & 0xFF) * 0x1000000;
            this.PhotoCount = (data[20] & 0xFF) + (data[21] & 0xFF) * 256 + (data[22] & 0xFF) * 65536 + (data[23] & 0xFF) * 0x1000000;
            Log.e((String)"TAG", (String)("Rev Mode = " + this.nMode + " nSD = " + this.nSD + " nVideCount =" + this.VideosCount + " LockedCount = " + this.LockedCount + " PhotoCount =  " + this.PhotoCount));
            this.F_ClearAllList();
        }
        if (m_cmd == 2) {
            if (s_cmd == 1 || s_cmd == 2 || s_cmd == 3) {
                int nStartInx = data[10] & 255 + (data[11] & 0xFF) * 256;
                int nEndInx = data[12] & 255 + (data[13] & 0xFF) * 256;
                for (int ii = 0; ii <= nEndInx - nStartInx; ++ii) {
                    int inx = 46 + ii * 68;
                    int nLen = (data[inx] & 0xFF) + (data[inx + 1] & 0xFF) * 256 + (data[inx + 2] & 0xFF) * 65536 + (data[inx + 3] & 0xFF) * 0x1000000;
                    inx += 4;
                    int da = 0;
                    for (int xx = 0; xx < 32; ++xx) {
                        if (data[inx + xx] == 0) continue;
                        ++da;
                    }
                    if (da != 0) {
                        byte[] bytes = new byte[da];
                        System.arraycopy(data, inx, bytes, 0, da);
                        sFileName = new String(bytes);
                    }
                    MyFile file = new MyFile("", sFileName, nLen);
                    EventBus.getDefault().post((Object)file, "GP4225_RevFile");
                }
            }
            return true;
        }
        return false;
    }

    public class MyFile {
        public String sPath;
        public int nLength;
        public String sFileName;

        public MyFile(String sPath_, String sFileName_, int nLength_) {
            this.sPath = sPath_;
            this.sFileName = sFileName_;
            this.nLength = nLength_;
        }
    }
}

