/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Handler;
import android.os.HandlerThread;
import com.joyhonest.wifination.Classifier;
import com.joyhonest.wifination.ImageUtils;
import com.joyhonest.wifination.JH_ObjectDetectionAPIModel;
import java.io.IOException;
import java.util.List;
import org.simple.eventbus.EventBus;

public class ObjectDetector {
    private static Context AppContext = null;
    public static int nWidth = 300;
    public static int nHeight = 300;
    private boolean bBusy = false;
    private boolean bStar = false;
    private Classifier detector;
    public static float MINIMUM_CONFIDENCE_TF_OD_API = 0.8f;
    private static final String TF_OD_API_MODEL_FILE = "file:///android_asset/frozen_inference_graph.pb";
    private static final String TF_OD_API_LABELS_FILE = "file:///android_asset/mydata.txt";
    private Matrix frameToCropTransform;
    private Matrix cropToFrameTransform;
    private Bitmap croppedBitmap = Bitmap.createBitmap((int)nWidth, (int)nHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    private Canvas canvas = new Canvas(this.croppedBitmap);
    private Handler handler;
    private HandlerThread handlerThread;

    public void F_SetWidth_Height(int nW, int nH) {
        nWidth = nW;
        nHeight = nH;
        if (this.croppedBitmap != null) {
            this.croppedBitmap.recycle();
        }
        this.croppedBitmap = Bitmap.createBitmap((int)nWidth, (int)nHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.croppedBitmap);
    }

    private ObjectDetector() {
    }

    public void SetAppCentext(Context context) {
        if (AppContext == null) {
            AppContext = context;
        }
        if (AppContext != null && this.detector == null) {
            try {
                this.detector = JH_ObjectDetectionAPIModel.create(AppContext.getAssets(), TF_OD_API_MODEL_FILE, TF_OD_API_LABELS_FILE, nWidth, nHeight);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ObjectDetector getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }

    public void F_Start(boolean _bStart) {
        if (this.bStar && !_bStart) {
            if (this.handlerThread != null) {
                this.handlerThread.quit();
            }
            if (this.handler != null) {
                this.handler.removeCallbacksAndMessages(null);
            }
            this.bStar = _bStart;
            return;
        }
        if (!this.bStar && _bStart) {
            this.handlerThread = new HandlerThread("_Obj__jhabc_");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            this.bStar = _bStart;
        }
    }

    public int GetNumber(Bitmap bmp) {
        if (bmp == null) {
            return -1;
        }
        if (!this.bStar) {
            return -2;
        }
        if (this.bBusy) {
            return -3;
        }
        this.bBusy = true;
        if (this.frameToCropTransform == null) {
            int width = bmp.getWidth();
            int height = bmp.getHeight();
            this.frameToCropTransform = ImageUtils.getTransformationMatrix(width, height, nWidth, nHeight, 0, false);
            this.cropToFrameTransform = new Matrix();
            this.frameToCropTransform.invert(this.cropToFrameTransform);
        }
        this.canvas.drawBitmap(bmp, this.frameToCropTransform, null);
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ObjectDetector.this.progressImage();
            }
        });
        return 0;
    }

    private void progressImage() {
        List<Classifier.Recognition> results = this.detector.recognizeImage(this.croppedBitmap);
        float minimumConfidence = MINIMUM_CONFIDENCE_TF_OD_API;
        boolean bFind = false;
        String id = "";
        boolean bfirset = true;
        int nMax = 0;
        int nre = 0;
        int SetMax = (int)(minimumConfidence * 100.0f);
        for (Classifier.Recognition result : results) {
            RectF location = result.getLocation();
            if (location == null) continue;
            if (bfirset) {
                nre = (int)(result.getConfidence().floatValue() * 100.0f);
                id = result.getTitle();
                nMax = nre;
            } else {
                int tm = (int)(result.getConfidence().floatValue() * 100.0f);
                if (tm >= nre) {
                    nMax = nre = tm;
                    id = result.getTitle();
                }
            }
            bfirset = false;
        }
        if (!id.isEmpty() && nMax >= SetMax) {
            bFind = true;
            EventBus.getDefault().post((Object)id, "GetGueset");
        }
        if (!bFind) {
            EventBus.getDefault().post((Object)"", "GetGueset");
        }
        this.bBusy = false;
    }

    private synchronized void runInBackground(Runnable r) {
        if (this.handler != null) {
            this.handler.post(r);
        }
    }

    public static class SingleTonHoulder {
        private static final ObjectDetector singleTonInstance = new ObjectDetector();
    }
}

