/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.joyhonest.wifination.wifination;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoMediaCoder {
    int pts;
    int fps;
    private MediaCodec mMediaCodec = null;

    public int initMediaCodec(int width, int height, int bitrate, int fps) {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
            this.pts = 0;
        }
        this.pts = 0;
        this.fps = fps;
        boolean bOK = true;
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
        }
        catch (IOException e) {
            e.printStackTrace();
            bOK = false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            bOK = false;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            bOK = false;
        }
        if (!bOK) {
            return 524287;
        }
        int nColor = 0;
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
        mediaFormat.setInteger("width", width);
        mediaFormat.setInteger("height", height);
        mediaFormat.setInteger("bitrate", bitrate);
        mediaFormat.setInteger("frame-rate", fps);
        mediaFormat.setInteger("color-format", 21);
        mediaFormat.setInteger("i-frame-interval", 2);
        boolean bConfigOK = true;
        try {
            this.mMediaCodec.configure(mediaFormat, null, null, 1);
            nColor = 21;
        }
        catch (Exception e) {
            e.printStackTrace();
            bConfigOK = false;
            nColor = 0;
        }
        if (!bConfigOK) {
            mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)height, (int)width);
            mediaFormat.setInteger("bitrate", bitrate);
            mediaFormat.setInteger("frame-rate", fps);
            mediaFormat.setInteger("color-format", 19);
            mediaFormat.setInteger("i-frame-interval", 2);
            bConfigOK = true;
            try {
                this.mMediaCodec.configure(mediaFormat, null, null, 1);
                nColor = 19;
            }
            catch (Exception e) {
                e.printStackTrace();
                bConfigOK = false;
                nColor = 0;
            }
        } else {
            nColor = 21;
        }
        if (bConfigOK) {
            this.mMediaCodec.start();
        } else {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        return nColor;
    }

    public void F_CloseEncoder() {
        if (this.mMediaCodec == null) {
            return;
        }
        this.mMediaCodec.stop();
        this.mMediaCodec.release();
        this.mMediaCodec = null;
    }

    public void offerEncoder(byte[] data, int nLen) {
        block6: {
            if (this.mMediaCodec == null) {
                return;
            }
            ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
            ByteBuffer[] outputBuffers = this.mMediaCodec.getOutputBuffers();
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(5000L);
            if (inputBufferIndex < 0) break block6;
            int ppp = this.pts * 1000000 / this.fps;
            ++this.pts;
            ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
            inputBuffer.clear();
            inputBuffer.put(data);
            this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, data.length, (long)ppp, 0);
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 2000L);
            if (outputBufferIndex >= 0) {
                ByteBuffer outputBuffer = outputBuffers[outputBufferIndex];
                byte[] outData = new byte[bufferInfo.size];
                outputBuffer.get(outData);
                boolean bKeyframe = false;
                if (bufferInfo.flags == 2) {
                    wifination.naSave2FrameMp4(outData, bufferInfo.size, 0, bKeyframe);
                } else if (bufferInfo.flags == 1) {
                    bKeyframe = true;
                    wifination.naSave2FrameMp4(outData, bufferInfo.size, 1, bKeyframe);
                } else {
                    wifination.naSave2FrameMp4(outData, bufferInfo.size, 1, bKeyframe);
                }
                this.mMediaCodec.releaseOutputBuffer(outputBufferIndex, false);
            }
        }
    }
}

