/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Environment;
import com.joyhonest.wifination.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImageUtils {
    private static final Logger LOGGER = new Logger();
    static final int kMaxChannelValue = 262143;
    private static boolean useNativeConversion;

    public static int getYUVByteSize(int width, int height) {
        int ySize = width * height;
        int uvSize = (width + 1) / 2 * ((height + 1) / 2) * 2;
        return ySize + uvSize;
    }

    public static void saveBitmap(Bitmap bitmap) {
        ImageUtils.saveBitmap(bitmap, "preview.png");
    }

    public static void saveBitmap(Bitmap bitmap, String filename) {
        String fname;
        File file;
        String root = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "tensorflow";
        LOGGER.i("Saving %dx%d bitmap to %s.", bitmap.getWidth(), bitmap.getHeight(), root);
        File myDir = new File(root);
        if (!myDir.mkdirs()) {
            LOGGER.i("Make dir failed", new Object[0]);
        }
        if ((file = new File(myDir, fname = filename)).exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 99, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            LOGGER.e(e, "Exception!", new Object[0]);
        }
    }

    public static void convertYUV420SPToARGB8888(byte[] input, int width, int height, int[] output) {
        if (useNativeConversion) {
            try {
                ImageUtils.convertYUV420SPToARGB8888(input, output, width, height, false);
                return;
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.w("Native YUV420SP -> RGB implementation not found, falling back to Java implementation", new Object[0]);
                useNativeConversion = false;
            }
        }
        int frameSize = width * height;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = 0xFF & input[yp];
                if ((i & 1) == 0) {
                    v = 0xFF & input[uvp++];
                    u = 0xFF & input[uvp++];
                }
                output[yp] = ImageUtils.YUV2RGB(y, u, v);
                ++i;
                ++yp;
            }
        }
    }

    private static int YUV2RGB(int y, int u, int v) {
        y = y - 16 < 0 ? 0 : y - 16;
        int y1192 = 1192 * y;
        int r = y1192 + 1634 * (v -= 128);
        int g = y1192 - 833 * v - 400 * (u -= 128);
        int b = y1192 + 2066 * u;
        int n = r > 262143 ? 262143 : (r = r < 0 ? 0 : r);
        int n2 = g > 262143 ? 262143 : (g = g < 0 ? 0 : g);
        b = b > 262143 ? 262143 : (b < 0 ? 0 : b);
        return 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
    }

    public static void convertYUV420ToARGB8888(byte[] yData, byte[] uData, byte[] vData, int width, int height, int yRowStride, int uvRowStride, int uvPixelStride, int[] out) {
        if (useNativeConversion) {
            try {
                ImageUtils.convertYUV420ToARGB8888(yData, uData, vData, out, width, height, yRowStride, uvRowStride, uvPixelStride, false);
                return;
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.w("Native YUV420 -> RGB implementation not found, falling back to Java implementation", new Object[0]);
                useNativeConversion = false;
            }
        }
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int pY = yRowStride * j;
            int pUV = uvRowStride * (j >> 1);
            for (int i = 0; i < width; ++i) {
                int uv_offset = pUV + (i >> 1) * uvPixelStride;
                out[yp++] = ImageUtils.YUV2RGB(0xFF & yData[pY + i], 0xFF & uData[uv_offset], 0xFF & vData[uv_offset]);
            }
        }
    }

    private static native void convertYUV420SPToARGB8888(byte[] var0, int[] var1, int var2, int var3, boolean var4);

    private static native void convertYUV420ToARGB8888(byte[] var0, byte[] var1, byte[] var2, int[] var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private static native void convertYUV420SPToRGB565(byte[] var0, byte[] var1, int var2, int var3);

    private static native void convertARGB8888ToYUV420SP(int[] var0, byte[] var1, int var2, int var3);

    private static native void convertRGB565ToYUV420SP(byte[] var0, byte[] var1, int var2, int var3);

    public static Matrix getTransformationMatrix(int srcWidth, int srcHeight, int dstWidth, int dstHeight, int applyRotation, boolean maintainAspectRatio) {
        int inHeight;
        Matrix matrix = new Matrix();
        if (applyRotation != 0) {
            if (applyRotation % 90 != 0) {
                LOGGER.w("Rotation of %d % 90 != 0", applyRotation);
            }
            matrix.postTranslate((float)(-srcWidth) / 2.0f, (float)(-srcHeight) / 2.0f);
            matrix.postRotate((float)applyRotation);
        }
        boolean transpose = (Math.abs(applyRotation) + 90) % 180 == 0;
        int inWidth = transpose ? srcHeight : srcWidth;
        int n = inHeight = transpose ? srcWidth : srcHeight;
        if (inWidth != dstWidth || inHeight != dstHeight) {
            float scaleFactorX = (float)dstWidth / (float)inWidth;
            float scaleFactorY = (float)dstHeight / (float)inHeight;
            if (maintainAspectRatio) {
                float scaleFactor = Math.max(scaleFactorX, scaleFactorY);
                matrix.postScale(scaleFactor, scaleFactor);
            } else {
                matrix.postScale(scaleFactorX, scaleFactorY);
            }
        }
        if (applyRotation != 0) {
            matrix.postTranslate((float)dstWidth / 2.0f, (float)dstHeight / 2.0f);
        }
        return matrix;
    }

    static {
        try {
            System.loadLibrary("jh_wifi");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.w("Native library not found, native RGB -> YUV conversion may be unavailable.", new Object[0]);
        }
        useNativeConversion = true;
    }
}

