/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_drone;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.joyhonest.jh_ui.R;

public class StrokeTextView
extends TextView {
    private TextView outlineTextView = null;

    public StrokeTextView(Context context) {
        this(context, null);
    }

    public StrokeTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StrokeTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.outlineTextView = new TextView(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.StrokeTextView);
        int stroke_color = ta.getColor(R.styleable.StrokeTextView_stroke_color, -1);
        float stroke_width = ta.getDimension(R.styleable.StrokeTextView_stroke_width, 2.0f);
        TextPaint paint = this.outlineTextView.getPaint();
        paint.setStrokeWidth(stroke_width);
        paint.setStyle(Paint.Style.STROKE);
        this.outlineTextView.setTextColor(stroke_color);
        this.outlineTextView.setGravity(this.getGravity());
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        super.setLayoutParams(params);
        this.outlineTextView.setLayoutParams(params);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        CharSequence outlineText = this.outlineTextView.getText();
        if (outlineText == null || !outlineText.equals(this.getText())) {
            this.outlineTextView.setText(this.getText());
            this.postInvalidate();
        }
        this.outlineTextView.measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.outlineTextView.layout(left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        this.outlineTextView.draw(canvas);
        super.onDraw(canvas);
    }
}

