/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_fpv;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.joyhonest.jh_fpv.BrowActivity;
import com.joyhonest.jh_ui.JH_App;
import com.joyhonest.jh_ui.MyControl;
import com.joyhonest.jh_ui.PermissionAsker;
import com.joyhonest.jh_ui.R;
import com.joyhonest.wifination.wifination;
import org.simple.eventbus.EventBus;
import org.simple.eventbus.Subscriber;

public class FpvActivity
extends AppCompatActivity
implements View.OnClickListener {
    private PermissionAsker mAsker;
    private Button btn_photo;
    private Button btn_video;
    private Button btn_brow;
    private Button btn_wifi;
    private Button btn_back;
    private TextView RectimeView;
    private LinearLayout flashView;
    private ImageView DispImageView;
    private HandlerThread thread1;
    private Handler openHandler;
    private Runnable openRunnable = new Runnable(){

        @Override
        public void run() {
            JH_App.nSdStatus = 0;
            JH_App.F_OpenStream();
        }
    };
    Handler RssiHander = new Handler();
    Runnable RssiRunable = new Runnable(){

        @Override
        public void run() {
            int nrssi = JH_App.F_GetWifiRssi();
            if (nrssi < 0) {
                nrssi = 0;
            }
            if (nrssi > 4) {
                nrssi = 4;
            }
            if (nrssi == 1) {
                FpvActivity.this.btn_wifi.setBackgroundResource(R.mipmap.wifi_01_jh_fpv);
            } else if (nrssi == 2) {
                FpvActivity.this.btn_wifi.setBackgroundResource(R.mipmap.wifi_02_jh_fpv);
            } else if (nrssi == 3) {
                FpvActivity.this.btn_wifi.setBackgroundResource(R.mipmap.wifi_03_jh_fpv);
            } else if (nrssi == 4) {
                FpvActivity.this.btn_wifi.setBackgroundResource(R.mipmap.wifi_04_jh_fpv);
            } else if (nrssi == 0) {
                FpvActivity.this.btn_wifi.setBackgroundResource(R.mipmap.wifi_00_jh_fpv);
            }
            FpvActivity.this.RssiHander.postDelayed((Runnable)this, 1000L);
        }
    };
    private Handler DispRecTimeHander = new Handler();
    private Runnable DispRecTimeRunnable = new Runnable(){

        @Override
        public void run() {
            if ((JH_App.nSdStatus & 2) != 0) {
                int rec = wifination.naGetRecordTime() / 1000;
                int nMin = rec / 60;
                int nSec = rec % 60;
                String str = String.format("%02d:%02d", nMin, nSec);
                FpvActivity.this.RectimeView.setText((CharSequence)str);
                FpvActivity.this.DispRecTimeHander.postDelayed((Runnable)this, 250L);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_fpv);
        this.DispImageView = (ImageView)this.findViewById(R.id.DispImageView);
        wifination.naSetRevBmp(true);
        wifination.appContext = this.getApplicationContext();
        wifination.naSetVrBackground(true);
        JH_App.F_InitMusic();
        this.mAsker = new PermissionAsker(10, new Runnable(){

            @Override
            public void run() {
                FpvActivity.this.F_Init();
            }
        }, new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)FpvActivity.this, (CharSequence)"The necessary permission denied, the application exit", (int)0).show();
                FpvActivity.this.finish();
            }
        }).askPermission((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE");
        this.RssiHander.post(this.RssiRunable);
    }

    @Subscriber(tag="ReviceBMP")
    private void ReviceBMP(Bitmap bmp) {
        this.DispImageView.setImageBitmap(bmp);
    }

    protected void onResume() {
        super.onResume();
        JH_App.checkDeviceHasNavigationBar((Context)this);
    }

    private void TackPhoto() {
        if (!this.isConnected()) {
            return;
        }
        String str = JH_App.F_GetSaveName(true);
        this.flashView.setVisibility(0);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                FpvActivity.this.flashView.setVisibility(8);
            }
        }, 120L);
        wifination.naSnapPhoto(str, 0);
        JH_App.F_PlayPhoto();
    }

    private void StartOrStopRecord() {
        if (this.isConnected()) {
            if ((JH_App.nSdStatus & 2) == 0) {
                String str = JH_App.F_GetSaveName(false);
                wifination.naStartRecord(str, 0);
            } else {
                wifination.naStopRecord_All();
            }
        }
    }

    public void onClick(View v) {
        if (v == this.btn_back) {
            this.finish();
        }
        if (v == this.btn_photo) {
            this.TackPhoto();
        }
        if (v == this.btn_video) {
            this.StartOrStopRecord();
        }
        if (v == this.btn_brow) {
            Intent mainIntent = new Intent((Context)this, BrowActivity.class);
            this.startActivity(mainIntent);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.mAsker.onRequestPermissionsResult(grantResults);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.Exit();
        this.RssiHander.removeCallbacksAndMessages(null);
        this.openHandler.removeCallbacksAndMessages(null);
        this.thread1.quit();
        EventBus.getDefault().unregister((Object)this);
    }

    private void Exit() {
        wifination.naStopRecord_All();
        wifination.naStop();
    }

    private void F_Init() {
        MyControl.bFlyType = false;
        wifination.F_AdjBackGround((Context)this, R.mipmap.loginbackground_jh);
        JH_App.F_CreateLocalFpvDefalutDir();
        JH_App.F_Clear_not_videoFiles();
        this.flashView = (LinearLayout)this.findViewById(R.id.flashView);
        this.flashView.setVisibility(8);
        this.RectimeView = (TextView)this.findViewById(R.id.RectimeView);
        this.RectimeView.setVisibility(4);
        this.btn_photo = (Button)this.findViewById(R.id.btn_photp);
        this.btn_video = (Button)this.findViewById(R.id.btn_video);
        this.btn_brow = (Button)this.findViewById(R.id.btn_brow);
        this.btn_wifi = (Button)this.findViewById(R.id.btn_wifi);
        this.btn_back = (Button)this.findViewById(R.id.btn_back);
        this.btn_photo.setOnClickListener((View.OnClickListener)this);
        this.btn_video.setOnClickListener((View.OnClickListener)this);
        this.btn_brow.setOnClickListener((View.OnClickListener)this);
        this.btn_wifi.setOnClickListener((View.OnClickListener)this);
        this.btn_back.setOnClickListener((View.OnClickListener)this);
        this.thread1 = new HandlerThread("MyHandlerThread_FPV");
        this.thread1.start();
        this.openHandler = new Handler(this.thread1.getLooper());
        this.openHandler.postDelayed(this.openRunnable, 100L);
        EventBus.getDefault().register((Object)this);
    }

    private boolean isConnected() {
        return (JH_App.nSdStatus & 1) != 0;
    }

    private void DispRecTimeView(boolean b) {
        if (b) {
            this.RectimeView.setText((CharSequence)"00:00");
            this.RectimeView.setVisibility(0);
            this.DispRecTimeHander.removeCallbacksAndMessages(null);
            this.DispRecTimeHander.post(this.DispRecTimeRunnable);
        } else {
            this.DispRecTimeHander.removeCallbacksAndMessages(null);
            this.RectimeView.setVisibility(4);
            this.RectimeView.setText((CharSequence)"00:00");
        }
    }

    @Subscriber(tag="SDStatus_Changed")
    private void _SDStatus_Changed(Integer nStatus) {
        int backStatus = JH_App.nSdStatus;
        JH_App.nSdStatus = (nStatus & 1) != 0 ? (JH_App.nSdStatus |= 1) : (JH_App.nSdStatus &= 0xFFFE);
        if ((nStatus & 2) != 0) {
            if ((JH_App.nSdStatus & 2) == 0) {
                JH_App.nSdStatus |= 2;
                this.DispRecTimeView(true);
            }
        } else {
            JH_App.nSdStatus &= 0xFFFD;
            this.DispRecTimeView(false);
        }
    }

    @Subscriber(tag="SavePhotoOK")
    private void SavePhotoOK(String Sn) {
        if (Sn.length() < 5) {
            return;
        }
        String sType = Sn.substring(0, 2);
        String sName = Sn.substring(2, Sn.length());
        int nPhoto = Integer.parseInt(sType);
        if (nPhoto == 0) {
            JH_App.F_Save2ToGallery(sName, true);
        } else {
            JH_App.F_Save2ToGallery(sName, false);
        }
    }

    @Subscriber(tag="key_Press")
    private void key_Press(Integer nKey) {
        Log.e((String)"TAG", (String)("Key = " + nKey));
    }
}

