/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_ui;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Storage {
    public static final String VENDOR = "JH-WIFI-FPV";

    public static String getPhoneCardPath() {
        return Environment.getDataDirectory().getPath();
    }

    public static String getNormalSDCardPath() {
        return Environment.getExternalStorageDirectory().getPath();
    }

    public static String getSDCardPathEx() {
        String mount = new String();
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("mount");
            InputStream is = proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            long minSize = 0x40000000L;
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                String[] columns;
                if (line.contains("secure") || line.contains("asec") || !line.contains("fat") && !line.contains("fuse") || (columns = line.split(" ")) == null || columns.length <= 1 || Storage.getTotalSize(columns[1]) <= minSize || Storage.getNormalSDCardPath().equals(columns[1])) continue;
                mount = mount.concat(columns[1] + ";");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mount;
    }

    public static long getTotalSize(String path) {
        try {
            File base = new File(path);
            StatFs stat = new StatFs(base.getPath());
            long nTotalCount = stat.getBlockSizeLong() * stat.getBlockCountLong();
            return nTotalCount;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getAvailableSize(String path) {
        try {
            File base = new File(path);
            StatFs stat = new StatFs(base.getPath());
            long nAvailableCount = stat.getBlockSizeLong() * stat.getAvailableBlocksLong();
            long nTotalCount = stat.getBlockSizeLong() * stat.getBlockCountLong();
            return nAvailableCount;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static float dip2pxF(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return dpValue * scale;
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }
}

