/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_drone;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.joyhonest.jh_drone.drone_Select_Activity;
import com.joyhonest.jh_ui.JH_App;
import com.joyhonest.jh_ui.PermissionAsker;
import com.joyhonest.jh_ui.R;
import com.joyhonest.wifination.wifination;
import org.simple.eventbus.EventBus;
import org.simple.eventbus.Subscriber;

public class droneActivity
extends AppCompatActivity
implements View.OnClickListener {
    private PermissionAsker mAsker;
    private Button btn_photo;
    private Button btn_video;
    private Button btn_brow;
    private Button btn_wifi;
    private Button btn_back;
    private TextView RectimeView;
    private ImageView DispImageView;
    private HandlerThread thread1;
    private Handler openHandler;
    private Runnable openRunnable = new Runnable(){

        @Override
        public void run() {
            JH_App.bIsRevBmp = false;
            JH_App.F_OpenCamera(true);
        }
    };
    Handler RssiHander = new Handler();
    Runnable RssiRunable = new Runnable(){

        @Override
        public void run() {
            int nrssi = JH_App.F_GetWifiRssi();
            if (nrssi < 0) {
                nrssi = 0;
            }
            if (nrssi > 4) {
                nrssi = 4;
            }
            if (nrssi == 0) {
                droneActivity.this.btn_wifi.setBackgroundResource(R.mipmap.jhd_wifi0);
            } else if (nrssi == 1) {
                droneActivity.this.btn_wifi.setBackgroundResource(R.mipmap.jhd_wifi1);
            } else if (nrssi == 2) {
                droneActivity.this.btn_wifi.setBackgroundResource(R.mipmap.jhd_wifi2);
            } else if (nrssi == 3) {
                droneActivity.this.btn_wifi.setBackgroundResource(R.mipmap.jhd_wifi3);
            } else {
                droneActivity.this.btn_wifi.setBackgroundResource(R.mipmap.jhd_wifi4);
            }
            droneActivity.this.RssiHander.postDelayed((Runnable)this, 1000L);
        }
    };
    private Handler DispRecTimeHander = new Handler();
    private Runnable DispRecTimeRunnable = new Runnable(){

        @Override
        public void run() {
            if ((JH_App.nSdStatus & 2) != 0) {
                int rec = wifination.naGetRecordTime() / 1000;
                int nMin = rec / 60;
                int nSec = rec % 60;
                String str = String.format("%02d:%02d", nMin, nSec);
                droneActivity.this.RectimeView.setText((CharSequence)str);
                droneActivity.this.DispRecTimeHander.postDelayed((Runnable)this, 250L);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        JH_App.bIsSyMa = false;
        this.setContentView(R.layout.activity_drone);
        wifination.naSetRevBmp(true);
        wifination.appContext = this.getApplicationContext();
        wifination.naSetVrBackground(false);
        JH_App.F_InitMusic();
        this.thread1 = new HandlerThread("MyHandlerThread_FPV");
        this.thread1.start();
        this.openHandler = new Handler(this.thread1.getLooper());
        this.btn_wifi = (Button)this.findViewById(R.id.btn_Wifi);
        this.btn_photo = (Button)this.findViewById(R.id.btn_Photo);
        this.btn_video = (Button)this.findViewById(R.id.btn_Video);
        this.btn_brow = (Button)this.findViewById(R.id.btn_Brow);
        this.btn_wifi = (Button)this.findViewById(R.id.btn_Wifi);
        this.btn_back = (Button)this.findViewById(R.id.btn_Back);
        this.RectimeView = (TextView)this.findViewById(R.id.RectimeView);
        this.btn_photo.setOnClickListener((View.OnClickListener)this);
        this.btn_video.setOnClickListener((View.OnClickListener)this);
        this.btn_brow.setOnClickListener((View.OnClickListener)this);
        this.btn_wifi.setOnClickListener((View.OnClickListener)this);
        this.btn_back.setOnClickListener((View.OnClickListener)this);
        this.DispImageView = (ImageView)this.findViewById(R.id.DispImageView);
        this.mAsker = new PermissionAsker(10, new Runnable(){

            @Override
            public void run() {
                droneActivity.this.F_Init();
            }
        }, new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)droneActivity.this, (CharSequence)"The necessary permission denied, the application exit", (int)0).show();
                droneActivity.this.finish();
            }
        }).askPermission((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE");
        this.RssiHander.post(this.RssiRunable);
        EventBus.getDefault().register((Object)this);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.mAsker.onRequestPermissionsResult(grantResults);
    }

    protected void onResume() {
        super.onResume();
        JH_App.checkDeviceHasNavigationBar((Context)this);
    }

    private void F_Init() {
        JH_App.F_CreateLocalDroneDefalutDir();
        JH_App.F_Clear_not_videoFiles();
        this.openHandler.postDelayed(this.openRunnable, 100L);
    }

    public void onBackPressed() {
        super.onBackPressed();
        JH_App.F_OpenCamera(false);
    }

    protected void onDestroy() {
        super.onDestroy();
        JH_App.F_OpenCamera(false);
        this.RssiHander.removeCallbacksAndMessages(null);
        EventBus.getDefault().unregister((Object)this);
        this.thread1.quit();
        this.openHandler.removeCallbacksAndMessages(null);
    }

    private void TackPhoto() {
        if (!JH_App.bIsRevBmp) {
            return;
        }
        String str = JH_App.F_GetSaveName(true);
        wifination.naSnapPhoto(str, 0);
        JH_App.F_PlayPhoto();
    }

    private void StartOrStopRecord() {
        if (JH_App.bIsRevBmp) {
            if ((JH_App.nSdStatus & 2) == 0) {
                String str = JH_App.F_GetSaveName(false);
                wifination.naStartRecord(str, 0);
            } else {
                wifination.naStopRecord_All();
            }
        }
    }

    public void onClick(View v) {
        if (v == this.btn_back) {
            this.onBackPressed();
        } else if (v == this.btn_brow) {
            Intent mainIntent = new Intent((Context)this, drone_Select_Activity.class);
            this.startActivity(mainIntent);
        } else if (v == this.btn_photo) {
            this.TackPhoto();
        } else if (v == this.btn_video) {
            this.StartOrStopRecord();
        }
    }

    private void DispRecTimeView(boolean b) {
        if (b) {
            this.RectimeView.setText((CharSequence)"00:00");
            this.RectimeView.setVisibility(0);
            this.DispRecTimeHander.removeCallbacksAndMessages(null);
            this.DispRecTimeHander.post(this.DispRecTimeRunnable);
        } else {
            this.DispRecTimeHander.removeCallbacksAndMessages(null);
            this.RectimeView.setVisibility(4);
            this.RectimeView.setText((CharSequence)"00:00");
        }
    }

    @Subscriber(tag="SDStatus_Changed")
    private void _SDStatus_Changed(Integer nStatus) {
        int backStatus = JH_App.nSdStatus;
        JH_App.nSdStatus = (nStatus & 1) != 0 ? (JH_App.nSdStatus |= 1) : (JH_App.nSdStatus &= 0xFFFE);
        if ((nStatus & 2) != 0) {
            if ((JH_App.nSdStatus & 2) == 0) {
                JH_App.nSdStatus |= 2;
                this.DispRecTimeView(true);
            }
        } else {
            JH_App.nSdStatus &= 0xFFFD;
            this.DispRecTimeView(false);
        }
    }

    @Subscriber(tag="SavePhotoOK")
    private void SavePhotoOK(String Sn) {
        if (Sn.length() < 5) {
            return;
        }
        String sType = Sn.substring(0, 2);
        String sName = Sn.substring(2, Sn.length());
        int nPhoto = Integer.parseInt(sType);
        if (nPhoto == 0) {
            JH_App.F_Save2ToGallery(sName, true);
        } else {
            JH_App.F_Save2ToGallery(sName, false);
        }
    }

    @Subscriber(tag="ReviceBMP")
    private void ReviceBMP(Bitmap bmp) {
        JH_App.bIsRevBmp = true;
        this.DispImageView.setImageBitmap(bmp);
    }
}

