/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.util.Log;
import java.util.HashSet;
import java.util.Set;

public final class Logger {
    private static final String DEFAULT_TAG = "tensorflow";
    private static final int DEFAULT_MIN_LOG_LEVEL = 3;
    private static final Set<String> IGNORED_CLASS_NAMES = new HashSet<String>(3);
    private final String tag;
    private final String messagePrefix;
    private int minLogLevel = 3;

    public Logger(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    public Logger(String messagePrefix) {
        this(DEFAULT_TAG, messagePrefix);
    }

    public Logger(String tag, String messagePrefix) {
        this.tag = tag;
        String prefix = messagePrefix == null ? Logger.getCallerSimpleName() : messagePrefix;
        this.messagePrefix = prefix.length() > 0 ? prefix + ": " : prefix;
    }

    public Logger() {
        this(DEFAULT_TAG, null);
    }

    public Logger(int minLogLevel) {
        this(DEFAULT_TAG, null);
        this.minLogLevel = minLogLevel;
    }

    public void setMinLogLevel(int minLogLevel) {
        this.minLogLevel = minLogLevel;
    }

    public boolean isLoggable(int logLevel) {
        return logLevel >= this.minLogLevel || Log.isLoggable((String)this.tag, (int)logLevel);
    }

    private static String getCallerSimpleName() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement elem : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = elem.getClassName();
            if (IGNORED_CLASS_NAMES.contains(className)) continue;
            String[] classParts = className.split("\\.");
            return classParts[classParts.length - 1];
        }
        return Logger.class.getSimpleName();
    }

    private String toMessage(String format, Object ... args) {
        return this.messagePrefix + (args.length > 0 ? String.format(format, args) : format);
    }

    public void v(String format, Object ... args) {
        if (this.isLoggable(2)) {
            Log.v((String)this.tag, (String)this.toMessage(format, args));
        }
    }

    public void v(Throwable t, String format, Object ... args) {
        if (this.isLoggable(2)) {
            Log.v((String)this.tag, (String)this.toMessage(format, args), (Throwable)t);
        }
    }

    public void d(String format, Object ... args) {
        if (this.isLoggable(3)) {
            Log.d((String)this.tag, (String)this.toMessage(format, args));
        }
    }

    public void d(Throwable t, String format, Object ... args) {
        if (this.isLoggable(3)) {
            Log.d((String)this.tag, (String)this.toMessage(format, args), (Throwable)t);
        }
    }

    public void i(String format, Object ... args) {
        if (this.isLoggable(4)) {
            Log.i((String)this.tag, (String)this.toMessage(format, args));
        }
    }

    public void i(Throwable t, String format, Object ... args) {
        if (this.isLoggable(4)) {
            Log.i((String)this.tag, (String)this.toMessage(format, args), (Throwable)t);
        }
    }

    public void w(String format, Object ... args) {
        if (this.isLoggable(5)) {
            Log.w((String)this.tag, (String)this.toMessage(format, args));
        }
    }

    public void w(Throwable t, String format, Object ... args) {
        if (this.isLoggable(5)) {
            Log.w((String)this.tag, (String)this.toMessage(format, args), (Throwable)t);
        }
    }

    public void e(String format, Object ... args) {
        if (this.isLoggable(6)) {
            Log.e((String)this.tag, (String)this.toMessage(format, args));
        }
    }

    public void e(Throwable t, String format, Object ... args) {
        if (this.isLoggable(6)) {
            Log.e((String)this.tag, (String)this.toMessage(format, args), (Throwable)t);
        }
    }

    static {
        IGNORED_CLASS_NAMES.add("dalvik.system.VMStack");
        IGNORED_CLASS_NAMES.add("java.lang.Thread");
        IGNORED_CLASS_NAMES.add(Logger.class.getCanonicalName());
    }
}

