/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Point;
import android.graphics.RectF;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.joyhonest.jh_ui.JH_App;
import com.joyhonest.jh_ui.MyRipple;
import com.joyhonest.jh_ui.R;
import com.joyhonest.jh_ui.Storage;
import java.util.ArrayList;
import org.simple.eventbus.EventBus;
import org.simple.eventbus.Subscriber;

public class MyControl
extends RelativeLayout
implements SensorEventListener {
    public static boolean bFlyType = true;
    public boolean bDisText = true;
    public MyRockeViewA RockeLeft;
    private MyRockeViewA RockeRight;
    private MyRockeViewA RockeLeftA;
    private MyRockeViewA RockeRightA;
    public PathViewA pathView;
    private MyPrivView leftView;
    private int nCentWidth;
    private int nRockWidth;
    public boolean bGravity = false;
    private int nMode = 0;
    public boolean bHoldHeight = true;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private float[] gravity;
    RelativeLayout.LayoutParams params1;
    RelativeLayout.LayoutParams params2;
    RelativeLayout.LayoutParams params3;
    RelativeLayout.LayoutParams params_leftview;
    Bitmap background;
    Bitmap cirBmp;
    int topPx;
    int botPx;
    private Bitmap bbitbmp;

    public void F_Invalidate() {
        this.RockeLeft.invalidate();
        this.RockeRight.invalidate();
    }

    public void F_ReasetAll() {
        this.RockeLeftA.F_ReasetDir();
        this.RockeRightA.F_ReasetDir();
    }

    public void F_SetFlyRecord(boolean b) {
        if (this.RockeLeft != null) {
            this.RockeLeft.F_SetFlyRecord(b);
        }
        if (this.RockeRight != null) {
            this.RockeRight.F_SetFlyRecord(b);
        }
    }

    public void F_SetDispText(boolean b) {
        if (b) {
            if (this.RockeRight != null) {
                this.RockeLeft.Str1 = "THRO";
                this.RockeLeft.Str2 = "RUDO";
            }
            if (this.RockeRight != null) {
                this.RockeRight.Str1 = "ELEV";
                this.RockeRight.Str2 = "AILE";
            }
        } else {
            if (this.RockeLeftA != null) {
                this.RockeLeftA.Str1 = "";
                this.RockeLeftA.Str2 = "";
            }
            if (this.RockeRightA != null) {
                this.RockeRightA.Str1 = "";
                this.RockeRightA.Str2 = "";
            }
        }
        this.RockeLeftA.invalidate();
        this.RockeRightA.invalidate();
    }

    public MyControl(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MyControl(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public MyControl(Context context) {
        super(context);
        this.init();
    }

    public void F_SetSize(MyRockeViewA ctl) {
        this.RockeLeft.CirRadius = ctl.CirRadius;
        this.RockeLeft.Radius = ctl.Radius;
        this.RockeLeft.Radius_V1 = ctl.Radius_V1;
        this.RockeLeft.centx = ctl.centx;
        this.RockeLeft.centy = ctl.centy;
        ((MyRockeViewA)this.RockeLeft).cirPoint.x = ((MyRockeViewA)ctl).cirPoint.x;
        ((MyRockeViewA)this.RockeLeft).cirPoint.y = ((MyRockeViewA)ctl).cirPoint.y;
        this.RockeLeft.F_ReasetEngine();
    }

    public void F_SetNoDispVBar(boolean b) {
        this.RockeLeft.bDispVbar = !b;
        this.RockeRight.bDispVbar = !b;
        this.RockeLeft.invalidate();
        this.RockeRight.invalidate();
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        int dat = 60;
        if (event.sensor.getType() == 1) {
            float alpha = 0.95f;
            this.gravity[0] = 0.95f * this.gravity[0] + 0.050000012f * event.values[0];
            this.gravity[1] = 0.95f * this.gravity[1] + 0.050000012f * event.values[1];
            this.gravity[2] = 0.95f * this.gravity[2] + 0.050000012f * event.values[2];
            int x = (int)(this.gravity[0] * (float)dat);
            int y = (int)(this.gravity[1] * (float)dat);
            int z = (int)(this.gravity[2] * (float)dat);
            if (this.bGravity) {
                this.RockeLeft.F_Calculator_Acceleration(x, y, z);
                this.RockeRight.F_Calculator_Acceleration(x, y, z);
            }
        } else if (event.sensor.getType() == 9) {
            int x = (int)(event.values[0] * (float)dat);
            int y = (int)(event.values[1] * (float)dat);
            int z = (int)(event.values[2] * (float)dat);
            if (this.bGravity) {
                this.RockeLeft.F_Calculator_Acceleration(x, y, z);
                this.RockeRight.F_Calculator_Acceleration(x, y, z);
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void F_SetImage(int nBackgroud, int nCir) {
        this.background = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)nBackgroud);
        this.cirBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)nCir);
        this.RockeLeftA.F_SetImage(this.background, this.cirBmp);
        this.RockeRightA.F_SetImage(this.background, this.cirBmp);
        this.invalidate();
    }

    private void init() {
        this.setWillNotDraw(false);
        Context context = this.getContext();
        this.bbitbmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.cir_back_fly_jh_fig);
        if (bFlyType) {
            this.topPx = Storage.dip2px(context, 40.0f);
            this.botPx = Storage.dip2px(context, 40.0f);
        } else {
            this.topPx = Storage.dip2px(context, 30.0f);
            this.botPx = Storage.dip2px(context, 30.0f);
        }
        this.background = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.cir_back_jh);
        this.cirBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.cir_jh);
        this.bHoldHeight = true;
        this.bGravity = false;
        this.gravity = new float[3];
        this.gravity[0] = 0.0f;
        this.gravity[1] = 0.0f;
        this.gravity[2] = 0.0f;
        this.nCentWidth = MyControl.dip2px(context, 10.0f);
        this.nRockWidth = MyControl.dip2px(context, 60.0f);
        this.RockeLeftA = new MyRockeViewA(context, this.background, this.cirBmp, bFlyType);
        this.RockeRightA = new MyRockeViewA(context, this.background, this.cirBmp, bFlyType);
        this.RockeLeftA.bLayoutLeft = false;
        this.RockeRightA.bLayoutLeft = true;
        this.RockeLeft = this.RockeLeftA;
        this.RockeRight = this.RockeRightA;
        this.RockeLeft.Str1 = "THRO";
        this.RockeLeft.Str2 = "RUDO";
        this.RockeRight.Str1 = "ELEV";
        this.RockeRight.Str2 = "AILE";
        this.pathView = new PathViewA(context);
        this.leftView = new MyPrivView(context);
        this.params1 = new RelativeLayout.LayoutParams(-1, -1);
        this.params2 = new RelativeLayout.LayoutParams(-1, -1);
        this.params3 = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.pathView, (ViewGroup.LayoutParams)this.params1);
        this.pathView.setVisibility(4);
        this.pathView.setBackgroundColor(0x1000000);
        this.params_leftview = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.leftView, (ViewGroup.LayoutParams)this.params_leftview);
        this.leftView.setVisibility(0);
        this.leftView.setBackgroundColor(0x1000000);
        this.params2.addRule(9);
        this.params2.setMargins(-1, -1, -1, -1);
        this.addView((View)this.RockeLeft, (ViewGroup.LayoutParams)this.params2);
        this.params3.addRule(11);
        this.params3.setMargins(-1, -1, -1, -1);
        this.addView((View)this.RockeRight, (ViewGroup.LayoutParams)this.params3);
        this.RockeLeft.bLeft = true;
        this.RockeRight.bLeft = false;
        this.F_SetGravity(true);
        this.F_SetMode(0);
        this.setBackgroundColor(0x1000000);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int WW = width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        if (width > this.nCentWidth) {
            width -= this.nCentWidth;
        }
        this.nRockWidth = width /= 2;
        this.params2.width = WW / 2;
        this.RockeLeftA.setLayoutParams((ViewGroup.LayoutParams)this.params2);
        this.params3.width = WW / 2;
        this.RockeRightA.setLayoutParams((ViewGroup.LayoutParams)this.params3);
        this.params_leftview.width = this.nRockWidth;
        this.leftView.setLayoutParams((ViewGroup.LayoutParams)this.params_leftview);
    }

    public void F_SetAdjType1(boolean bType1) {
        this.RockeLeft.bAdjMode1 = bType1;
        this.RockeRight.bAdjMode1 = bType1;
    }

    public void F_SetHoldHeight(boolean b) {
        int nType;
        this.bHoldHeight = b;
        if (!this.bHoldHeight) {
            nType = this.RockeLeft.nType;
            this.RockeLeft.nType = nType &= 0xFD;
        } else {
            nType = this.RockeLeft.nType;
            this.RockeLeft.nType = nType |= 2;
        }
        nType = this.RockeRight.nType;
        this.RockeRight.nType = nType |= 2;
        this.RockeLeft.F_ReasetEngine();
        this.RockeRight.F_ReasetEngine();
    }

    private void F_initSensor() {
        Context context = this.getContext();
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        if (null == this.mSensorManager) {
            Log.d((String)"PlayerActivity", (String)"deveice not support SensorManager");
        } else {
            this.mSensor = this.mSensorManager.getDefaultSensor(1);
            if (this.mSensor == null) {
                this.mSensor = this.mSensorManager.getDefaultSensor(9);
            }
        }
    }

    public void F_SetGravity(boolean b) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.mSensorManager == null) {
            this.F_initSensor();
        }
        if (b) {
            if (!this.bGravity) {
                this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 0);
                this.bGravity = true;
            }
        } else {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.bGravity = false;
        }
    }

    public int F_GetRotate() {
        int x = -1;
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                x = this.RockeLeft.F_GetX();
                break;
            }
            case 4: 
            case 5: {
                x = this.RockeRight.F_GetX();
            }
        }
        if (x < 2) {
            x = 0;
        }
        return x;
    }

    public int F_GetThrottle() {
        int y = -1;
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                y = this.RockeLeft.F_GetY();
            }
        }
        if (y < 2) {
            y = 0;
        }
        return y;
    }

    public int F_GetForwardBack() {
        int data = -1;
        if (this.pathView.getVisibility() == 0) {
            if (this.pathView.bFlight) {
                return this.pathView.nY2;
            }
            return 128;
        }
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                data = this.RockeRight.F_GetY();
            }
        }
        if (data > 112 && data < 144) {
            data = 128;
        }
        if (data < 2) {
            data = 0;
        }
        return data;
    }

    public int F_GetLeftRight() {
        int data = -1;
        if (this.pathView.getVisibility() == 0) {
            if (this.pathView.bFlight) {
                return this.pathView.nX2;
            }
            return 128;
        }
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                data = this.RockeRight.F_GetX();
                break;
            }
            case 4: 
            case 5: {
                data = this.RockeLeft.F_GetX();
            }
        }
        if (data > 112 && data < 144) {
            data = 128;
        }
        if (data < 2) {
            data = 0;
        }
        return data;
    }

    public void F_SetRotateAdj(int n) {
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.RockeLeft.F_SetAdjX(n);
                break;
            }
            case 4: 
            case 5: {
                this.RockeRight.F_SetAdjX(n);
            }
        }
    }

    public int F_GetRotateAdj() {
        int dat = -1;
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                dat = this.RockeLeft.F_GetAdjX();
                break;
            }
            case 4: 
            case 5: {
                dat = this.RockeRight.F_GetAdjX();
            }
        }
        return dat;
    }

    public void F_SetForwardBackAdj(int n) {
        this.RockeRight.F_SetAdjY(n);
    }

    public int F_GetForwardBackAdj() {
        int dat = -1;
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                dat = this.RockeRight.F_GetAdjY();
            }
        }
        return dat;
    }

    public void F_SetLeftRightAdj(int n) {
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.RockeRight.F_SetAdjX(n);
                break;
            }
            case 4: 
            case 5: {
                this.RockeLeft.F_SetAdjX(n);
            }
        }
    }

    public int F_GetLeftRightAdj() {
        int dat = -1;
        switch (this.nMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                dat = this.RockeRight.F_GetAdjX();
                break;
            }
            case 4: 
            case 5: {
                dat = this.RockeLeft.F_GetAdjX();
            }
        }
        return dat;
    }

    public void F_SetMode(int nMode) {
        if (nMode < 0 || nMode > 5) {
            return;
        }
        this.nMode = nMode;
        if (nMode == 0) {
            this.F_SetGravity(false);
            this.RockeLeft = this.RockeLeftA;
            this.RockeRight = this.RockeRightA;
            int nType = 0;
            nType |= 0x10;
            if (this.bHoldHeight) {
                nType |= 2;
            }
            this.RockeLeft.F_SetType(nType |= 1);
            nType = 0;
            nType |= 2;
            this.RockeRight.F_SetType(nType |= 1);
            this.RockeRight.F_SetVLR(true);
            if (bFlyType) {
                this.RockeRight.F_SetImage(this.background);
            }
        } else if (nMode == 1) {
            this.RockeLeft = this.RockeLeftA;
            this.RockeRight = this.RockeRightA;
            int nType = 0;
            nType |= 0x10;
            if (this.bHoldHeight) {
                nType |= 2;
            }
            this.RockeLeft.F_SetType(nType |= 1);
            nType = 0;
            nType |= 4;
            this.RockeRight.F_SetType(nType |= 8);
            this.RockeRight.F_SetVLR(true);
            this.F_SetGravity(true);
        } else if (nMode == 2) {
            this.F_SetGravity(false);
            this.RockeLeft = this.RockeRightA;
            this.RockeRight = this.RockeLeftA;
            int nType = 0;
            nType |= 0x10;
            if (this.bHoldHeight) {
                nType |= 2;
            }
            this.RockeLeft.F_SetType(nType |= 1);
            nType = 0;
            nType |= 2;
            this.RockeRight.F_SetType(nType |= 1);
            this.RockeRight.F_SetVLR(false);
        } else if (nMode == 3) {
            this.RockeLeft = this.RockeRightA;
            this.RockeRight = this.RockeLeftA;
            int nType = 0;
            nType |= 0x10;
            if (this.bHoldHeight) {
                nType |= 2;
            }
            this.RockeLeft.F_SetType(nType |= 1);
            nType = 0;
            nType |= 4;
            this.RockeRight.F_SetType(nType |= 8);
            this.RockeRight.F_SetVLR(false);
            this.F_SetGravity(true);
        } else if (nMode == 4) {
            this.F_SetGravity(false);
            this.RockeLeft = this.RockeRightA;
            this.RockeRight = this.RockeLeftA;
            int nType = 0;
            nType |= 0x10;
            if (this.bHoldHeight) {
                nType |= 2;
            }
            this.RockeLeft.F_SetType(nType |= 1);
            nType = 0;
            nType |= 2;
            this.RockeRight.F_SetType(nType |= 1);
            this.RockeRight.F_SetVLR(false);
        } else {
            this.RockeLeft = this.RockeRightA;
            this.RockeRight = this.RockeLeftA;
            int nType = 0;
            nType |= 0x10;
            if (this.bHoldHeight) {
                nType |= 2;
            }
            nType |= 4;
            this.RockeLeft.F_SetType(nType |= 0x20);
            nType = 0;
            nType |= 1;
            nType |= 8;
            this.RockeRight.F_SetType(nType |= 0x40);
            this.RockeRight.F_SetVLR(false);
            this.F_SetGravity(true);
        }
        this.RockeRight.invalidate();
        this.RockeLeft.invalidate();
    }

    private static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private void F_DispControlInPath(boolean bDisp) {
        int disp = 0;
        if (!bDisp) {
            disp = 4;
        }
        switch (this.nMode) {
            case 0: 
            case 1: {
                this.RockeRightA.setVisibility(disp);
                this.RockeLeftA.setVisibility(0);
                if (!bDisp) {
                    this.RockeRightA.bPath = false;
                    this.RockeLeftA.bPath = true;
                    break;
                }
                this.RockeRightA.bPath = false;
                this.RockeLeftA.bPath = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.RockeLeftA.setVisibility(disp);
                this.RockeRightA.setVisibility(0);
                if (!bDisp) {
                    this.RockeRightA.bPath = true;
                    this.RockeLeftA.bPath = false;
                    break;
                }
                this.RockeRightA.bPath = false;
                this.RockeLeftA.bPath = false;
            }
        }
        this.RockeRightA.invalidate();
        this.RockeLeftA.invalidate();
    }

    public boolean isInPathMode() {
        return this.pathView.getVisibility() == 0;
    }

    public void F_StopPath() {
        this.pathView.StoppathAnim();
    }

    public void F_DispPahtView(boolean bDisp) {
        if (bDisp) {
            this.pathView.StoppathAnim();
            this.pathView.setVisibility(0);
            this.F_DispControlInPath(false);
        } else {
            this.pathView.StoppathAnim();
            this.pathView.setVisibility(4);
            this.F_DispControlInPath(true);
        }
    }

    public class PathViewA
    extends RelativeLayout {
        public boolean bNeedDrawIcon;
        static final int nSTep = 101;
        public int nDelaySet;
        public int nDelay;
        private Paint mPaint;
        private int mCount;
        public int nX2;
        public int nY2;
        private int nPointInx;
        ArrayList<Point> pointArray;
        private Bitmap pathIcon;
        private Path mPath;
        private PathMeasure mPathMeasure;
        float[] mCurrentPosition;
        public boolean bFlight;
        private ImageView imageView;
        private static final int need_No = 0;
        private static final int need_Reset_Ani = 1;
        private float IconWidth;
        private int need_pro;
        PathInterpolator pathInterpolator;
        AnimatorSet animSet;
        AnimatorSet animSetActive;
        ValueAnimator valueAnimator;
        Handler AdjXY_handler;
        Runnable AdjXY_Run;
        int nActiveInx;

        public PathViewA(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.bNeedDrawIcon = false;
            this.nDelaySet = 40;
            this.bFlight = false;
            this.need_pro = 0;
            this.AdjXY_handler = new Handler();
            this.AdjXY_Run = new Runnable(){

                @Override
                public void run() {
                    boolean bRe = PathViewA.this.F_AdjXY();
                    if (bRe) {
                        if (PathViewA.this.nPointInx < 3) {
                            PathViewA.this.AdjXY_handler.postDelayed((Runnable)this, 10L);
                        } else {
                            PathViewA.this.AdjXY_handler.postDelayed((Runnable)this, (long)PathViewA.this.nDelay);
                        }
                    }
                }
            };
            this.nActiveInx = -1;
            this.init();
        }

        public PathViewA(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.bNeedDrawIcon = false;
            this.nDelaySet = 40;
            this.bFlight = false;
            this.need_pro = 0;
            this.AdjXY_handler = new Handler();
            this.AdjXY_Run = new /* invalid duplicate definition of identical inner class */;
            this.nActiveInx = -1;
            this.init();
        }

        public PathViewA(Context context) {
            super(context);
            this.bNeedDrawIcon = false;
            this.nDelaySet = 40;
            this.bFlight = false;
            this.need_pro = 0;
            this.AdjXY_handler = new Handler();
            this.AdjXY_Run = new /* invalid duplicate definition of identical inner class */;
            this.nActiveInx = -1;
            this.init();
        }

        @Subscriber(tag="Send2_path")
        public void Send2_path(Integer n) {
            this.nDelaySet = bFlyType ? (n == 2 ? 90 : (n == 3 ? 110 : 70)) : (n == 2 ? 70 : (n == 3 ? 110 : 50));
        }

        private void init() {
            this.setWillNotDraw(false);
            EventBus.getDefault().register((Object)this);
            this.IconWidth = Storage.dip2pxF(this.getContext(), 20.0f) / 2.0f;
            this.nY2 = 128;
            this.nX2 = 128;
            this.valueAnimator = null;
            this.mPaint = new Paint(1);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.imageView = new ImageView(this.getContext());
            if (bFlyType) {
                this.nDelaySet = 70;
                this.pathIcon = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.path_icon_fly);
                this.imageView.setImageResource(R.mipmap.path_icon_fly);
                this.mPaint.setStrokeWidth((float)Storage.dip2px(this.getContext(), 4.0f));
                this.mPaint.setColor(Color.argb((int)255, (int)200, (int)200, (int)200));
            } else {
                this.nDelaySet = 50;
                this.pathIcon = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.path_jh);
                this.imageView.setImageResource(R.mipmap.path_jh);
                this.mPaint.setStrokeWidth((float)Storage.dip2px(this.getContext(), 8.0f));
                this.mPaint.setColor(-16777216);
            }
            this.mPath = new Path();
            this.pointArray = new ArrayList();
            this.mPath.reset();
            this.mCurrentPosition = new float[2];
            this.bNeedDrawIcon = false;
            RelativeLayout.LayoutParams param = new RelativeLayout.LayoutParams((int)this.IconWidth * 2, (int)this.IconWidth * 2);
            this.addView((View)this.imageView, (ViewGroup.LayoutParams)param);
            this.imageView.setVisibility(4);
            this.animSet = new AnimatorSet();
            this.animSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    PathViewA.this.imageView.setVisibility(0);
                    PathViewA.this.bFlight = true;
                }

                public void onAnimationEnd(Animator animation) {
                    PathViewA.this.F_Remove();
                    PathViewA.this.bFlight = false;
                    if (PathViewA.this.need_pro == 0) {
                        PathViewA.this.invalidate();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    PathViewA.this.F_Remove();
                    PathViewA.this.bFlight = false;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.valueAnimator = new ValueAnimator();
            this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    PathViewA.this.mPathMeasure.getPosTan(value, PathViewA.this.mCurrentPosition, null);
                    PathViewA.this.postInvalidate();
                }
            });
            this.valueAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    Log.d((String)"ani", (String)"animation start");
                    Log.e((String)"ani", (String)("point size = " + PathViewA.this.pointArray.size()));
                    PathViewA.this.bNeedDrawIcon = true;
                    PathViewA.this.bFlight = true;
                }

                public void onAnimationEnd(Animator animation) {
                    Log.d((String)"qijian", (String)"animation end");
                    PathViewA.this.bNeedDrawIcon = false;
                    PathViewA.this.bFlight = true;
                    PathViewA.this.nY2 = 128;
                    PathViewA.this.nX2 = 128;
                    if (PathViewA.this.need_pro == 0) {
                        PathViewA.this.invalidate();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    Log.d((String)"qijian", (String)"animation cancel");
                    PathViewA.this.bNeedDrawIcon = false;
                    PathViewA.this.bFlight = true;
                }

                public void onAnimationRepeat(Animator animation) {
                    Log.d((String)"qijian", (String)"animation repeat");
                }
            });
        }

        private void F_Remove() {
            this.imageView.setVisibility(4);
        }

        private void F_StartA() {
            this.bNeedDrawIcon = false;
            this.need_pro = 0;
            Path path = new Path();
            path.reset();
            for (int i = 0; i < this.pointArray.size(); ++i) {
                Point pointa = this.pointArray.get(i);
                if (i == 0) {
                    path.moveTo((float)pointa.x, (float)pointa.y);
                    continue;
                }
                Point pointb = this.pointArray.get(i - 1);
                float cX = (pointa.x + pointb.x) / 2;
                float cY = (pointa.y + pointb.y) / 2;
                path.quadTo(cX, cY, (float)pointa.x, (float)pointa.y);
            }
            this.mPathMeasure = new PathMeasure(path, false);
            int nleng = this.pointArray.size();
            if (nleng <= 1) {
                this.bFlight = false;
                return;
            }
            this.nDelay = this.nDelaySet;
            long duration = (long)nleng * (long)this.nDelay;
            this.valueAnimator.setFloatValues(new float[]{0.0f, this.mPathMeasure.getLength()});
            this.valueAnimator.setDuration(duration);
            this.valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.valueAnimator.start();
            this.nPointInx = 0;
            this.AdjXY_handler.removeCallbacksAndMessages(null);
            this.AdjXY_handler.post(this.AdjXY_Run);
        }

        public void startPathAnimA(long duration) {
            boolean nleng = false;
            this.bNeedDrawIcon = false;
            if (this.valueAnimator.isRunning()) {
                this.need_pro = 1;
                this.valueAnimator.cancel();
                Handler handler = new Handler();
                Runnable runA = new Runnable(){

                    @Override
                    public void run() {
                        PathViewA.this.F_StartA();
                    }
                };
                handler.postDelayed(runA, 25L);
                return;
            }
            this.F_StartA();
        }

        public void startPathAnimB(long du) {
            if (this.animSet.isRunning()) {
                this.need_pro = 1;
                this.animSet.cancel();
                Handler handler = new Handler();
                Runnable runB = new Runnable(){

                    @Override
                    public void run() {
                        PathViewA.this.F_StartB();
                    }
                };
                handler.postDelayed(runB, 25L);
            } else {
                this.F_StartB();
            }
        }

        private void F_StartB() {
            this.need_pro = 0;
            Path path = new Path();
            int nLen = this.pointArray.size();
            Log.v((String)"ddd  ", (String)("nLen = " + nLen));
            if (nLen <= 1) {
                return;
            }
            for (int i = 0; i < this.pointArray.size(); ++i) {
                Point pointa = this.pointArray.get(i);
                float preX = (float)pointa.x - this.IconWidth;
                float preY = (float)pointa.y - this.IconWidth;
                if (i == 0) {
                    path.moveTo(preX, preY);
                    continue;
                }
                Point pointb = this.pointArray.get(i - 1);
                preX = (float)pointb.x - this.IconWidth;
                preY = (float)pointb.y - this.IconWidth;
                float cX = (pointa.x + pointb.x) / 2;
                float cY = (pointa.y + pointb.y) / 2;
                float XX = cX - this.IconWidth;
                float YY = cY - this.IconWidth;
                path.lineTo(XX, YY);
                this.mPath.quadTo(XX, YY, preX, preY);
            }
            ObjectAnimator traslateAnimator = null;
            if (Build.VERSION.SDK_INT >= 21) {
                traslateAnimator = ObjectAnimator.ofFloat((Object)this.imageView, (String)"x", (String)"y", (Path)path);
            }
            this.animSet.playTogether(new Animator[]{traslateAnimator});
            int nleng = this.pointArray.size();
            this.nDelay = this.nDelaySet;
            this.animSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.animSet.setDuration((long)(nleng *= this.nDelay));
            this.animSet.start();
            this.nPointInx = 0;
            this.AdjXY_handler.removeCallbacksAndMessages(null);
            this.AdjXY_handler.post(this.AdjXY_Run);
        }

        public void StoppathAnim() {
            this.need_pro = 0;
            if (Build.VERSION.SDK_INT >= 21) {
                this.animSet.cancel();
            } else if (this.valueAnimator != null) {
                this.valueAnimator.cancel();
            }
            this.bFlight = false;
            this.AdjXY_handler.removeCallbacksAndMessages(null);
            this.pointArray.clear();
            this.invalidate();
        }

        private boolean F_AdjXY() {
            if (this.nPointInx < this.pointArray.size()) {
                if (this.nPointInx > 1) {
                    Point point = this.pointArray.get(this.nPointInx);
                    Point prepoint = this.pointArray.get(this.nPointInx - 1);
                    int dx = point.x - prepoint.x;
                    int dy = -(point.y - prepoint.y);
                    if (dx != 0 && dy != 0) {
                        if (dx != 0) {
                            float angle = (float)Math.atan2(dy, dx);
                            float dyy = (float)(Math.abs(Math.sin(angle)) * 101.0);
                            float dxx = (float)(Math.abs(Math.cos(angle)) * 101.0);
                            if (dx > 0) {
                                this.nX2 = (int)(128.0f + dxx);
                                this.nY2 = dy > 0 ? (int)(128.0f + dyy) : ((float)dy < 0.0f ? (int)(128.0f - dyy) : 128);
                            } else if (dx < 0) {
                                this.nX2 = (int)(128.0f - dxx);
                                this.nY2 = dy > 0 ? (int)(128.0f + dyy) : (dy < 0 ? (int)(128.0f - dyy) : 128);
                            }
                        } else {
                            this.nX2 = 128;
                            this.nY2 = dy > 0 ? 229 : (dy < 0 ? 27 : 128);
                        }
                    }
                }
                if (this.nPointInx < 2) {
                    this.nX2 = 128;
                    this.nY2 = 128;
                }
                ++this.nPointInx;
                if (this.nPointInx >= this.pointArray.size()) {
                    this.bFlight = false;
                    return false;
                }
            } else {
                this.bFlight = false;
                return false;
            }
            return true;
        }

        public void startPathAnim(long duration) {
            this.AdjXY_handler.removeCallbacksAndMessages(null);
            this.nPointInx = 0;
            if (Build.VERSION.SDK_INT >= 21) {
                this.startPathAnimB(0L);
            } else {
                this.startPathAnimA(0L);
            }
        }

        public void F_Clear() {
            this.bNeedDrawIcon = false;
            this.mPath.reset();
            this.pointArray.clear();
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.pointArray.size() > 2) {
                this.mPath.reset();
                for (int i = 0; i < this.pointArray.size(); ++i) {
                    Point pointa = this.pointArray.get(i);
                    if (i == 0) {
                        this.mPath.moveTo((float)pointa.x, (float)pointa.y);
                        continue;
                    }
                    Point pointb = this.pointArray.get(i - 1);
                    int cX = (pointa.x + pointb.x) / 2;
                    int cY = (pointa.y + pointb.y) / 2;
                    this.mPath.quadTo((float)cX, (float)cY, (float)pointa.x, (float)pointa.y);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (this.bNeedDrawIcon) {
                    RectF dstRect = new RectF(this.mCurrentPosition[0] - this.IconWidth, this.mCurrentPosition[1] - this.IconWidth, this.mCurrentPosition[0] + this.IconWidth, this.mCurrentPosition[1] + this.IconWidth);
                    canvas.drawBitmap(this.pathIcon, null, dstRect, null);
                }
            }
        }

        protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        }

        public boolean onTouchEvent(MotionEvent event) {
            int nix;
            int action = event.getAction() & 0xFF;
            if (0 == action) {
                this.nActiveInx = event.getActionIndex();
                this.F_TouchBegin(event);
            }
            if ((1 == action || 6 == action) && (nix = event.getActionIndex()) == this.nActiveInx) {
                this.nActiveInx = -1;
                this.F_TouchEnd(event);
            }
            if (2 == action && (nix = event.getActionIndex()) == this.nActiveInx) {
                this.F_Touchmoved(event);
            }
            return true;
        }

        private void F_TouchBegin(MotionEvent event) {
            this.imageView.setVisibility(4);
            this.pointArray.clear();
            this.bNeedDrawIcon = false;
            Point point = new Point();
            float x = event.getX();
            float y = event.getY();
            point.x = (int)x;
            point.y = (int)y;
            this.pointArray.add(point);
            this.invalidate();
        }

        private void F_TouchEnd(MotionEvent event) {
            this.F_Touchmoved(event);
            this.startPathAnim(0L);
        }

        private void F_Touchmoved(MotionEvent event) {
            Point point = new Point();
            int x = (int)event.getX();
            int y = (int)event.getY();
            point.x = x;
            point.y = y;
            if (this.pointArray.size() > 0) {
                float dw;
                float sq;
                float dy;
                float dx;
                Point prevPointA = this.pointArray.get(this.pointArray.size() - 1);
                float dx1 = dx = (float)(point.x - prevPointA.x);
                float dy1 = dy = (float)(point.y - prevPointA.y);
                if ((sq = (float)Math.sqrt((dx *= dx) + (dy *= dy))) < (dw = Storage.dip2pxF(this.getContext(), 5.0f))) {
                    return;
                }
                int df = (int)(sq / dw);
                if (df > 1) {
                    float stp = dx1 / (float)df;
                    --df;
                    Point pp = new Point();
                    for (int ix = 0; ix < df; ++ix) {
                        pp.x = (int)((float)prevPointA.x + (float)(ix + 1) * stp);
                        pp.y = dx1 != 0.0f ? (int)((float)prevPointA.y + (float)(ix + 1) * stp * (dy1 / dx1)) : prevPointA.y;
                        this.pointArray.add(pp);
                    }
                    this.pointArray.add(point);
                } else {
                    this.pointArray.add(point);
                }
            } else {
                this.pointArray.add(point);
            }
            this.invalidate();
        }
    }

    private class MyPrivView
    extends RelativeLayout {
        public MyPrivView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init();
        }

        public MyPrivView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.init();
        }

        public MyPrivView(Context context) {
            super(context);
            this.init();
        }

        private void init() {
        }

        public boolean onTouchEvent(MotionEvent event) {
            return true;
        }
    }

    public class MyRockeViewA
    extends RelativeLayout {
        private Handler mHandler;
        private MyRipple myRipple;
        public boolean bFlyType;
        public boolean isbFlyType_recording;
        public boolean bDisText;
        public boolean bPath;
        public int nPathSpeed;
        public static final int TYPE_RestCentX = 1;
        public static final int TYPE_RestCentY = 2;
        public static final int TYPE_X_Acceleration = 4;
        public static final int TYPE_Y_Acceleration = 8;
        public static final int TYPE_No_ADJY = 16;
        public static final int TYPE_Acceleration_NoDispX = 32;
        public static final int TYPE_Acceleration_NoDispY = 64;
        public String Str1;
        public String Str2;
        public boolean bDispVbar;
        public boolean bLeft;
        public boolean bLayoutLeft;
        private boolean bCanMoved;
        private int adjx;
        private int adjy;
        private int adjw;
        private int adjh;
        public int Radius;
        public int CirRadius;
        public int Radius_VV;
        public int Radius_V1;
        private Point cirPoint;
        private Point touchPoint;
        private Point cirPointB;
        private Bitmap backBmp;
        private Bitmap backBmp1;
        private Bitmap cirBmp;
        private Bitmap upBmp;
        private Bitmap downBmp;
        private Bitmap leftBmp;
        private Bitmap rightBmp;
        private Bitmap v_BarBmp;
        private Bitmap h_BarBmp;
        private RectF upRect;
        private RectF downRect;
        private RectF leftRect;
        private RectF rightRect;
        private Bitmap thmbV_Bmp;
        private Bitmap thmbH_Bmp;
        private boolean bAdjMode1;
        private Bitmap bar_V_btn_Bmp;
        private Bitmap bar_H_btn_Bmp;
        private Bitmap PathSpeed1_Bmp;
        private Bitmap PathSpeed2_Bmp;
        private Bitmap PathSpeed3_Bmp;
        private Bitmap thmbV_Bmp_A;
        private Bitmap thmbH_Bmp_A;
        private boolean bVbarRight;
        private boolean bTouched;
        public int centx;
        public int centy;
        public int nType;
        private Activity activity;
        private RelativeLayout.LayoutParams ripple_params;
        private RectF dstrect;

        public MyRockeViewA(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.bFlyType = true;
            this.isbFlyType_recording = false;
            this.bDisText = true;
            this.bPath = false;
            this.nPathSpeed = 1;
            this.Str1 = "THRO";
            this.Str2 = "RUDO";
            this.bDispVbar = true;
            this.bLeft = true;
            this.bLayoutLeft = true;
            this.bCanMoved = false;
            this.bAdjMode1 = false;
            this.bVbarRight = true;
            this.bTouched = false;
            this.dstrect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            this.init(true);
        }

        public void F_SetCirR(int r) {
            this.CirRadius = r;
            this.invalidate();
        }

        public MyRockeViewA(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.bFlyType = true;
            this.isbFlyType_recording = false;
            this.bDisText = true;
            this.bPath = false;
            this.nPathSpeed = 1;
            this.Str1 = "THRO";
            this.Str2 = "RUDO";
            this.bDispVbar = true;
            this.bLeft = true;
            this.bLayoutLeft = true;
            this.bCanMoved = false;
            this.bAdjMode1 = false;
            this.bVbarRight = true;
            this.bTouched = false;
            this.dstrect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            this.init(true);
        }

        public MyRockeViewA(Context context) {
            super(context);
            this.bFlyType = true;
            this.isbFlyType_recording = false;
            this.bDisText = true;
            this.bPath = false;
            this.nPathSpeed = 1;
            this.Str1 = "THRO";
            this.Str2 = "RUDO";
            this.bDispVbar = true;
            this.bLeft = true;
            this.bLayoutLeft = true;
            this.bCanMoved = false;
            this.bAdjMode1 = false;
            this.bVbarRight = true;
            this.bTouched = false;
            this.dstrect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            this.init(true);
        }

        public MyRockeViewA(Context context, Bitmap back, Bitmap cir, boolean btype) {
            super(context);
            this.bFlyType = true;
            this.isbFlyType_recording = false;
            this.bDisText = true;
            this.bPath = false;
            this.nPathSpeed = 1;
            this.Str1 = "THRO";
            this.Str2 = "RUDO";
            this.bDispVbar = true;
            this.bLeft = true;
            this.bLayoutLeft = true;
            this.bCanMoved = false;
            this.bAdjMode1 = false;
            this.bVbarRight = true;
            this.bTouched = false;
            this.dstrect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            this.bFlyType = btype;
            this.init(false);
            this.backBmp = back;
            this.cirBmp = cir;
        }

        public void F_SetImage(Bitmap back) {
            this.backBmp = back;
            this.invalidate();
        }

        public void F_SetImage(Bitmap back, Bitmap cir) {
            this.backBmp = back;
            this.cirBmp = cir;
            this.invalidate();
        }

        public void F_SetFlyRecord(boolean b) {
            this.isbFlyType_recording = b;
            if (this.isbFlyType_recording) {
                this.upBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.up_fly_jh);
                this.downBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.down_fly_jh);
                this.leftBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.left_fly_jh);
                this.rightBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.right_fly_jh);
            } else {
                this.upBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.up_fly_jh);
                this.downBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.down_fly_jh);
                this.leftBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.left_fly_jh);
                this.rightBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.right_fly_jh);
            }
            this.invalidate();
        }

        private void init(boolean ba) {
            this.setWillNotDraw(false);
            this.touchPoint = new Point(-1, -1);
            this.myRipple = new MyRipple(this.getContext());
            this.ripple_params = new RelativeLayout.LayoutParams(76, 76);
            this.addView(this.myRipple, (ViewGroup.LayoutParams)this.ripple_params);
            this.mHandler = new Handler();
            this.myRipple.setVisibility(4);
            if (ba) {
                this.backBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.cir_back_jh);
                this.cirBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.cir_jh);
            }
            if (!this.bFlyType) {
                this.upBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.up_jh);
                this.downBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.down_jh);
                this.leftBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.left_jh);
                this.rightBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.right_jh);
            } else if (this.isbFlyType_recording) {
                this.upBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.up_fly_jh);
                this.downBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.down_fly_jh);
                this.leftBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.left_fly_jh);
                this.rightBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.right_fly_jh);
            } else {
                this.upBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.up_fly_jh);
                this.downBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.down_fly_jh);
                this.leftBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.left_fly_jh);
                this.rightBmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.right_fly_jh);
            }
            this.CirRadius = -1;
            this.cirPoint = new Point(0, 0);
            this.cirPointB = new Point(0, 0);
            this.Radius_VV = 1;
            this.Radius_V1 = 1;
            this.upRect = new RectF();
            this.downRect = new RectF();
            this.leftRect = new RectF();
            this.rightRect = new RectF();
            this.adjy = 128;
            this.adjx = 128;
            if (this.bFlyType) {
                this.PathSpeed1_Bmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.tra1_1_fly);
                this.PathSpeed2_Bmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.tra1_2_fly);
                this.PathSpeed3_Bmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.tra1_3_fly);
            } else {
                this.PathSpeed1_Bmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.tra1_1_jh);
                this.PathSpeed2_Bmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.tra1_2_jh);
                this.PathSpeed3_Bmp = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.mipmap.tra1_3_jh);
            }
            this.CirRadius = -1;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        private void DrawCir(Canvas canvas) {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            if (this.bFlyType) {
                if (JH_App.bFlyDisableAll) {
                    paint.setAlpha(51);
                } else {
                    paint.setAlpha(255);
                }
            }
            if ((this.nType & 0x20) != 0) {
                RectF dstRect = new RectF((float)(this.centx - this.CirRadius), (float)(this.cirPoint.y - this.CirRadius), (float)(this.centx + this.CirRadius), (float)(this.cirPoint.y + this.CirRadius));
                canvas.drawBitmap(this.cirBmp, null, dstRect, paint);
                return;
            }
            if ((this.nType & 0x40) != 0) {
                RectF dstRect = new RectF((float)(this.cirPoint.x - this.CirRadius), (float)(this.centy - this.CirRadius), (float)(this.cirPoint.x + this.CirRadius), (float)(this.centy + this.CirRadius));
                canvas.drawBitmap(this.cirBmp, null, dstRect, paint);
                return;
            }
            if (this.bFlyType) {
                if ((this.nType & 4) != 0 || (this.nType & 8) != 0) {
                    return;
                }
                RectF dstRect = new RectF((float)(this.cirPoint.x - this.CirRadius), (float)(this.cirPoint.y - this.CirRadius), (float)(this.cirPoint.x + this.CirRadius), (float)(this.cirPoint.y + this.CirRadius));
                canvas.drawBitmap(this.cirBmp, null, dstRect, paint);
            } else {
                RectF dstRect = new RectF((float)(this.cirPoint.x - this.CirRadius), (float)(this.cirPoint.y - this.CirRadius), (float)(this.cirPoint.x + this.CirRadius), (float)(this.cirPoint.y + this.CirRadius));
                canvas.drawBitmap(this.cirBmp, null, dstRect, paint);
            }
        }

        private void DrawV_bar(Canvas canvas) {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setStyle(Paint.Style.STROKE);
            if (this.bFlyType) {
                if (JH_App.bFlyDisableAll) {
                    paint.setAlpha(51);
                } else {
                    paint.setAlpha(255);
                }
            }
            int dx20 = Storage.dip2px(this.getContext(), 20.0f);
            int dx20A = Storage.dip2px(this.getContext(), 25.0f);
            int dx5 = Storage.dip2px(this.getContext(), 2.0f);
            int dx14 = Storage.dip2px(this.getContext(), 16.0f);
            int dx2 = Storage.dip2px(this.getContext(), 10.0f);
            int HH = Storage.dip2px(this.getContext(), 10.0f);
            int WW = Storage.dip2px(this.getContext(), 28.0f);
            if (this.bAdjMode1) {
                dx2 = Storage.dip2px(this.getContext(), 10.0f);
                dx20 = Storage.dip2px(this.getContext(), 30.0f);
                int H2 = this.Radius * 2 - dx2 * 2;
                int dh = Storage.dip2px(this.getContext(), 8.0f);
                RectF dstRect = new RectF();
                int dx = Storage.dip2px(this.getContext(), 5.0f);
                int dw = dx20 + (dx *= 2);
                if (this.bVbarRight) {
                    this.upRect.left = this.centx + this.Radius + dx2;
                    this.upRect.top = this.centy - this.Radius + dx2;
                    this.upRect.right = this.upRect.left + (float)dx20;
                    this.upRect.bottom = this.upRect.top + (float)H2;
                    canvas.drawBitmap(this.bar_V_btn_Bmp, null, this.upRect, null);
                    dstRect.set(this.upRect);
                    this.downRect.set(this.upRect);
                    this.upRect.bottom = this.upRect.top + (float)(H2 / 2);
                    this.downRect.top += (float)(H2 / 2);
                    this.adjh = (int)dstRect.height();
                    float step = (float)(this.adjh - dh) / 128.0f;
                    int ch = this.adjh / 2;
                    ch -= dh / 2;
                    if (this.adjy < 128) {
                        int tp = 128 - this.adjy;
                        ch += (int)((float)tp * step);
                    } else if (this.adjy > 128) {
                        int tp = this.adjy - 128;
                        ch -= (int)((float)tp * step);
                    }
                    int cnt = ch;
                    dstRect.left -= (float)dx / 2.0f;
                    dstRect.top = (float)cnt + dstRect.top;
                    dstRect.right = dstRect.left + (float)dw;
                    dstRect.bottom = dstRect.top + (float)dh;
                    canvas.drawBitmap(this.thmbV_Bmp_A, null, dstRect, null);
                } else {
                    this.upRect.left = this.centx - this.Radius - dx2 - dx20;
                    this.upRect.top = this.centy - this.Radius + dx2;
                    this.upRect.right = this.upRect.left + (float)dx20;
                    this.upRect.bottom = this.upRect.top + (float)H2;
                    dstRect.set(this.upRect);
                    canvas.drawBitmap(this.bar_V_btn_Bmp, null, dstRect, null);
                    this.downRect.set(this.upRect);
                    this.upRect.bottom = this.upRect.top + (float)(H2 / 2);
                    this.downRect.top += (float)(H2 / 2);
                    int w = this.adjh = (int)dstRect.height();
                    float step = (float)(this.adjh - dh) / 128.0f;
                    int ch = this.adjh / 2;
                    ch -= dh / 2;
                    if (this.adjy < 128) {
                        int tp = 128 - this.adjy;
                        ch += (int)((float)tp * step);
                    } else if (this.adjy > 128) {
                        int tp = this.adjy - 128;
                        ch -= (int)((float)tp * step);
                    }
                    int cnt = ch;
                    dstRect.left -= (float)dx / 2.0f;
                    dstRect.top = (float)cnt + dstRect.top;
                    dstRect.right = dstRect.left + (float)dw;
                    dstRect.bottom = dstRect.top + (float)dh;
                    canvas.drawBitmap(this.thmbH_Bmp_A, null, dstRect, null);
                }
            } else {
                dx2 = Storage.dip2px(this.getContext(), 14.0f);
                dx20 = Storage.dip2px(this.getContext(), 28.0f);
                dx5 = Storage.dip2px(this.getContext(), 7.0f);
                dx14 = Storage.dip2px(this.getContext(), 14.0f);
                int dxA = Storage.dip2px(this.getContext(), 20.0f);
                if (this.bVbarRight) {
                    int dd2 = Storage.dip2px(this.getContext(), 5.0f);
                    dx2 = Storage.dip2px(this.getContext(), 5.0f);
                    dx20 = Storage.dip2px(this.getContext(), 24.0f);
                    dx5 = Storage.dip2px(this.getContext(), 10.0f);
                    dx20A = Storage.dip2px(this.getContext(), 12.0f);
                    this.upRect.left = this.centx + this.Radius + dxA;
                    this.upRect.top = this.centy - this.Radius + dx5;
                    if (this.bFlyType) {
                        this.upRect.left = this.centx + this.Radius + dd2;
                        this.upRect.top = (float)this.centy - (float)this.Radius * 0.6666667f;
                    }
                    this.upRect.right = this.upRect.left + (float)dx20;
                    this.upRect.bottom = this.upRect.top + (float)dx20A;
                    canvas.drawBitmap(this.upBmp, null, this.upRect, paint);
                    this.downRect.left = this.upRect.left;
                    this.downRect.bottom = this.centy + this.Radius - dx2;
                    if (this.bFlyType) {
                        this.downRect.bottom = (float)this.centy + (float)this.Radius * 0.6666667f;
                    }
                    this.downRect.top = this.downRect.bottom - (float)dx20A;
                    this.downRect.right = this.downRect.left + (float)dx20;
                    canvas.drawBitmap(this.downBmp, null, this.downRect, paint);
                    int cir_r = Storage.dip2px(this.getContext(), 15.0f) * 2;
                    int nsize = Storage.dip2px(this.getContext(), 15.0f);
                    if (!this.bFlyType) {
                        paint.setColor(-16777216);
                        canvas.drawLine(this.upRect.right - (float)(dx20 / 2) + (float)dd2, this.upRect.top - (float)dd2, this.upRect.right + (float)dd2, this.upRect.top - (float)dd2, paint);
                        canvas.drawLine(this.upRect.right + (float)dd2, this.upRect.top - (float)dd2, this.upRect.right + (float)dd2, (float)(this.centy - cir_r / 2), paint);
                        canvas.drawLine(this.downRect.right - (float)(dx20 / 2) + (float)dd2, this.downRect.bottom + (float)dd2, this.downRect.right + (float)dd2, this.downRect.bottom + (float)dd2, paint);
                        canvas.drawLine(this.downRect.right + (float)dd2, this.downRect.bottom + (float)dd2, this.downRect.right + (float)dd2, (float)(this.centy + cir_r / 2), paint);
                        canvas.drawCircle(this.downRect.right + (float)dd2, (float)this.centy, (float)(cir_r / 2), paint);
                        paint.setColor(-16776961);
                    } else if (JH_App.bFlyDisableAll) {
                        paint.setColor(Color.argb((int)51, (int)255, (int)255, (int)255));
                    } else {
                        paint.setColor(-1);
                    }
                    paint.setTextSize((float)nsize);
                    paint.setStyle(Paint.Style.FILL);
                    Paint.FontMetrics fontMetrics = paint.getFontMetrics();
                    float top = fontMetrics.top;
                    float bottom = fontMetrics.bottom;
                    int baseLineY = (int)((float)this.centy - top / 2.0f - bottom / 2.0f);
                    float xxxx = this.downRect.right + (float)dd2;
                    if (this.bFlyType) {
                        xxxx = this.downRect.left + (float)(dx20 / 2);
                    }
                    String s = "";
                    int adj = this.adjy - 128;
                    adj = 0 - adj;
                    s = "" + adj;
                    canvas.rotate(-90.0f, xxxx, (float)this.centy);
                    paint.setTextAlign(Paint.Align.CENTER);
                    canvas.drawText(s, xxxx, (float)baseLineY, paint);
                    canvas.rotate(90.0f, xxxx, (float)this.centy);
                } else {
                    this.upRect.left = this.centx - this.Radius - dx2 - dx20;
                    this.upRect.top = this.centy - this.Radius;
                    this.upRect.right = this.upRect.left + (float)dx20;
                    this.upRect.bottom = this.upRect.top + (float)dx20A;
                    canvas.drawBitmap(this.upBmp, null, this.upRect, null);
                    this.downRect.left = this.centx - this.Radius - dx2 - dx20;
                    this.downRect.bottom = this.centy + this.Radius;
                    this.downRect.right = this.downRect.left + (float)dx20;
                    this.downRect.top = this.downRect.bottom - (float)dx20A;
                    canvas.drawBitmap(this.downBmp, null, this.downRect, null);
                }
            }
        }

        private void DrawH_bar(Canvas canvas) {
            int dx20 = Storage.dip2px(this.getContext(), 20.0f);
            int dx20A = Storage.dip2px(this.getContext(), 25.0f);
            int dx5 = Storage.dip2px(this.getContext(), 2.0f);
            int dx14 = Storage.dip2px(this.getContext(), 14.0f);
            int dx2 = Storage.dip2px(this.getContext(), 5.0f);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-16777216);
            if (this.bFlyType) {
                if (JH_App.bFlyDisableAll) {
                    paint.setAlpha(51);
                } else {
                    paint.setAlpha(255);
                }
            }
            if (this.bPath) {
                dx14 = Storage.dip2px(this.getContext(), 6.0f);
                dx2 = Storage.dip2px(this.getContext(), 38.0f);
                dx20 = Storage.dip2px(this.getContext(), 100.0f);
                int h = Storage.dip2px(this.getContext(), 35.0f);
                RectF dstRect = new RectF();
                dstRect.left = this.centx - this.Radius + dx2;
                dstRect.top = this.centy + this.Radius + dx14;
                dstRect.right = this.centx + this.Radius - dx2;
                dstRect.bottom = dstRect.top + (float)h;
                Bitmap bmp = this.PathSpeed3_Bmp;
                bmp = this.nPathSpeed == 1 ? this.PathSpeed1_Bmp : (this.nPathSpeed == 2 ? this.PathSpeed2_Bmp : this.PathSpeed3_Bmp);
                canvas.drawBitmap(bmp, null, dstRect, null);
                dx2 = Storage.dip2px(this.getContext(), 8.0f);
                dx20 = Storage.dip2px(this.getContext(), 24.0f);
                dx5 = Storage.dip2px(this.getContext(), 10.0f);
                dx20A = Storage.dip2px(this.getContext(), 12.0f);
                int dd2 = Storage.dip2px(this.getContext(), 5.0f);
                this.leftRect.left = this.centx - this.Radius + dx5;
                this.leftRect.top = this.centy + this.Radius + dx2;
                this.leftRect.right = this.leftRect.left + (float)dx20A;
                this.leftRect.bottom = this.leftRect.top + (float)dx20;
                canvas.drawBitmap(this.leftBmp, null, this.leftRect, null);
                this.rightRect.left = this.centx + this.Radius - dx20A - dx5;
                this.rightRect.top = this.centy + this.Radius + dx2;
                this.rightRect.right = this.rightRect.left + (float)dx20A;
                this.rightRect.bottom = this.rightRect.top + (float)dx20;
                canvas.drawBitmap(this.rightBmp, null, this.rightRect, null);
                return;
            }
            if (!this.bAdjMode1) {
                dx2 = Storage.dip2px(this.getContext(), 5.0f);
                dx20 = Storage.dip2px(this.getContext(), 24.0f);
                dx5 = Storage.dip2px(this.getContext(), 10.0f);
                dx20A = Storage.dip2px(this.getContext(), 12.0f);
                int dd2 = Storage.dip2px(this.getContext(), 5.0f);
                int dxA = Storage.dip2px(this.getContext(), 20.0f);
                this.leftRect.left = this.centx - this.Radius + dx5;
                this.leftRect.top = this.centy + this.Radius + dxA;
                if (this.bFlyType) {
                    this.leftRect.top = this.centy + this.Radius + dd2;
                    this.leftRect.left = (float)this.centx - (float)this.Radius * 0.6666667f;
                }
                this.leftRect.right = this.leftRect.left + (float)dx20A;
                this.leftRect.bottom = this.leftRect.top + (float)dx20;
                canvas.drawBitmap(this.leftBmp, null, this.leftRect, paint);
                this.rightRect.left = this.centx + this.Radius - dx20A - dx5;
                this.rightRect.top = this.leftRect.top;
                if (this.bFlyType) {
                    this.rightRect.left = (float)this.centx + (float)this.Radius * 0.6666667f - (float)dx20A;
                }
                this.rightRect.right = this.rightRect.left + (float)dx20A;
                this.rightRect.bottom = this.rightRect.top + (float)dx20;
                canvas.drawBitmap(this.rightBmp, null, this.rightRect, paint);
                int cir_r = Storage.dip2px(this.getContext(), 15.0f) * 2;
                int nsize = Storage.dip2px(this.getContext(), 15.0f);
                if (!this.bFlyType) {
                    canvas.drawLine(this.leftRect.left - (float)dd2, this.leftRect.bottom - (float)(dx20 / 2) + (float)dd2, this.leftRect.left - (float)dd2, this.leftRect.bottom + (float)dd2, paint);
                    canvas.drawLine(this.leftRect.left - (float)dd2, this.leftRect.bottom + (float)dd2, (float)(this.centx - cir_r / 2), this.leftRect.bottom + (float)dd2, paint);
                    canvas.drawLine(this.rightRect.right + (float)dd2, this.rightRect.bottom - (float)(dx20 / 2) + (float)dd2, this.rightRect.right + (float)dd2, this.rightRect.bottom + (float)dd2, paint);
                    canvas.drawLine(this.rightRect.right + (float)dd2, this.rightRect.bottom + (float)dd2, (float)(this.centx + cir_r / 2), this.rightRect.bottom + (float)dd2, paint);
                    paint.setStyle(Paint.Style.STROKE);
                    canvas.drawCircle((float)this.centx, this.rightRect.bottom + (float)(dd2 / 2), (float)(cir_r / 2), paint);
                }
                if (!this.bFlyType) {
                    paint.setColor(-16776961);
                } else if (JH_App.bFlyDisableAll) {
                    paint.setColor(Color.argb((int)51, (int)255, (int)255, (int)255));
                } else {
                    paint.setColor(-1);
                }
                paint.setTextSize((float)nsize);
                paint.setStyle(Paint.Style.FILL);
                Paint.FontMetrics fontMetrics = paint.getFontMetrics();
                float top = fontMetrics.top;
                float bottom = fontMetrics.bottom;
                int baseLineY = (int)(this.rightRect.bottom + (float)dd2 - top / 2.0f - bottom / 2.0f);
                if (this.bFlyType) {
                    baseLineY = (int)(this.rightRect.bottom - (float)(dx20 / 2) - top / 2.0f - bottom / 2.0f);
                }
                String s = "";
                int adj = this.adjx - 128;
                s = "" + adj;
                paint.setTextAlign(Paint.Align.CENTER);
                canvas.drawText(s, (float)this.centx, (float)baseLineY, paint);
            }
        }

        protected void onDraw(Canvas canvas) {
            Paint paint = new Paint();
            if (this.bFlyType) {
                if (JH_App.bFlyDisableAll) {
                    paint.setAlpha(51);
                } else {
                    paint.setAlpha(255);
                }
            }
            paint.setAntiAlias(true);
            int nSize = Storage.dip2px(this.getContext(), 15.0f);
            this.dstrect.left = this.centx - this.Radius;
            this.dstrect.top = this.centy - this.Radius;
            this.dstrect.right = this.centx + this.Radius;
            this.dstrect.bottom = this.centy + this.Radius;
            if (this.bFlyType) {
                if ((this.nType & 4) != 0 || (this.nType & 8) != 0) {
                    if (this.bTouched) {
                        canvas.drawBitmap(this.backBmp, null, this.dstrect, paint);
                    } else if (MyControl.this.bbitbmp != null) {
                        canvas.drawBitmap(MyControl.this.bbitbmp, null, this.dstrect, paint);
                    }
                } else {
                    canvas.drawBitmap(this.backBmp, null, this.dstrect, paint);
                }
            } else {
                canvas.drawBitmap(this.backBmp, null, this.dstrect, paint);
            }
            paint.setColor(-65536);
            paint.setTextSize((float)nSize);
            paint.setStrokeWidth(1.0f);
            paint.setStyle(Paint.Style.FILL);
            paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(this.Str1, (float)this.centx, (float)(this.centy - this.Radius - 8), paint);
            canvas.rotate(-90.0f, (float)(this.centx - this.Radius - 10), (float)this.centy);
            paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(this.Str2, (float)(this.centx - this.Radius - 10), (float)this.centy, paint);
            canvas.rotate(90.0f, (float)(this.centx - this.Radius - 10), (float)this.centy);
            this.DrawCir(canvas);
            this.DrawH_bar(canvas);
            if ((this.nType & 0x10) == 0) {
                this.DrawV_bar(canvas);
            }
        }

        protected void onSizeChanged(int width, int height, int oldw, int oldh) {
            int dsb = Storage.dip2px(this.getContext(), 45.0f);
            dsb = this.bPath ? Storage.dip2px(this.getContext(), 50.0f) : (this.bFlyType ? Storage.dip2px(this.getContext(), 50.0f) : Storage.dip2px(this.getContext(), 45.0f));
            int dsb1 = dsb * 2;
            int size = Math.min(width, height);
            int pitch = Storage.dip2px(this.getContext(), 95.0f);
            this.CirRadius = (int)((double)size * 0.12 / 2.0);
            this.Radius = this.CirRadius * 2 * 4 / 2;
            this.Radius_V1 = this.Radius_VV = this.Radius - this.CirRadius;
            this.Radius_VV *= this.Radius_VV;
            this.ripple_params.width = 200;
            this.ripple_params.height = 200;
            this.myRipple.post(new Runnable(){

                @Override
                public void run() {
                    MyRockeViewA.this.myRipple.setLayoutParams((ViewGroup.LayoutParams)MyRockeViewA.this.ripple_params);
                }
            });
            if (this.bFlyType) {
                this.centy = height / 2;
                this.centx = this.bLeft ? pitch + this.Radius : width - (this.Radius + pitch);
            } else {
                this.centy = height / 2;
                this.centx = this.bLeft ? (int)((double)width * 0.45) : (int)((double)width * 0.55);
            }
            this.cirPoint.x = this.centx;
            this.cirPoint.y = this.centy;
            this.F_ReasetEngine();
        }

        private void UpReleas() {
            this.bCanMoved = false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            int dxp = Storage.dip2px(this.getContext(), 10.0f);
            int action = event.getAction() & 0xFF;
            if (this.bFlyType && JH_App.bFlyDisableAll) {
                if (1 == action) {
                    EventBus.getDefault().post((Object)"abcc", "NeedEnable_123");
                }
                return true;
            }
            int x = (int)event.getX();
            int y = (int)event.getY();
            RectF rect = new RectF();
            RectF rectL = new RectF();
            RectF rectR = new RectF();
            rectL.set(this.leftRect);
            rectL.left -= (float)dxp;
            rectL.top -= (float)dxp;
            rectL.right += (float)dxp;
            rectL.bottom += (float)dxp;
            rectR.set(this.rightRect);
            rectR.left -= (float)dxp;
            rectR.top -= (float)dxp;
            rectR.right += (float)dxp;
            rectR.bottom += (float)dxp;
            if (this.bPath && (rectL.contains((float)x, (float)y) || rectR.contains((float)x, (float)y))) {
                if (1 == action) {
                    if (rectL.contains((float)x, (float)y) && !this.bCanMoved) {
                        --this.nPathSpeed;
                        if (this.nPathSpeed <= 0) {
                            this.nPathSpeed = 1;
                        }
                        this.UpReleas();
                        this.invalidate();
                        Integer speed = this.nPathSpeed;
                        EventBus.getDefault().post((Object)speed, "Send2_path");
                        return true;
                    }
                    if (rectR.contains((float)x, (float)y) && !this.bCanMoved) {
                        ++this.nPathSpeed;
                        if (this.nPathSpeed > 3) {
                            this.nPathSpeed = 3;
                        }
                        this.UpReleas();
                        this.invalidate();
                        Integer speed = this.nPathSpeed;
                        EventBus.getDefault().post((Object)speed, "Send2_path");
                        return true;
                    }
                }
                return true;
            }
            rect.set(this.upRect);
            rect.left -= (float)dxp;
            rect.top -= (float)dxp;
            rect.right += (float)dxp;
            rect.bottom += (float)dxp;
            if (rect.contains((float)x, (float)y) && !this.bCanMoved) {
                if (1 == action) {
                    Integer n = 128;
                    ++this.adjy;
                    if (this.adjy > 160) {
                        this.adjy = 160;
                    }
                    if (this.adjy == 128) {
                        n = 129;
                    }
                    if (MyControl.this.RockeRight == this) {
                        n = n + 256;
                    }
                    EventBus.getDefault().post((Object)n, "PlayBtnMusic");
                    this.UpReleas();
                    this.invalidate();
                }
                return true;
            }
            rect.set(this.downRect);
            rect.left -= (float)dxp;
            rect.top -= (float)dxp;
            rect.right += (float)dxp;
            rect.bottom += (float)dxp;
            if (rect.contains((float)x, (float)y) && !this.bCanMoved) {
                if (1 == action) {
                    Integer n = 112;
                    --this.adjy;
                    if (this.adjy < 96) {
                        this.adjy = 96;
                    }
                    if (this.adjy == 128) {
                        n = 113;
                    }
                    if (MyControl.this.RockeRight == this) {
                        n = n + 256;
                    }
                    EventBus.getDefault().post((Object)n, "PlayBtnMusic");
                    this.UpReleas();
                    this.invalidate();
                }
                return true;
            }
            rect.set(this.leftRect);
            rect.left -= (float)dxp;
            rect.top -= (float)dxp;
            rect.right += (float)dxp;
            rect.bottom += (float)dxp;
            if (rect.contains((float)x, (float)y) && !this.bCanMoved) {
                if (1 == action) {
                    Integer n = 144;
                    --this.adjx;
                    if (this.adjx < 96) {
                        this.adjx = 96;
                    }
                    if (this.adjx == 128) {
                        n = 145;
                    }
                    if (MyControl.this.RockeRight == this) {
                        n = n + 256;
                    }
                    EventBus.getDefault().post((Object)n, "PlayBtnMusic");
                    this.UpReleas();
                    this.invalidate();
                }
                return true;
            }
            rect.set(this.rightRect);
            rect.left -= (float)dxp;
            rect.top -= (float)dxp;
            rect.right += (float)dxp;
            rect.bottom += (float)dxp;
            if (rect.contains((float)x, (float)y) && !this.bCanMoved) {
                if (1 == action) {
                    Integer n = 160;
                    ++this.adjx;
                    if (this.adjx > 160) {
                        this.adjx = 160;
                    }
                    if (this.adjx == 128) {
                        n = 161;
                    }
                    if (MyControl.this.RockeRight == this) {
                        n = n + 256;
                    }
                    EventBus.getDefault().post((Object)n, "PlayBtnMusic");
                    this.UpReleas();
                    this.invalidate();
                }
                return true;
            }
            int dx = x - this.centx;
            int dy = y - this.centy;
            RectF dstRect = new RectF((float)(this.centx - this.Radius_V1), (float)(this.centy - this.Radius_V1), (float)(this.centx + this.Radius_V1), (float)(this.centy + this.Radius_V1));
            int da = dx * dx + dy * dy;
            this.cirPointB.x = this.cirPoint.x;
            this.cirPointB.y = this.cirPoint.y;
            switch (action) {
                case 0: {
                    this.bCanMoved = false;
                    if (dstRect.contains((float)x, (float)y)) {
                        if ((this.nType & 4) == 0 || (this.nType & 8) == 0) {
                            this.bCanMoved = true;
                        }
                        if (da <= this.Radius_VV && this.bFlyType && (this.nType & 4) != 0 && (this.nType & 8) != 0) {
                            this.bTouched = true;
                            this.mHandler.removeCallbacksAndMessages(null);
                            this.myRipple.F_SetPlay(true);
                            if (this.myRipple.getVisibility() != 0) {
                                this.myRipple.resetWave();
                                this.myRipple.setVisibility(0);
                            }
                        }
                    }
                    if (da > this.Radius_VV) {
                        EventBus.getDefault().post((Object)"abc", "MyControlTouched");
                    }
                }
                case 2: {
                    if (!this.bCanMoved && !dstRect.contains((float)x, (float)y)) {
                        return true;
                    }
                    this.bCanMoved = true;
                    if (da <= this.Radius_VV) {
                        if ((this.nType & 4) == 0) {
                            this.cirPoint.x = x;
                        }
                        if ((this.nType & 8) == 0) {
                            this.cirPoint.y = y;
                        }
                        this.touchPoint.x = x;
                        this.touchPoint.y = y;
                    } else {
                        da = (int)Math.sqrt(da);
                        x = dx * this.Radius_V1 / da;
                        y = dy * this.Radius_V1 / da;
                        x += this.centx;
                        y += this.centy;
                        if ((this.nType & 4) == 0) {
                            this.cirPoint.x = x;
                        }
                        if ((this.nType & 8) == 0) {
                            this.cirPoint.y = y;
                        }
                        this.touchPoint.x = x;
                        this.touchPoint.y = y;
                    }
                    if (this.bFlyType && (this.nType & 4) != 0 && (this.nType & 8) != 0) {
                        this.myRipple.post(new Runnable(){

                            @Override
                            public void run() {
                                int left = ((MyRockeViewA)MyRockeViewA.this).touchPoint.x - ((MyRockeViewA)MyRockeViewA.this).ripple_params.width / 2;
                                int top = ((MyRockeViewA)MyRockeViewA.this).touchPoint.y - ((MyRockeViewA)MyRockeViewA.this).ripple_params.height / 2;
                                ((MyRockeViewA)MyRockeViewA.this).ripple_params.leftMargin = left;
                                ((MyRockeViewA)MyRockeViewA.this).ripple_params.topMargin = top;
                                MyRockeViewA.this.myRipple.setLayoutParams((ViewGroup.LayoutParams)MyRockeViewA.this.ripple_params);
                            }
                        });
                    }
                    this.invalidate();
                    return true;
                }
                case 1: {
                    this.bCanMoved = false;
                    this.bTouched = false;
                    if (this.myRipple.getVisibility() == 0) {
                        this.myRipple.F_SetPlay(false);
                        this.mHandler.removeCallbacksAndMessages(null);
                    }
                    if ((this.nType & 1) != 0 & (this.nType & 4) == 0) {
                        this.cirPoint.x = this.centx;
                    }
                    if ((this.nType & 2) != 0 & (this.nType & 8) == 0) {
                        this.cirPoint.y = this.centy;
                    }
                    this.invalidate();
                }
            }
            return true;
        }

        public void F_SetVLR(boolean bRight) {
            this.bVbarRight = bRight;
            this.invalidate();
        }

        public void F_SetX(int x) {
            if (x < 0) {
                x = 0;
            }
            if (x > 255) {
                x = 255;
            }
            x -= 127;
            x *= this.Radius_V1;
            this.cirPoint.x = (x /= 127) + this.centx;
            this.invalidate();
        }

        public int F_GetX() {
            int x = 0;
            Point point = new Point(0, 0);
            point.x = this.cirPoint.x;
            if (this.bFlyType && ((this.nType & 8) != 0 || (this.nType & 8) != 0) && !this.bTouched) {
                return 128;
            }
            int zx = this.centx - this.Radius_V1;
            int xx = point.x - zx;
            float dx = (float)xx / (float)(this.Radius_V1 * 2);
            x = (int)(dx *= 256.0f);
            int ds = (int)(dx * 10.0f);
            if ((ds %= 10) > 5) {
                ++x;
            }
            if (x > 255) {
                x = 255;
            }
            return x;
        }

        public void F_SetY(int y) {
            if (y < 0) {
                y = 0;
            }
            if (y > 255) {
                y = 255;
            }
            y = 255 - y;
            y -= 127;
            y *= this.Radius_V1;
            this.cirPoint.y = (y /= 127) + this.centy;
            this.invalidate();
        }

        public int F_GetY() {
            int y = 0;
            Point point = new Point(0, 0);
            point.y = this.cirPoint.y;
            if (this.bFlyType && ((this.nType & 8) != 0 || (this.nType & 8) != 0) && !this.bTouched) {
                return 128;
            }
            int zy = this.centy + this.Radius_V1;
            int yy = zy - point.y;
            float dy = (float)yy / (float)(this.Radius_V1 * 2);
            y = (int)(dy *= 256.0f);
            int ds = (int)(dy * 10.0f);
            if ((ds %= 10) > 5) {
                ++y;
            }
            if (y > 255) {
                y = 255;
            }
            return y;
        }

        public void F_SetAdjX(int x) {
            this.adjx = x;
            this.invalidate();
        }

        public void F_SetAdjY(int y) {
            this.adjy = y;
            this.invalidate();
        }

        public int F_GetAdjX() {
            int x = this.adjx;
            return x;
        }

        public int F_GetAdjY() {
            int x = this.adjy;
            return x;
        }

        public void F_SetType(int n) {
            this.nType = n;
            if ((this.nType & 1) != 0) {
                this.cirPoint.x = this.centx;
            }
            if ((this.nType & 2) != 0) {
                this.cirPoint.y = this.centy;
            }
        }

        public void F_ReasetEngine() {
            this.cirPoint.y = (this.nType & 2) != 0 ? this.centy : this.centy + this.Radius_V1;
            this.invalidate();
        }

        public void F_ReasetDir() {
            this.cirPoint.x = this.centx;
            this.cirPoint.y = this.centy;
            this.invalidate();
        }

        public void F_AdjReset() {
            this.adjx = 128;
            this.adjy = 128;
            this.invalidate();
        }

        public void F_Calculator_Acceleration(int y, int x, int z) {
            if ((this.nType & 4) == 0 && (this.nType & 8) == 0) {
                return;
            }
            if (this.bFlyType && !this.bTouched) {
                this.cirPoint.x = this.centx;
                this.cirPoint.y = this.centy;
                return;
            }
            x = (int)((double)x * 0.8);
            y = (int)((double)y * 0.8);
            if (x != 0 || y != 0) {
                int da = x * x + y * y;
                if (da <= 64) {
                    x = 0;
                    y = 0;
                } else if (da > this.Radius_VV) {
                    da = (int)Math.sqrt(da);
                    int r = this.Radius_V1;
                    x = x * r / da;
                    y = y * r / da;
                }
                Activity activitya = (Activity)this.getContext();
                JH_App.F_GetOrg(activitya);
                if ((this.nType & 4) != 0) {
                    this.cirPoint.x = JH_App.nOrg == 8 ? this.centx - x : this.centx + x;
                }
                if ((this.nType & 8) != 0) {
                    this.cirPoint.y = JH_App.nOrg == 8 ? this.centy - y : this.centy + y;
                }
                this.invalidate();
            }
        }
    }
}

