/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_fly;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.joyhonest.jh_fly.SwitchMesage;
import com.joyhonest.jh_ui.R;
import com.joyhonest.jh_ui.Storage;
import org.simple.eventbus.EventBus;

public class MySwitch
extends RelativeLayout {
    private Bitmap bmpLeft;
    private Bitmap bmpRight;
    private ImageView img;
    public boolean bMenu = false;
    int firstX = 0;
    int firstY = 0;
    boolean bLeft = true;
    private int nWidth = 0;
    private int nHeght = 0;
    int nOp = 0;

    public MySwitch(Context context) {
        super(context);
        this.F_Init();
    }

    public MySwitch(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.F_Init();
    }

    public MySwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.F_Init();
    }

    public void F_SetMenu(boolean b) {
        this.bMenu = b;
        if (this.bMenu) {
            this.img.setBackgroundResource(R.mipmap.left_menu_icon_fly_jh);
        } else {
            this.img.setBackgroundResource(R.mipmap.photo_icon_a_fly_jh);
        }
    }

    private void F_Init() {
        this.bLeft = true;
        ImageView imgb = new ImageView(this.getContext());
        imgb.setBackgroundResource(R.mipmap.switch_back_1_fly_jh);
        this.addView((View)imgb);
        this.img = new ImageView(this.getContext());
        this.img.setBackgroundResource(R.mipmap.photo_icon_a_fly_jh);
        this.addView((View)this.img);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.nWidth = w;
        this.nHeght = h;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.firstX = (int)event.getX();
        }
        this.nOp = 0;
        if (action == 1) {
            int da = Storage.dip2px(this.getContext(), 8.0f);
            int x = (int)event.getX();
            if (x - this.firstX < -da) {
                if (!this.bLeft) {
                    this.bLeft = true;
                    this.nOp = 1;
                    this.F_DispIcon();
                }
            } else if (x - this.firstX > da) {
                if (this.bLeft) {
                    this.bLeft = false;
                    this.nOp = 2;
                    this.F_DispIcon();
                }
            } else {
                this.bLeft = !this.bLeft;
                this.nOp = this.bLeft ? 1 : 2;
                this.F_DispIcon();
            }
            SwitchMesage msg = new SwitchMesage(this, this.bLeft);
            EventBus.getDefault().post((Object)msg, "SwitchChanged");
        }
        return true;
    }

    private void F_DispIcon() {
        if (this.nOp == 1) {
            if (this.bMenu) {
                this.img.setBackgroundResource(R.mipmap.left_menu_icon_fly_jh);
            } else {
                this.img.setBackgroundResource(R.mipmap.photo_icon_a_fly_jh);
            }
            ObjectAnimator.ofFloat((Object)this.img, (String)"X", (float[])new float[]{this.nWidth - this.nHeght, 0.0f}).setDuration(200L).start();
        }
        if (this.nOp == 2) {
            if (this.bMenu) {
                this.img.setBackgroundResource(R.mipmap.right_menu_icon_fly_jh);
            } else {
                this.img.setBackgroundResource(R.mipmap.record_icon_fly_jh);
            }
            ObjectAnimator.ofFloat((Object)this.img, (String)"X", (float[])new float[]{0.0f, this.nWidth - this.nHeght}).setDuration(200L).start();
        }
    }

    public void F_SetPhoto(boolean b) {
        this.bLeft = b;
        this.F_DispIcon();
    }
}

