/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;

public class MyRipple
extends View {
    private static final int FPS = 12;
    private float mMaxWaveAreaRadius;
    private float mWaveIntervalSize;
    private float mStirStep;
    private float mWaveStartWidth;
    private float mWaveEndWidth;
    private int mWaveColor;
    private Interpolator interpolator = new CycleInterpolator(0.5f);
    private float mViewCenterX;
    private float mViewCenterY;
    private final Paint mWavePaint = new Paint();
    private final Paint mWaveCenterShapePaint;
    private boolean mFillAllView;
    private float mFillWaveSourceShapeRadius;
    private final List<Wave> mWaves;
    private Handler mHandler;
    private Runnable mRunnable;
    private boolean bPlaying;
    private boolean bNeedClear;
    private Wave mLastRmoveWave;

    public MyRipple(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mWavePaint.setAntiAlias(true);
        this.mWavePaint.setStyle(Paint.Style.STROKE);
        this.mWaveCenterShapePaint = new Paint();
        this.mWaveCenterShapePaint.setAntiAlias(true);
        this.mWaveCenterShapePaint.setStyle(Paint.Style.FILL);
        this.mFillAllView = false;
        this.mWaves = new ArrayList<Wave>();
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                MyRipple.this.stir();
                MyRipple.this.invalidate();
                MyRipple.this.mHandler.postDelayed((Runnable)this, 12L);
            }
        };
        this.bPlaying = true;
        this.bNeedClear = false;
        this.init();
    }

    public MyRipple(Context context) {
        super(context);
        this.mWavePaint.setAntiAlias(true);
        this.mWavePaint.setStyle(Paint.Style.STROKE);
        this.mWaveCenterShapePaint = new Paint();
        this.mWaveCenterShapePaint.setAntiAlias(true);
        this.mWaveCenterShapePaint.setStyle(Paint.Style.FILL);
        this.mFillAllView = false;
        this.mWaves = new ArrayList<Wave>();
        this.mRunnable = new /* invalid duplicate definition of identical inner class */;
        this.bPlaying = true;
        this.bNeedClear = false;
        this.init();
    }

    private void init() {
        this.mHandler = new Handler();
        this.setWaveInfo(30.0f, 1.0f, 2.0f, 2.0f, -1);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mViewCenterX = this.getWidth() / 2;
        this.mViewCenterY = this.getHeight() / 2;
        float waveAreaRadius = this.mMaxWaveAreaRadius;
        waveAreaRadius = this.mFillAllView ? (float)Math.sqrt(this.mViewCenterX * this.mViewCenterX + this.mViewCenterY * this.mViewCenterY) : Math.min(this.mViewCenterX, this.mViewCenterY);
        if (this.mMaxWaveAreaRadius != waveAreaRadius) {
            this.mMaxWaveAreaRadius = waveAreaRadius;
            this.resetWave();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Wave w : this.mWaves) {
            this.mWavePaint.setColor(w.color);
            this.mWavePaint.setStrokeWidth(w.width);
            canvas.drawCircle(this.mViewCenterX, this.mViewCenterY, w.radius, this.mWavePaint);
        }
        if (this.mFillWaveSourceShapeRadius > 0.0f) {
            canvas.drawCircle(this.mViewCenterX, this.mViewCenterY, this.mFillWaveSourceShapeRadius, this.mWaveCenterShapePaint);
        }
    }

    public void F_SetPlay(boolean b) {
        this.bPlaying = b;
    }

    private void stir() {
        if (!this.bNeedClear) {
            Wave nearestWave;
            Wave wave = nearestWave = this.mWaves.isEmpty() ? null : this.mWaves.get(0);
            if (nearestWave == null || nearestWave.radius >= this.mWaveIntervalSize) {
                Wave w = null;
                if (this.bPlaying) {
                    if (this.mLastRmoveWave != null) {
                        w = this.mLastRmoveWave;
                        this.mLastRmoveWave = null;
                        w.reset();
                    } else {
                        w = new Wave();
                    }
                    this.mWaves.add(0, w);
                }
            }
            float waveWidthIncrease = this.mWaveEndWidth - this.mWaveStartWidth;
            int size = this.mWaves.size();
            for (int i = 0; i < size; ++i) {
                Wave w = this.mWaves.get(i);
                float rP = w.radius / this.mMaxWaveAreaRadius;
                if (rP > 1.0f) {
                    rP = 1.0f;
                }
                w.width = this.mWaveStartWidth + rP * waveWidthIncrease;
                w.radius += this.mStirStep;
                float factor = this.interpolator.getInterpolation(rP);
                w.color = this.mWaveColor & 0xFFFFFF | (int)(255.0f * factor) << 24;
            }
        }
    }

    public void setFillAllView(boolean fillAllView) {
        this.mFillAllView = fillAllView;
        this.resetWave();
    }

    public void resetWave() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mWaves.clear();
        this.bNeedClear = false;
        this.bPlaying = true;
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.post(this.mRunnable);
    }

    public void setFillWaveSourceShapeRadius(float radius) {
        this.mFillWaveSourceShapeRadius = radius;
    }

    public void setWaveInfo(float intervalSize, float stireStep, float startWidth, float endWidth, int color) {
        this.mWaveIntervalSize = intervalSize;
        this.mStirStep = stireStep;
        this.mWaveStartWidth = startWidth;
        this.mWaveEndWidth = endWidth;
        this.setWaveColor(color);
        this.resetWave();
    }

    public void setWaveColor(int color) {
        this.mWaveColor = color;
        this.mWaveCenterShapePaint.setColor(this.mWaveColor);
    }

    class Wave {
        public float radius;
        public float width;
        public int color;

        public Wave() {
            this.reset();
        }

        public void reset() {
            this.radius = 0.0f;
            this.width = MyRipple.this.mWaveStartWidth;
            this.color = MyRipple.this.mWaveColor;
        }

        public String toString() {
            return "Wave [radius=" + this.radius + ", width=" + this.width + ", color=" + this.color + "]";
        }
    }
}

