/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import java.util.ArrayList;
import java.util.List;
import org.simple.eventbus.EventBus;

public class JH_Tools {
    public static List<Byte> wifiData = new ArrayList<Byte>(100);
    private static List<MyCmdData> array = new ArrayList<MyCmdData>(100);

    public static boolean AdjData(byte[] revdata) {
        if (revdata.length <= 4) {
            return false;
        }
        int idx = revdata[0] + revdata[1] * 1000 + revdata[2] * 100000 + revdata[3] * 10000000;
        MyCmdData data = new MyCmdData(idx, revdata);
        if (array.size() == 0) {
            array.add(0, data);
        } else {
            boolean bInsert = false;
            for (int i = 0; i < array.size(); ++i) {
                MyCmdData data1 = array.get(i);
                if (idx < data1.udpInx) {
                    bInsert = true;
                    array.add(i, data);
                    break;
                }
                if (idx != data1.udpInx) continue;
                bInsert = true;
                break;
            }
            if (!bInsert) {
                array.add(data);
            }
        }
        return true;
    }

    private static boolean Process(byte[] data) {
        boolean bOK = false;
        if (data != null) {
            int ix;
            for (ix = 0; ix < data.length; ++ix) {
                wifiData.add(data[ix]);
            }
            while (wifiData.size() >= 8) {
                if (wifiData.get(0) == 102 && wifiData.get(7) == -103) {
                    byte nChecksum = 0;
                    for (ix = 1; ix < 6; ++ix) {
                        nChecksum = (byte)(nChecksum ^ wifiData.get(ix));
                    }
                    if (nChecksum == wifiData.get(6)) {
                        bOK = true;
                        byte[] revData = new byte[8];
                        for (ix = 0; ix < 8; ++ix) {
                            revData[ix] = wifiData.get(ix);
                        }
                        EventBus.getDefault().post((Object)revData, "GetWifiSendData");
                        for (ix = 0; ix < 8; ++ix) {
                            wifiData.remove(0);
                        }
                        continue;
                    }
                    wifiData.remove(0);
                    continue;
                }
                wifiData.remove(0);
            }
        }
        return bOK;
    }

    public static void FindCmd() {
        int nCount = 0;
        int nPre = 0;
        int idx = 0;
        int nStart = 0;
        for (int i = 0; i < array.size(); ++i) {
            MyCmdData d1 = array.get(i);
            if (i == 0) {
                nCount = d1.data.length;
                nPre = d1.udpInx;
                nStart = i;
                if (nCount < 8) continue;
                byte[] dat = new byte[nCount];
                for (int yy = 0; yy < d1.data.length; ++yy) {
                    dat[yy] = d1.data[yy];
                }
                JH_Tools.Process(dat);
                for (int ix = i; ix >= 0; --ix) {
                    array.remove(ix);
                }
                break;
            }
            idx = d1.udpInx;
            if (idx - nPre == 1) {
                if ((nCount += d1.data.length) >= 8) {
                    int le = 0;
                    byte[] dat = new byte[nCount];
                    for (int xx = nStart; xx <= i; ++xx) {
                        MyCmdData d2 = array.get(xx);
                        for (int yy = 0; yy < d2.data.length; ++yy) {
                            dat[le] = d2.data[yy];
                            ++le;
                        }
                    }
                    JH_Tools.Process(dat);
                    for (int ix = i; ix >= 0; --ix) {
                        array.remove(ix);
                    }
                    break;
                }
            } else {
                nCount = d1.data.length;
                nStart = i;
            }
            nPre = idx;
        }
    }

    public static void F_ClearData() {
        if (array.size() > 50) {
            array.clear();
            wifiData.clear();
        }
    }

    private static class MyCmdData {
        private byte[] data = null;
        private int udpInx;

        public MyCmdData() {
            this.udpInx = -1;
        }

        public MyCmdData(int idx, byte[] dat) {
            if (dat != null && dat.length > 4) {
                this.data = new byte[dat.length - 4];
                for (int ix = 0; ix < dat.length - 4; ++ix) {
                    this.data[ix] = dat[ix + 4];
                }
            }
            this.udpInx = idx;
        }
    }
}

