/*
 * Decompiled with CFR 0.152.
 */
package com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_basic_profile.usecase;

import android.util.Log;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.abstracts.UseCase;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_access_token.models.LinkedInAccessTokenInfo;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_basic_profile.models.LinkedInBasicProfileInfo;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_basic_profile.models.error.RetrieveBasicProfileInfoError;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.utils.RequestHandler;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_basic_profile/usecase/RetrieveBasicProfileInfoUseCase;", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/abstracts/UseCase;", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_access_token/models/LinkedInAccessTokenInfo;", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_basic_profile/models/LinkedInBasicProfileInfo;", "requestHandler", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/utils/RequestHandler;", "(Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/utils/RequestHandler;)V", "TAG", "", "retrieveBasicProfile", "accessTokenInfo", "email", "retrieveEmailFromAPI", "run", "input", "linkedinsdk_release"})
public final class RetrieveBasicProfileInfoUseCase
extends UseCase<LinkedInAccessTokenInfo, LinkedInBasicProfileInfo> {
    private final String TAG = "RetrieveBasicProfileInf";
    private final RequestHandler requestHandler;

    @Override
    @NotNull
    public LinkedInBasicProfileInfo run(@Nullable LinkedInAccessTokenInfo input) {
        if (input == null) {
            throw (Throwable)new RetrieveBasicProfileInfoError.NullInput("Input can't be null for RetrieveBasicProfileInfo");
        }
        try {
            String email = this.retrieveEmailFromAPI(input);
            LinkedInBasicProfileInfo profileInfo2 = this.retrieveBasicProfile(input, email);
            return profileInfo2;
        }
        catch (Exception e) {
            String string = e.getLocalizedMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.localizedMessage");
            throw (Throwable)new RetrieveBasicProfileInfoError.FailedToRetrieveBasicProfileInfo(string);
        }
    }

    private final String retrieveEmailFromAPI(LinkedInAccessTokenInfo accessTokenInfo2) throws IOException, JSONException {
        String emailUrl = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
        String result = RequestHandler.sendGet(emailUrl, accessTokenInfo2.getAccessToken());
        if (result != null) {
            String email;
            JSONObject jsonObject = new JSONObject(result);
            String string = email = jsonObject.getJSONArray("elements").getJSONObject(0).getJSONObject("handle~").getString("emailAddress");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"email");
            return string;
        }
        Log.e((String)this.TAG, (String)"Failed To Retrieve Email from LinkedIn API");
        throw (Throwable)new RetrieveBasicProfileInfoError.FailedToRetrieveBasicProfileInfo("Failed To Retrieve Basic Profile");
    }

    private final LinkedInBasicProfileInfo retrieveBasicProfile(LinkedInAccessTokenInfo accessTokenInfo2, String email) throws IOException, JSONException {
        String profileEndpoint = "https://api.linkedin.com/v2/me?projection=(id,firstName,lastName,profilePicture(displayImage~:playableStreams))";
        String result = RequestHandler.sendGet(profileEndpoint, accessTokenInfo2.getAccessToken());
        if (result != null) {
            String string;
            JSONObject jsonObject = new JSONObject(result);
            String linkedInUserId = jsonObject.getString("id");
            String country = jsonObject.getJSONObject("firstName").getJSONObject("preferredLocale").getString("country");
            String language = jsonObject.getJSONObject("firstName").getJSONObject("preferredLocale").getString("language");
            String firstNameKey = language + "_" + country;
            String linkedInUserFirstName = jsonObject.getJSONObject("firstName").getJSONObject("localized").getString(firstNameKey);
            String linkedInUserLastName = jsonObject.getJSONObject("lastName").getJSONObject("localized").getString(firstNameKey);
            try {
                string = jsonObject.getJSONObject("profilePicture").getJSONObject("displayImage~").getJSONArray("elements").getJSONObject(0).getJSONArray("identifiers").getJSONObject(0).getString("identifier");
            }
            catch (Exception e) {
                string = null;
            }
            String linkedInUserProfile = string;
            String string2 = linkedInUserId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"linkedInUserId");
            String string3 = linkedInUserFirstName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"linkedInUserFirstName");
            String string4 = linkedInUserLastName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"linkedInUserLastName");
            return new LinkedInBasicProfileInfo(string2, email, string3, string4, linkedInUserProfile, accessTokenInfo2.getAccessToken(), accessTokenInfo2.getAccessTokenExpiry());
        }
        Log.e((String)this.TAG, (String)"Failed To Retrieve Basic Profile");
        throw (Throwable)new RetrieveBasicProfileInfoError.FailedToRetrieveBasicProfileInfo("Failed To Retrieve Basic Profile");
    }

    public RetrieveBasicProfileInfoUseCase(@NotNull RequestHandler requestHandler) {
        Intrinsics.checkParameterIsNotNull((Object)requestHandler, (String)"requestHandler");
        this.requestHandler = requestHandler;
        this.TAG = "RetrieveBasicProfileInf";
    }
}

