/*
 * Decompiled with CFR 0.152.
 */
package com.AbdAllahAbdElFattah13.linkedinsdk.ui.linkedin_builder;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.AbdAllahAbdElFattah13.linkedinsdk.ui.LinkedInAuthenticationActivity;
import java.util.Random;

public abstract class LinkedInBuilder {
    private Intent intent;
    private String state;
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET_KEY = "client_secret";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String STATE = "state";
    public static final String TAG = "LinkedInAuth";
    public static final int ERROR_USER_DENIED = 11;
    public static final int ERROR_FAILED = 12;

    abstract LinkedInBuilder self();

    abstract void startActivityForResult(Intent var1, int var2);

    LinkedInBuilder(Context context) {
        this.intent = new Intent(context, LinkedInAuthenticationActivity.class);
    }

    public LinkedInBuilder setClientID(String clientID) {
        this.updateIntent(CLIENT_ID, clientID);
        return this.self();
    }

    public LinkedInBuilder setClientSecret(String clientSecret) {
        this.updateIntent(CLIENT_SECRET_KEY, clientSecret);
        return this.self();
    }

    public LinkedInBuilder setRedirectURI(String redirectURI) {
        this.updateIntent(REDIRECT_URI, redirectURI);
        return this.self();
    }

    public LinkedInBuilder setState(String state) {
        this.state = state;
        this.updateIntent(STATE, state);
        return this.self();
    }

    public void authenticate(int requestCode) {
        if (this.validateAuthenticationParams()) {
            if (this.state == null) {
                this.generateState();
            }
            this.startActivityForResult(this.intent, requestCode);
        }
    }

    private void updateIntent(String key, String value) {
        this.intent.putExtra(key, value);
    }

    private boolean validateAuthenticationParams() {
        if (this.intent.getStringExtra(CLIENT_ID) == null) {
            Log.e((String)TAG, (String)"Client ID is required", (Throwable)new IllegalArgumentException());
            return false;
        }
        if (this.intent.getStringExtra(CLIENT_SECRET_KEY) == null) {
            Log.e((String)TAG, (String)"Client Secret is required", (Throwable)new IllegalArgumentException());
            return false;
        }
        if (this.intent.getStringExtra(REDIRECT_URI) == null) {
            Log.e((String)TAG, (String)"Redirect URI is required", (Throwable)new IllegalArgumentException());
            return false;
        }
        return true;
    }

    private void generateState() {
        String ALLOWED_CHARACTERS = "0123456789qwertyuiopasdfghjklzxcvbnmMNBVCXZLKJHGFDSAQWERTYUIOP";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < 16; ++i) {
            sb.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
        }
        this.state = sb.toString();
        this.intent.putExtra(STATE, this.state);
    }
}

