/*
 * Decompiled with CFR 0.152.
 */
package com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_access_token.usecases;

import com.AbdAllahAbdElFattah13.linkedinsdk.domain.abstracts.UseCase;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_access_token.models.LinkedInAccessTokenInfo;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.usecases.retrieve_access_token.models.errors.RetrieveAccessTokenError;
import com.AbdAllahAbdElFattah13.linkedinsdk.domain.utils.RequestHandler;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_access_token/usecases/RetrieveAccessTokenUseCase;", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/abstracts/UseCase;", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_access_token/usecases/RetrieveAccessTokenUseCase$RetrieveAccessTokenInputs;", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_access_token/models/LinkedInAccessTokenInfo;", "requestHandler", "Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/utils/RequestHandler;", "(Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/utils/RequestHandler;)V", "getAccessTokenEndpoint", "", "inputs", "run", "input", "RetrieveAccessTokenInputs", "linkedinsdk_release"})
public final class RetrieveAccessTokenUseCase
extends UseCase<RetrieveAccessTokenInputs, LinkedInAccessTokenInfo> {
    private final RequestHandler requestHandler;

    private final String getAccessTokenEndpoint(RetrieveAccessTokenInputs inputs) {
        return "https://www.linkedin.com/uas/oauth2/accessToken?grant_type=authorization_code&code=" + inputs.getAuthorizationToken() + "&" + "client_id" + "=" + inputs.getClientId() + "&" + "redirect_uri" + "=" + inputs.getRedirectUri() + "&" + "client_secret" + "=" + inputs.getClientSecretKey();
    }

    @Override
    @NotNull
    public LinkedInAccessTokenInfo run(@Nullable RetrieveAccessTokenInputs input) throws RetrieveAccessTokenError {
        if (input == null) {
            throw (Throwable)new RetrieveAccessTokenError.NullInput("RetrieveAccessTokenUseCase inputs can't be null!");
        }
        String accessTokenEndpoint = this.getAccessTokenEndpoint(input);
        String resultString = RequestHandler.sendPost(accessTokenEndpoint, new JSONObject());
        if (resultString != null) {
            String accessToken;
            JSONObject resultJson = new JSONObject(resultString);
            int expiresIn = resultJson.has("expires_in") ? resultJson.getInt("expires_in") : 0;
            String string = accessToken = resultJson.has("access_token") ? resultJson.getString("access_token") : null;
            if (expiresIn > 0 && accessToken != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(13, expiresIn);
                Calendar calendar2 = calendar;
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
                long expireDate = calendar2.getTimeInMillis();
                LinkedInAccessTokenInfo linkedInAccessTokenInfo = new LinkedInAccessTokenInfo(accessToken, expireDate);
                return linkedInAccessTokenInfo;
            }
            throw (Throwable)new RetrieveAccessTokenError.AccessTokenRequestFailed("API call returned null access token!");
        }
        throw (Throwable)new RetrieveAccessTokenError.AccessTokenRequestFailed("Access token API failed!");
    }

    public RetrieveAccessTokenUseCase(@NotNull RequestHandler requestHandler) {
        Intrinsics.checkParameterIsNotNull((Object)requestHandler, (String)"requestHandler");
        this.requestHandler = requestHandler;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/AbdAllahAbdElFattah13/linkedinsdk/domain/usecases/retrieve_access_token/usecases/RetrieveAccessTokenUseCase$RetrieveAccessTokenInputs;", "", "authorizationToken", "", "clientId", "redirectUri", "clientSecretKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthorizationToken", "()Ljava/lang/String;", "getClientId", "getClientSecretKey", "getRedirectUri", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "linkedinsdk_release"})
    public static final class RetrieveAccessTokenInputs {
        @NotNull
        private final String authorizationToken;
        @NotNull
        private final String clientId;
        @NotNull
        private final String redirectUri;
        @NotNull
        private final String clientSecretKey;

        @NotNull
        public final String getAuthorizationToken() {
            return this.authorizationToken;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getRedirectUri() {
            return this.redirectUri;
        }

        @NotNull
        public final String getClientSecretKey() {
            return this.clientSecretKey;
        }

        public RetrieveAccessTokenInputs(@NotNull String authorizationToken, @NotNull String clientId, @NotNull String redirectUri, @NotNull String clientSecretKey) {
            Intrinsics.checkParameterIsNotNull((Object)authorizationToken, (String)"authorizationToken");
            Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
            Intrinsics.checkParameterIsNotNull((Object)redirectUri, (String)"redirectUri");
            Intrinsics.checkParameterIsNotNull((Object)clientSecretKey, (String)"clientSecretKey");
            this.authorizationToken = authorizationToken;
            this.clientId = clientId;
            this.redirectUri = redirectUri;
            this.clientSecretKey = clientSecretKey;
        }

        @NotNull
        public final String component1() {
            return this.authorizationToken;
        }

        @NotNull
        public final String component2() {
            return this.clientId;
        }

        @NotNull
        public final String component3() {
            return this.redirectUri;
        }

        @NotNull
        public final String component4() {
            return this.clientSecretKey;
        }

        @NotNull
        public final RetrieveAccessTokenInputs copy(@NotNull String authorizationToken, @NotNull String clientId, @NotNull String redirectUri, @NotNull String clientSecretKey) {
            Intrinsics.checkParameterIsNotNull((Object)authorizationToken, (String)"authorizationToken");
            Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
            Intrinsics.checkParameterIsNotNull((Object)redirectUri, (String)"redirectUri");
            Intrinsics.checkParameterIsNotNull((Object)clientSecretKey, (String)"clientSecretKey");
            return new RetrieveAccessTokenInputs(authorizationToken, clientId, redirectUri, clientSecretKey);
        }

        public static /* synthetic */ RetrieveAccessTokenInputs copy$default(RetrieveAccessTokenInputs retrieveAccessTokenInputs, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = retrieveAccessTokenInputs.authorizationToken;
            }
            if ((n & 2) != 0) {
                string2 = retrieveAccessTokenInputs.clientId;
            }
            if ((n & 4) != 0) {
                string3 = retrieveAccessTokenInputs.redirectUri;
            }
            if ((n & 8) != 0) {
                string4 = retrieveAccessTokenInputs.clientSecretKey;
            }
            return retrieveAccessTokenInputs.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "RetrieveAccessTokenInputs(authorizationToken=" + this.authorizationToken + ", clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ", clientSecretKey=" + this.clientSecretKey + ")";
        }

        public int hashCode() {
            String string = this.authorizationToken;
            String string2 = this.clientId;
            String string3 = this.redirectUri;
            String string4 = this.clientSecretKey;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RetrieveAccessTokenInputs)) break block3;
                    RetrieveAccessTokenInputs retrieveAccessTokenInputs = (RetrieveAccessTokenInputs)object;
                    if (!Intrinsics.areEqual((Object)this.authorizationToken, (Object)retrieveAccessTokenInputs.authorizationToken) || !Intrinsics.areEqual((Object)this.clientId, (Object)retrieveAccessTokenInputs.clientId) || !Intrinsics.areEqual((Object)this.redirectUri, (Object)retrieveAccessTokenInputs.redirectUri) || !Intrinsics.areEqual((Object)this.clientSecretKey, (Object)retrieveAccessTokenInputs.clientSecretKey)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

