/*
 * Decompiled with CFR 0.152.
 */
package com.AbdAllahAbdElFattah13.linkedinsdk.helpers;

import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestHandler {
    private static final String TAG = "LinkedInAuth";

    public static String sendPost(String r_url, JSONObject postDataParams) throws IOException, JSONException {
        URL url = new URL(r_url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream os = conn.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        writer.write(RequestHandler.encodeParams(postDataParams));
        writer.flush();
        writer.close();
        os.close();
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line = "";
            line = in.readLine();
            if (line != null) {
                sb.append(line);
            }
            in.close();
            return sb.toString();
        }
        BufferedReader err = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        String line = "";
        line = err.readLine();
        if (line != null) {
            sb.append(line);
        }
        err.close();
        Log.e((String)TAG, (String)("Error Code " + conn.getResponseCode()));
        Log.e((String)TAG, (String)("Error Message " + sb.toString()));
        return null;
    }

    public static String sendGet(String url, String accessToken) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Authorization", "Bearer " + accessToken);
        con.setRequestProperty("cache-control", "no-cache");
        con.setRequestProperty("X-Restli-Protocol-Version", "2.0.0");
        int responseCode = con.getResponseCode();
        System.out.println("Response Code :: " + responseCode);
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        BufferedReader err = new BufferedReader(new InputStreamReader(con.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        String line = "";
        line = err.readLine();
        if (line != null) {
            sb.append(line);
        }
        err.close();
        Log.e((String)TAG, (String)("Error Code " + con.getResponseCode()));
        Log.e((String)TAG, (String)("Error Message " + sb.toString()));
        return null;
    }

    private static String encodeParams(JSONObject params) throws UnsupportedEncodingException, JSONException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        Iterator itr = params.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = params.get(key);
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        return result.toString();
    }
}

