/*
 * Decompiled with CFR 0.152.
 */
package com.AbdAllahAbdElFattah13.linkedinsdk;

import android.os.AsyncTask;
import android.util.Log;
import com.AbdAllahAbdElFattah13.linkedinsdk.helpers.LinkedInUser;
import com.AbdAllahAbdElFattah13.linkedinsdk.helpers.OnBasicProfileListener;
import com.AbdAllahAbdElFattah13.linkedinsdk.helpers.RequestHandler;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class RetrieveBasicProfileAsyncTask
extends AsyncTask<String, Void, Boolean> {
    private static final String TAG = "LinkedInAuth";
    private OnBasicProfileListener basicProfileListener;
    private LinkedInUser linkedInUser = new LinkedInUser();

    public RetrieveBasicProfileAsyncTask(String accessToken, long accessTokenExpiry, OnBasicProfileListener basicProfileListener) {
        this.basicProfileListener = basicProfileListener;
        this.linkedInUser.setAccessToken(accessToken);
        this.linkedInUser.setAccessTokenExpiry(accessTokenExpiry);
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.basicProfileListener.onDataRetrievalStart();
    }

    protected Boolean doInBackground(String ... tokens) {
        if (this.linkedInUser.getAccessToken() != null) {
            try {
                this.retrieveBasicProfile();
                this.retrieveEmailFromAPI();
                return this.linkedInUser.getId() != null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    protected void onPostExecute(Boolean didSuccess) {
        super.onPostExecute((Object)didSuccess);
        if (didSuccess.booleanValue()) {
            this.basicProfileListener.onDataSuccess(this.linkedInUser);
        } else {
            this.basicProfileListener.onDataFailed(12, "AUTHORIZATION FAILED");
        }
    }

    private void retrieveBasicProfile() throws IOException, JSONException {
        String profileUrl = "https://api.linkedin.com/v2/me?projection=(id,firstName,lastName,profilePicture(displayImage~:playableStreams))";
        String result = RequestHandler.sendGet(profileUrl, this.linkedInUser.getAccessToken());
        if (result != null) {
            JSONObject jsonObject = new JSONObject(result);
            String linkedInUserId = jsonObject.getString("id");
            String country = jsonObject.getJSONObject("firstName").getJSONObject("preferredLocale").getString("country");
            String language = jsonObject.getJSONObject("firstName").getJSONObject("preferredLocale").getString("language");
            String firstNameKey = language + "_" + country;
            String linkedInUserFirstName = jsonObject.getJSONObject("firstName").getJSONObject("localized").getString(firstNameKey);
            String linkedInUserLastName = jsonObject.getJSONObject("lastName").getJSONObject("localized").getString(firstNameKey);
            String linkedInUserProfile = jsonObject.getJSONObject("profilePicture").getJSONObject("displayImage~").getJSONArray("elements").getJSONObject(0).getJSONArray("identifiers").getJSONObject(0).getString("identifier");
            this.linkedInUser.setId(linkedInUserId);
            this.linkedInUser.setFirstName(linkedInUserFirstName);
            this.linkedInUser.setLastName(linkedInUserLastName);
            this.linkedInUser.setProfileUrl(linkedInUserProfile);
        } else {
            Log.e((String)TAG, (String)"Failed To Retrieve Basic Profile");
        }
    }

    private void retrieveEmailFromAPI() throws IOException, JSONException {
        String emailUrl = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
        String result = RequestHandler.sendGet(emailUrl, this.linkedInUser.getAccessToken());
        if (result != null) {
            JSONObject jsonObject = new JSONObject(result);
            String email = jsonObject.getJSONArray("elements").getJSONObject(0).getJSONObject("handle~").getString("emailAddress");
            this.linkedInUser.setEmail(email);
        } else {
            Log.e((String)TAG, (String)"Failed To Retrieve Email from LinkedIn API");
        }
    }
}

