/*
 * Decompiled with CFR 0.152.
 */
package com.AbdAllahAbdElFattah13.linkedinsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.AbdAllahAbdElFattah13.linkedinsdk.R;
import com.AbdAllahAbdElFattah13.linkedinsdk.helpers.LinkedInUser;
import com.AbdAllahAbdElFattah13.linkedinsdk.helpers.OnBasicProfileListener;
import com.AbdAllahAbdElFattah13.linkedinsdk.helpers.RequestHandler;
import com.AbdAllahAbdElFattah13.linkedinsdk.linkedin_builder.LinkedInFromActivityBuilder;
import java.io.IOException;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class LinkedInAuthenticationActivity
extends AppCompatActivity {
    private static String CLIENT_ID;
    private static String CLIENT_SECRET_KEY;
    private static String STATE;
    private static String REDIRECT_URI;
    private static final String AUTHORIZATION_URL = "https://www.linkedin.com/uas/oauth2/authorization";
    private static final String ACCESS_TOKEN_URL = "https://www.linkedin.com/uas/oauth2/accessToken";
    private static final String SECRET_KEY_PARAM = "client_secret";
    private static final String RESPONSE_TYPE_PARAM = "response_type";
    private static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String GRANT_TYPE = "authorization_code";
    private static final String RESPONSE_TYPE_VALUE = "code";
    private static final String CLIENT_ID_PARAM = "client_id";
    private static final String STATE_PARAM = "state";
    private static final String REDIRECT_URI_PARAM = "redirect_uri";
    private static final String QUESTION_MARK = "?";
    private static final String AMPERSAND = "&";
    private static final String EQUALS = "=";
    private WebView webView;
    private AlertDialog progressDialog;
    private LinkedInUser linkedInUser = new LinkedInUser();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.linkedin_activity_linkedin_authentication);
        this.getWindow().setFlags(1024, 1024);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().hide();
        }
        CLIENT_ID = this.getIntent().getStringExtra(CLIENT_ID_PARAM);
        CLIENT_SECRET_KEY = this.getIntent().getStringExtra(SECRET_KEY_PARAM);
        REDIRECT_URI = this.getIntent().getStringExtra(REDIRECT_URI_PARAM);
        STATE = this.getIntent().getStringExtra(STATE_PARAM);
        this.webView = (WebView)this.findViewById(R.id.web_view_linkedin_login);
        this.webView.requestFocus(130);
        this.webView.clearHistory();
        this.webView.clearCache(true);
        this.showProgressDialog();
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                LinkedInAuthenticationActivity.this.hideProgressDialog();
            }

            public boolean shouldOverrideUrlLoading(WebView view, String authorizationUrl) {
                LinkedInAuthenticationActivity.this.showProgressDialog();
                if (authorizationUrl.startsWith(REDIRECT_URI)) {
                    Uri uri = Uri.parse((String)authorizationUrl);
                    String stateToken = uri.getQueryParameter(LinkedInAuthenticationActivity.STATE_PARAM);
                    if (stateToken == null || !stateToken.equals(STATE)) {
                        Log.e((String)"LinkedInAuth", (String)"State token doesn't match");
                        return true;
                    }
                    String authorizationToken = uri.getQueryParameter(LinkedInAuthenticationActivity.RESPONSE_TYPE_VALUE);
                    if (authorizationToken == null) {
                        Intent intent = new Intent();
                        intent.putExtra("err_code", 11);
                        intent.putExtra("err_message", "Authorization not received. User didn't allow access to account.");
                        LinkedInAuthenticationActivity.this.setResult(0, intent);
                        LinkedInAuthenticationActivity.this.finish();
                    }
                    new RetrieveDataAsyncTask().execute(new String[]{authorizationToken});
                } else {
                    LinkedInAuthenticationActivity.this.webView.loadUrl(authorizationUrl);
                }
                return true;
            }
        });
        String authUrl = LinkedInAuthenticationActivity.getAuthorizationUrl();
        this.webView.loadUrl(authUrl);
    }

    private void retrieveAccessTokenFromAPI(String authorizationToken) throws IOException, JSONException {
        String accessTokenUrl = LinkedInAuthenticationActivity.getAccessTokenUrl(authorizationToken);
        String result = RequestHandler.sendPost(accessTokenUrl, new JSONObject());
        if (result != null) {
            String accessToken1;
            JSONObject resultJson = new JSONObject(result);
            int expiresIn = resultJson.has("expires_in") ? resultJson.getInt("expires_in") : 0;
            String string = accessToken1 = resultJson.has("access_token") ? resultJson.getString("access_token") : null;
            if (expiresIn > 0 && accessToken1 != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(13, expiresIn);
                long expireDate = calendar.getTimeInMillis();
                this.linkedInUser.setAccessToken(accessToken1);
                this.linkedInUser.setAccessTokenExpiry(expireDate);
            } else {
                Log.e((String)"LinkedInAuth", (String)"Access Token Expired or Doesn't exist");
            }
        } else {
            Log.e((String)"LinkedInAuth", (String)"Failed To Retrieve Access Token");
        }
    }

    private static String getAccessTokenUrl(String authorizationToken) {
        return "https://www.linkedin.com/uas/oauth2/accessToken?grant_type=authorization_code&code=" + authorizationToken + AMPERSAND + CLIENT_ID_PARAM + EQUALS + CLIENT_ID + AMPERSAND + REDIRECT_URI_PARAM + EQUALS + REDIRECT_URI + AMPERSAND + SECRET_KEY_PARAM + EQUALS + CLIENT_SECRET_KEY;
    }

    private static String getAuthorizationUrl() {
        return "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=" + CLIENT_ID + AMPERSAND + STATE_PARAM + EQUALS + STATE + AMPERSAND + REDIRECT_URI_PARAM + EQUALS + REDIRECT_URI + AMPERSAND + "scope=r_liteprofile%20r_emailaddress";
    }

    private void showProgressDialog() {
        if (!this.isFinishing()) {
            if (this.progressDialog == null) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setCancelable(false);
                builder.setView(R.layout.linkedin_layout_progress_dialog);
                this.progressDialog = builder.create();
            }
            this.progressDialog.show();
        }
    }

    private void hideProgressDialog() {
        if (!this.isFinishing() && this.progressDialog != null) {
            this.progressDialog.dismiss();
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private class RetrieveDataAsyncTask
    extends AsyncTask<String, Void, Boolean> {
        private RetrieveDataAsyncTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            LinkedInAuthenticationActivity.this.showProgressDialog();
        }

        protected Boolean doInBackground(String ... tokens) {
            if (tokens.length > 0) {
                String authorizationToken = tokens[0];
                try {
                    LinkedInAuthenticationActivity.this.retrieveAccessTokenFromAPI(authorizationToken);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }

        protected void onPostExecute(Boolean didSuccess) {
            super.onPostExecute((Object)didSuccess);
            if (LinkedInAuthenticationActivity.this.linkedInUser.getAccessToken() != null) {
                LinkedInFromActivityBuilder.retrieveBasicProfile(LinkedInAuthenticationActivity.this.linkedInUser.getAccessToken(), LinkedInAuthenticationActivity.this.linkedInUser.getAccessTokenExpiry(), new OnBasicProfileListener(){

                    @Override
                    public void onDataRetrievalStart() {
                    }

                    @Override
                    public void onDataSuccess(LinkedInUser linkedInUser) {
                        LinkedInAuthenticationActivity.this.hideProgressDialog();
                        Intent intent = new Intent();
                        intent.putExtra("social_login", (Parcelable)linkedInUser);
                        LinkedInAuthenticationActivity.this.setResult(-1, intent);
                        LinkedInAuthenticationActivity.this.finish();
                    }

                    @Override
                    public void onDataFailed(int errCode, String errMessage) {
                        LinkedInAuthenticationActivity.this.hideProgressDialog();
                        Intent intent = new Intent();
                        intent.putExtra("err_code", errCode);
                        intent.putExtra("err_message", errMessage);
                        LinkedInAuthenticationActivity.this.setResult(0, intent);
                        LinkedInAuthenticationActivity.this.finish();
                    }
                });
            } else {
                LinkedInAuthenticationActivity.this.hideProgressDialog();
                Intent intent = new Intent();
                intent.putExtra("err_code", 12);
                intent.putExtra("err_message", "AUTHORIZATION FAILED");
                LinkedInAuthenticationActivity.this.setResult(0, intent);
                LinkedInAuthenticationActivity.this.finish();
            }
        }
    }
}

