/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.ftinc.canvasscript.params.CanvasParams;

public class SaveLayerParams
implements CanvasParams {
    private final RectF bounds;
    private final int saveFlags;
    private final int alpha;
    @Nullable
    private final Paint paint;

    public SaveLayerParams(@Nullable RectF bounds, @Nullable Paint paint, int saveFlags) {
        this.bounds = bounds;
        this.paint = paint;
        this.saveFlags = saveFlags;
        this.alpha = -1;
    }

    public SaveLayerParams(@Nullable RectF bounds, @Nullable Paint paint) {
        this(bounds, paint, 31);
    }

    public SaveLayerParams(float left, float top, float right, float bottom, @Nullable Paint paint, int saveFlags) {
        this(new RectF(left, top, right, bottom), paint, saveFlags);
    }

    public SaveLayerParams(float left, float top, float right, float bottom, @Nullable Paint paint) {
        this(left, top, right, bottom, paint, 31);
    }

    public SaveLayerParams(@Nullable RectF bounds, int alpha, int saveFlags) {
        this.bounds = bounds;
        this.alpha = alpha;
        this.saveFlags = saveFlags;
        this.paint = null;
    }

    public SaveLayerParams(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        this(new RectF(left, top, right, bottom), alpha, saveFlags);
    }

    @Override
    public int draw(Canvas canvas) {
        if (this.alpha == -1) {
            return canvas.saveLayer(this.bounds, this.paint, this.saveFlags);
        }
        return canvas.saveLayerAlpha(this.bounds, this.alpha, this.saveFlags);
    }
}

