/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ftinc.canvasscript.params.CanvasParams;

public class RectParams
implements CanvasParams {
    private final float left;
    private final float right;
    private final float top;
    private final float bottom;
    @Nullable
    private final Rect rect;
    @Nullable
    private final RectF rectF;
    private final Paint paint;

    public RectParams(float left, float top, float right, float bottom, @NonNull Paint paint) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.paint = paint;
        this.rect = null;
        this.rectF = null;
    }

    public RectParams(@NonNull Rect rect, @NonNull Paint paint) {
        this.rect = rect;
        this.paint = paint;
        this.rectF = null;
        this.left = 0.0f;
        this.top = 0.0f;
        this.right = 0.0f;
        this.bottom = 0.0f;
    }

    public RectParams(@NonNull RectF rect, @NonNull Paint paint) {
        this.rectF = rect;
        this.paint = paint;
        this.rect = null;
        this.left = 0.0f;
        this.top = 0.0f;
        this.right = 0.0f;
        this.bottom = 0.0f;
    }

    @Override
    public int draw(Canvas canvas) {
        if (this.rect != null) {
            canvas.drawRect(this.rect, this.paint);
        } else if (this.rectF != null) {
            canvas.drawRect(this.rectF, this.paint);
        } else {
            canvas.drawRect(this.left, this.top, this.right, this.bottom, this.paint);
        }
        return -1;
    }
}

