/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.ftinc.canvasscript.params.CanvasParams;

public class PointParams
implements CanvasParams {
    private final float[] pts;
    private final int offset;
    private final int count;
    private final Paint paint;

    public PointParams(float x, float y, @NonNull Paint paint) {
        this(new float[]{x, y}, paint);
    }

    public PointParams(@Size(multiple=2L) @NonNull float[] pts, @NonNull Paint paint) {
        this(pts, 0, pts.length, paint);
    }

    public PointParams(@Size(multiple=2L) @NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        this.pts = pts;
        this.offset = offset;
        this.count = count;
        this.paint = paint;
    }

    @Override
    public int draw(Canvas canvas) {
        if (this.count == 2) {
            canvas.drawPoint(this.pts[0], this.pts[1], this.paint);
        } else {
            canvas.drawPoints(this.pts, this.offset, this.count, this.paint);
        }
        return -1;
    }
}

