/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.ftinc.canvasscript.params.CanvasParams;

public class LineParams
implements CanvasParams {
    public static final int SIZE = 4;
    private final float[] pts;
    private final int offset;
    private final int count;
    private final Paint paint;

    public LineParams(float startX, float startY, float endX, float endY, @NonNull Paint paint) {
        this.paint = paint;
        this.pts = new float[]{startX, startY, endX, endY};
        this.offset = 0;
        this.count = 4;
    }

    public LineParams(@Size(multiple=4L) @NonNull float[] pts, @NonNull Paint paint) {
        this(pts, 0, pts.length, paint);
    }

    public LineParams(@Size(multiple=4L) @NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        this.pts = pts;
        this.offset = offset;
        this.count = count;
        this.paint = paint;
    }

    @Override
    public int draw(Canvas canvas) {
        if (this.pts.length == 4) {
            canvas.drawLine(this.pts[0], this.pts[1], this.pts[2], this.pts[3], this.paint);
        } else {
            canvas.drawLines(this.pts, this.offset, this.count, this.paint);
        }
        return -1;
    }
}

