/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.LocaleList;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.ftinc.canvasscript.params.ArcParams;
import com.ftinc.canvasscript.params.BitmapParams;
import com.ftinc.canvasscript.params.CanvasParams;
import com.ftinc.canvasscript.params.CircleParams;
import com.ftinc.canvasscript.params.ColorParams;
import com.ftinc.canvasscript.params.ConcatParams;
import com.ftinc.canvasscript.params.LineParams;
import com.ftinc.canvasscript.params.OvalParams;
import com.ftinc.canvasscript.params.PaintParams;
import com.ftinc.canvasscript.params.PathParams;
import com.ftinc.canvasscript.params.PictureParams;
import com.ftinc.canvasscript.params.PointParams;
import com.ftinc.canvasscript.params.RectParams;
import com.ftinc.canvasscript.params.RestoreParams;
import com.ftinc.canvasscript.params.RotateParams;
import com.ftinc.canvasscript.params.RoundRectParams;
import com.ftinc.canvasscript.params.SaveLayerParams;
import com.ftinc.canvasscript.params.SaveParams;
import com.ftinc.canvasscript.params.ScaleParams;
import com.ftinc.canvasscript.params.SkewParams;
import com.ftinc.canvasscript.params.TranslateParams;
import com.ftinc.canvasscript.util.Log;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;

public final class CanvasScript {
    private static final String TAG = "CanvasScript";
    private static final int DEFAULT_PAINT_FLAGS = 1;
    private static final int DEFAULT_QUEUE_SIZE = 10;
    private static final int MAX_ALPHA = 255;
    @NonNull
    private final Canvas rootCanvas;
    @Nullable
    private final Bitmap bitmap;
    @Nullable
    private Paint currentPaint;
    private final Deque<CanvasParams> parameters;
    private int currentSaveCount = -1;

    private CanvasScript(@NonNull Canvas canvas) {
        this.parameters = new ArrayDeque<CanvasParams>(10);
        this.rootCanvas = canvas;
        this.bitmap = null;
    }

    private CanvasScript(@NonNull Bitmap bitmap) {
        this.bitmap = bitmap;
        this.parameters = new ArrayDeque<CanvasParams>(10);
        this.rootCanvas = new Canvas(this.bitmap);
    }

    public static CanvasScript create(int width, int height) {
        return CanvasScript.create(width, height, Bitmap.Config.ARGB_8888);
    }

    public static CanvasScript create(int width, int height, @NonNull Bitmap.Config config) {
        return new CanvasScript(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config));
    }

    public static CanvasScript create(@NonNull Bitmap bitmap) {
        if (!bitmap.isMutable() || bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap must be mutable and unrecycled");
        }
        return new CanvasScript(bitmap);
    }

    public static CanvasScript wrap(Canvas canvas) {
        return new CanvasScript(canvas);
    }

    public CanvasScript paint(@Nullable Paint paint) {
        this.currentPaint = paint;
        return this;
    }

    public CanvasScript color(@ColorInt int color) {
        this.createPaintIfNull();
        this.currentPaint.setColor(color);
        return this;
    }

    public CanvasScript colorFilter(@Nullable ColorFilter filter) {
        this.createPaintIfNull();
        this.currentPaint.setColorFilter(filter);
        return this;
    }

    public CanvasScript argb(int a, int r, int g, int b) {
        this.createPaintIfNull();
        this.currentPaint.setARGB(a, r, g, b);
        return this;
    }

    public CanvasScript alpha(@IntRange(from=0L, to=255L) int alpha) {
        this.createPaintIfNull();
        this.currentPaint.setAlpha(alpha);
        return this;
    }

    public CanvasScript alpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        this.createPaintIfNull();
        this.currentPaint.setAlpha((int)(255.0f * alpha));
        return this;
    }

    public CanvasScript flags(int flags) {
        this.createPaintIfNull();
        this.currentPaint.setFlags(flags);
        return this;
    }

    public CanvasScript addFlags(int flags) {
        this.createPaintIfNull();
        this.currentPaint.setFlags(this.currentPaint.getFlags() | flags);
        return this;
    }

    public CanvasScript style(Paint.Style style) {
        this.createPaintIfNull();
        this.currentPaint.setStyle(style);
        return this;
    }

    public CanvasScript strokeWidth(float width) {
        this.createPaintIfNull();
        this.currentPaint.setStrokeWidth(width);
        return this;
    }

    public CanvasScript strokeMiter(float miter) {
        this.createPaintIfNull();
        this.currentPaint.setStrokeMiter(miter);
        return this;
    }

    public CanvasScript strokeCap(Paint.Cap cap) {
        this.createPaintIfNull();
        this.currentPaint.setStrokeCap(cap);
        return this;
    }

    public CanvasScript strokeJoin(Paint.Join join) {
        this.createPaintIfNull();
        this.currentPaint.setStrokeJoin(join);
        return this;
    }

    public CanvasScript shader(Shader shader) {
        this.createPaintIfNull();
        this.currentPaint.setShader(shader);
        return this;
    }

    public CanvasScript xfermode(Xfermode xfermode) {
        this.createPaintIfNull();
        this.currentPaint.setXfermode(xfermode);
        return this;
    }

    public CanvasScript porterDuffXfer(PorterDuff.Mode mode) {
        this.createPaintIfNull();
        this.currentPaint.setXfermode((Xfermode)new PorterDuffXfermode(mode));
        return this;
    }

    public CanvasScript pathEffect(PathEffect pathEffect) {
        this.createPaintIfNull();
        this.currentPaint.setPathEffect(pathEffect);
        return this;
    }

    public CanvasScript maskFilter(MaskFilter maskFilter) {
        this.createPaintIfNull();
        this.currentPaint.setMaskFilter(maskFilter);
        return this;
    }

    public CanvasScript typeface(Typeface typeface) {
        this.createPaintIfNull();
        this.currentPaint.setTypeface(typeface);
        return this;
    }

    public CanvasScript shadow(float radius, float dx, float dy, @ColorInt int shadowColor) {
        this.createPaintIfNull();
        this.currentPaint.setShadowLayer(radius, dx, dy, shadowColor);
        return this;
    }

    public CanvasScript clearShadow() {
        if (this.currentPaint != null) {
            this.currentPaint.clearShadowLayer();
        }
        return this;
    }

    public CanvasScript textAlign(Paint.Align align) {
        this.createPaintIfNull();
        this.currentPaint.setTextAlign(align);
        return this;
    }

    @TargetApi(value=17)
    public CanvasScript textLocale(@NonNull Locale locale) {
        this.createPaintIfNull();
        this.currentPaint.setTextLocale(locale);
        return this;
    }

    @TargetApi(value=24)
    public CanvasScript textLocales(@NonNull @Size(min=1L) LocaleList locales) {
        this.createPaintIfNull();
        this.currentPaint.setTextLocales(locales);
        return this;
    }

    public CanvasScript textSize(float textSize) {
        this.createPaintIfNull();
        this.currentPaint.setTextSize(textSize);
        return this;
    }

    public CanvasScript textScaleX(float scaleX) {
        this.createPaintIfNull();
        this.currentPaint.setTextScaleX(scaleX);
        return this;
    }

    public CanvasScript textSkewX(float skewX) {
        this.createPaintIfNull();
        this.currentPaint.setTextSkewX(skewX);
        return this;
    }

    @TargetApi(value=21)
    public CanvasScript letterSpacing(float letterSpacing) {
        this.createPaintIfNull();
        this.currentPaint.setLetterSpacing(letterSpacing);
        return this;
    }

    @TargetApi(value=21)
    public CanvasScript fontFeatureSettings(String settings) {
        this.createPaintIfNull();
        this.currentPaint.setFontFeatureSettings(settings);
        return this;
    }

    public CanvasScript custom(@NonNull CanvasParams customParameter) {
        this.parameters.add(customParameter);
        return this;
    }

    public CanvasScript script(CanvasScript script) {
        this.parameters.addAll(script.parameters);
        return this;
    }

    public CanvasScript script(float dx, float dy, CanvasScript script) {
        this.parameters.add(new SaveParams());
        this.parameters.add(new TranslateParams(dx, dy));
        this.parameters.addAll(script.parameters);
        this.parameters.add(new RestoreParams());
        return this;
    }

    public CanvasScript circle(float cx, float cy, float radius) {
        this.checkNonNullPaint();
        this.parameters.add(new CircleParams(cx, cy, radius, this.getPaintCopy()));
        return this;
    }

    public CanvasScript circle(float cx, float cy, float radius, @NonNull Paint paint) {
        this.parameters.add(new CircleParams(cx, cy, radius, paint));
        return this;
    }

    public CanvasScript line(float sx, float sy, float ex, float ey) {
        this.checkNonNullPaint();
        this.parameters.add(new LineParams(sx, sy, ex, ey, this.getPaintCopy()));
        return this;
    }

    public CanvasScript lines(@Size(multiple=4L) @NonNull float[] pts) {
        this.checkNonNullPaint();
        this.parameters.add(new LineParams(pts, this.getPaintCopy()));
        return this;
    }

    public CanvasScript lines(@Size(multiple=4L) @NonNull float[] pts, @NonNull Paint paint) {
        this.parameters.add(new LineParams(pts, paint));
        return this;
    }

    public CanvasScript lines(@Size(multiple=4L) @NonNull float[] pts, int offset, int count) {
        this.checkNonNullPaint();
        this.parameters.add(new LineParams(pts, offset, count, this.getPaintCopy()));
        return this;
    }

    public CanvasScript lines(@Size(multiple=4L) @NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        this.parameters.add(new LineParams(pts, offset, count, paint));
        return this;
    }

    public CanvasScript oval(float left, float top, float right, float bottom) {
        this.checkNonNullPaint();
        this.parameters.add(new OvalParams(left, right, top, bottom, this.getPaintCopy()));
        return this;
    }

    public CanvasScript oval(float left, float top, float right, float bottom, @NonNull Paint paint) {
        this.parameters.add(new OvalParams(left, right, top, bottom, paint));
        return this;
    }

    public CanvasScript oval(@NonNull RectF bounds) {
        this.checkNonNullPaint();
        this.parameters.add(new OvalParams(bounds, this.getPaintCopy()));
        return this;
    }

    public CanvasScript oval(@NonNull RectF bounds, @NonNull Paint paint) {
        this.parameters.add(new OvalParams(bounds, paint));
        return this;
    }

    public CanvasScript rect(float left, float top, float right, float bottom) {
        this.checkNonNullPaint();
        this.parameters.add(new RectParams(left, top, right, bottom, this.getPaintCopy()));
        return this;
    }

    public CanvasScript rect(@NonNull Rect rect) {
        this.checkNonNullPaint();
        this.parameters.add(new RectParams(rect, this.getPaintCopy()));
        return this;
    }

    public CanvasScript rect(@NonNull RectF rect) {
        this.checkNonNullPaint();
        this.parameters.add(new RectParams(rect, this.getPaintCopy()));
        return this;
    }

    public CanvasScript rect(float left, float top, float right, float bottom, @NonNull Paint paint) {
        this.parameters.add(new RectParams(left, top, right, bottom, paint));
        return this;
    }

    public CanvasScript rect(@NonNull Rect rect, @NonNull Paint paint) {
        this.parameters.add(new RectParams(rect, paint));
        return this;
    }

    public CanvasScript rect(@NonNull RectF rect, @NonNull Paint paint) {
        this.parameters.add(new RectParams(rect, paint));
        return this;
    }

    public CanvasScript roundedRect(float left, float top, float right, float bottom, float rx, float ry, @NonNull Paint paint) {
        this.parameters.add(new RoundRectParams(left, top, right, bottom, rx, ry, paint));
        return this;
    }

    public CanvasScript roundedRect(float left, float top, float right, float bottom, float radius, @NonNull Paint paint) {
        this.parameters.add(new RoundRectParams(left, top, right, bottom, radius, paint));
        return this;
    }

    public CanvasScript roundedRect(@NonNull RectF bounds, float rx, float ry, @NonNull Paint paint) {
        this.parameters.add(new RoundRectParams(bounds, rx, ry, paint));
        return this;
    }

    public CanvasScript roundedRect(@NonNull RectF bounds, float radius, @NonNull Paint paint) {
        this.parameters.add(new RoundRectParams(bounds, radius, paint));
        return this;
    }

    public CanvasScript roundedRect(float left, float top, float right, float bottom, float rx, float ry) {
        this.checkNonNullPaint();
        this.parameters.add(new RoundRectParams(left, top, right, bottom, rx, ry, this.getPaintCopy()));
        return this;
    }

    public CanvasScript roundedRect(float left, float top, float right, float bottom, float radius) {
        this.checkNonNullPaint();
        this.parameters.add(new RoundRectParams(left, top, right, bottom, radius, this.getPaintCopy()));
        return this;
    }

    public CanvasScript roundedRect(@NonNull RectF bounds, float rx, float ry) {
        this.checkNonNullPaint();
        this.parameters.add(new RoundRectParams(bounds, rx, ry, this.getPaintCopy()));
        return this;
    }

    public CanvasScript roundedRect(@NonNull RectF bounds, float radius) {
        this.checkNonNullPaint();
        this.parameters.add(new RoundRectParams(bounds, radius, this.getPaintCopy()));
        return this;
    }

    public CanvasScript arc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, @NonNull Paint paint) {
        this.parameters.add(new ArcParams(left, top, right, bottom, startAngle, sweepAngle, useCenter, paint));
        return this;
    }

    public CanvasScript arc(@NonNull RectF bounds, float startAngle, float sweepAngle, boolean useCenter, @NonNull Paint paint) {
        this.parameters.add(new ArcParams(bounds, startAngle, sweepAngle, useCenter, paint));
        return this;
    }

    public CanvasScript arc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter) {
        this.checkNonNullPaint();
        this.parameters.add(new ArcParams(left, top, right, bottom, startAngle, sweepAngle, useCenter, this.getPaintCopy()));
        return this;
    }

    public CanvasScript arc(@NonNull RectF bounds, float startAngle, float sweepAngle, boolean useCenter) {
        this.checkNonNullPaint();
        this.parameters.add(new ArcParams(bounds, startAngle, sweepAngle, useCenter, this.getPaintCopy()));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap) {
        this.parameters.add(new BitmapParams(bitmap, 0.0f, 0.0f, this.currentPaint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @Nullable Paint paint) {
        this.parameters.add(new BitmapParams(bitmap, 0.0f, 0.0f, paint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, int width, int height) {
        this.parameters.add(new BitmapParams(bitmap, null, new Rect(0, 0, width, height), this.currentPaint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, int width, int height, @Nullable Paint paint) {
        this.parameters.add(new BitmapParams(bitmap, null, new Rect(0, 0, width, height), paint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, float left, float top, @Nullable Paint paint) {
        this.parameters.add(new BitmapParams(bitmap, left, top, paint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull Rect dst, @Nullable Paint paint) {
        this.parameters.add(new BitmapParams(bitmap, src, dst, paint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull RectF dst, @Nullable Paint paint) {
        this.parameters.add(new BitmapParams(bitmap, src, dst, paint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @NonNull Matrix matrix, @Nullable Paint paint) {
        this.parameters.add(new BitmapParams(bitmap, matrix, paint));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, float left, float top) {
        this.parameters.add(new BitmapParams(bitmap, left, top, this.getPaintCopy()));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull Rect dst) {
        this.parameters.add(new BitmapParams(bitmap, src, dst, this.getPaintCopy()));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull RectF dst) {
        this.parameters.add(new BitmapParams(bitmap, src, dst, this.getPaintCopy()));
        return this;
    }

    public CanvasScript bitmap(@NonNull Bitmap bitmap, @NonNull Matrix matrix) {
        this.parameters.add(new BitmapParams(bitmap, matrix, this.getPaintCopy()));
        return this;
    }

    public CanvasScript point(float x, float y, @NonNull Paint paint) {
        this.parameters.add(new PointParams(x, y, paint));
        return this;
    }

    public CanvasScript points(@Size(multiple=2L) @NonNull float[] pts, @NonNull Paint paint) {
        this.parameters.add(new PointParams(pts, paint));
        return this;
    }

    public CanvasScript points(@Size(multiple=2L) @NonNull float[] pts, int offset, int count, @NonNull Paint paint) {
        this.parameters.add(new PointParams(pts, offset, count, paint));
        return this;
    }

    public CanvasScript point(float x, float y) {
        this.checkNonNullPaint();
        this.parameters.add(new PointParams(x, y, this.getPaintCopy()));
        return this;
    }

    public CanvasScript points(@Size(multiple=2L) @NonNull float[] pts) {
        this.checkNonNullPaint();
        this.parameters.add(new PointParams(pts, this.getPaintCopy()));
        return this;
    }

    public CanvasScript points(@Size(multiple=2L) @NonNull float[] pts, int offset, int count) {
        this.checkNonNullPaint();
        this.parameters.add(new PointParams(pts, offset, count, this.getPaintCopy()));
        return this;
    }

    public CanvasScript path(@NonNull Path path, @NonNull Paint paint) {
        this.parameters.add(new PathParams(path, paint));
        return this;
    }

    public CanvasScript path(@NonNull Path path) {
        this.checkNonNullPaint();
        this.parameters.add(new PathParams(path, this.getPaintCopy()));
        return this;
    }

    public CanvasScript picture(@NonNull Picture picture) {
        this.parameters.add(new PictureParams(picture));
        return this;
    }

    public CanvasScript picture(@NonNull Picture picture, @NonNull Rect dst) {
        this.parameters.add(new PictureParams(picture, dst));
        return this;
    }

    public CanvasScript picture(@NonNull Picture picture, @NonNull RectF dst) {
        this.parameters.add(new PictureParams(picture, dst));
        return this;
    }

    public CanvasScript drawColor(@ColorInt int color) {
        this.parameters.add(new ColorParams(color));
        return this;
    }

    public CanvasScript drawColor(@ColorInt int color, PorterDuff.Mode mode) {
        this.parameters.add(new ColorParams(color, mode));
        return this;
    }

    public CanvasScript drawPaint(@NonNull Paint paint) {
        this.parameters.add(new PaintParams(paint));
        return this;
    }

    public CanvasScript save() {
        this.parameters.add(new SaveParams());
        return this;
    }

    public CanvasScript save(int saveFlags) {
        this.parameters.add(new SaveParams(saveFlags));
        return this;
    }

    public CanvasScript saveLayer() {
        this.parameters.add(new SaveLayerParams(null, null));
        return this;
    }

    public CanvasScript saveLayer(float left, float top, float right, float bottom, @Nullable Paint paint) {
        this.parameters.add(new SaveLayerParams(left, top, right, bottom, paint));
        return this;
    }

    public CanvasScript saveLayer(@Nullable RectF bounds, @Nullable Paint paint) {
        this.parameters.add(new SaveLayerParams(bounds, paint));
        return this;
    }

    public CanvasScript saveLayer(float left, float top, float right, float bottom, @Nullable Paint paint, int saveFlags) {
        this.parameters.add(new SaveLayerParams(left, top, right, bottom, paint, saveFlags));
        return this;
    }

    public CanvasScript saveLayer(@Nullable RectF bounds, @Nullable Paint paint, int saveFlags) {
        this.parameters.add(new SaveLayerParams(bounds, paint, saveFlags));
        return this;
    }

    public CanvasScript saveLayer(float left, float top, float right, float bottom, @IntRange(from=0L, to=255L) int alpha, int saveFlags) {
        this.parameters.add(new SaveLayerParams(left, top, right, bottom, alpha, saveFlags));
        return this;
    }

    public CanvasScript saveLayer(RectF bounds, @IntRange(from=0L, to=255L) int alpha, int saveFlags) {
        this.parameters.add(new SaveLayerParams(bounds, alpha, saveFlags));
        return this;
    }

    public CanvasScript restore() {
        this.parameters.add(new RestoreParams());
        return this;
    }

    public CanvasScript restore(int saveCount) {
        this.parameters.add(new RestoreParams(saveCount));
        return this;
    }

    public CanvasScript translate(float dx, float dy) {
        this.parameters.add(new TranslateParams(dx, dy));
        return this;
    }

    public CanvasScript rotate(float degrees) {
        this.parameters.add(new RotateParams(degrees));
        return this;
    }

    public CanvasScript rotate(float degrees, float px, float py) {
        this.parameters.add(new RotateParams(degrees, px, py));
        return this;
    }

    public CanvasScript skew(float sx, float sy) {
        this.parameters.add(new SkewParams(sx, sy));
        return this;
    }

    public CanvasScript scale(float sx, float sy) {
        this.parameters.add(new ScaleParams(sx, sy));
        return this;
    }

    public CanvasScript scale(float sx, float sy, float px, float py) {
        this.parameters.add(new ScaleParams(sx, sy, px, py));
        return this;
    }

    public CanvasScript concat(@Nullable Matrix matrix) {
        this.parameters.add(new ConcatParams(matrix));
        return this;
    }

    @Nullable
    public Bitmap draw() {
        for (CanvasParams parameter : this.parameters) {
            if (parameter instanceof RestoreParams && this.currentSaveCount != -1) {
                ((RestoreParams)parameter).setCount(this.currentSaveCount);
            }
            Log.d(TAG, "Rendering Script (%s): saveCount(%d)", parameter, this.currentSaveCount);
            int saveCount = parameter.draw(this.rootCanvas);
            if (saveCount == -1) continue;
            this.currentSaveCount = saveCount;
        }
        return this.bitmap;
    }

    @Nullable
    private Paint getPaintCopy() {
        if (this.currentPaint != null) {
            return new Paint(this.currentPaint);
        }
        return null;
    }

    private void checkNonNullPaint() {
        if (this.currentPaint == null) {
            throw new IllegalStateException("The current Paint state cannot be null, be sure to configure the scripts painting preference");
        }
    }

    private void createPaintIfNull() {
        if (this.currentPaint == null) {
            this.currentPaint = new Paint(1);
        }
    }

    static {
        Log.setEnabled(false);
    }
}

