/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.ftinc.canvasscript.params.CanvasParams;

public class RoundRectParams
implements CanvasParams {
    private final RectF bounds;
    private final float rx;
    private final float ry;
    private final Paint paint;

    public RoundRectParams(float left, float top, float right, float bottom, float rx, float ry, @NonNull Paint paint) {
        this.bounds = new RectF(left, top, right, bottom);
        this.rx = rx;
        this.ry = ry;
        this.paint = paint;
    }

    public RoundRectParams(@NonNull RectF bounds, float rx, float ry, @NonNull Paint paint) {
        this.bounds = bounds;
        this.rx = rx;
        this.ry = ry;
        this.paint = paint;
    }

    public RoundRectParams(float left, float top, float right, float bottom, float radius, @NonNull Paint paint) {
        this.bounds = new RectF(left, top, right, bottom);
        this.rx = radius;
        this.ry = radius;
        this.paint = paint;
    }

    public RoundRectParams(@NonNull RectF bounds, float radius, @NonNull Paint paint) {
        this.bounds = bounds;
        this.rx = radius;
        this.ry = radius;
        this.paint = paint;
    }

    @Override
    public int draw(Canvas canvas) {
        canvas.drawRoundRect(this.bounds, this.rx, this.ry, this.paint);
        return -1;
    }
}

