/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript;

import android.annotation.TargetApi;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.LocaleList;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import java.util.Locale;

public final class PaintScript {
    private final Paint paint;

    private PaintScript(int flags) {
        this.paint = new Paint(flags);
    }

    private PaintScript(Paint paint) {
        this.paint = new Paint(paint);
    }

    public static PaintScript create() {
        return new PaintScript(1);
    }

    public static PaintScript create(int flags) {
        return new PaintScript(flags);
    }

    public static PaintScript create(Paint paint) {
        return new PaintScript(paint);
    }

    public PaintScript color(@ColorInt int color) {
        this.paint.setColor(color);
        return this;
    }

    public PaintScript colorFilter(@Nullable ColorFilter filter) {
        this.paint.setColorFilter(filter);
        return this;
    }

    public PaintScript argb(int a, int r, int g, int b) {
        this.paint.setARGB(a, r, g, b);
        return this;
    }

    public PaintScript alpha(@IntRange(from=0L, to=255L) int alpha) {
        this.paint.setAlpha(alpha);
        return this;
    }

    public PaintScript alpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        this.paint.setAlpha((int)(255.0f * alpha));
        return this;
    }

    public PaintScript flags(int flags) {
        this.paint.setFlags(flags);
        return this;
    }

    public PaintScript addFlags(int flags) {
        this.paint.setFlags(this.paint.getFlags() | flags);
        return this;
    }

    public PaintScript style(Paint.Style style) {
        this.paint.setStyle(style);
        return this;
    }

    public PaintScript strokeWidth(float width) {
        this.paint.setStrokeWidth(width);
        return this;
    }

    public PaintScript strokeMiter(float miter) {
        this.paint.setStrokeMiter(miter);
        return this;
    }

    public PaintScript strokeCap(Paint.Cap cap) {
        this.paint.setStrokeCap(cap);
        return this;
    }

    public PaintScript strokeJoin(Paint.Join join) {
        this.paint.setStrokeJoin(join);
        return this;
    }

    public PaintScript shader(Shader shader) {
        this.paint.setShader(shader);
        return this;
    }

    public PaintScript xfermode(Xfermode xfermode) {
        this.paint.setXfermode(xfermode);
        return this;
    }

    public PaintScript porterDuffXfer(PorterDuff.Mode mode) {
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(mode));
        return this;
    }

    public PaintScript pathEffect(PathEffect pathEffect) {
        this.paint.setPathEffect(pathEffect);
        return this;
    }

    public PaintScript maskFilter(MaskFilter maskFilter) {
        this.paint.setMaskFilter(maskFilter);
        return this;
    }

    public PaintScript typeface(Typeface typeface) {
        this.paint.setTypeface(typeface);
        return this;
    }

    public PaintScript shadow(float radius, float dx, float dy, @ColorInt int shadowColor) {
        this.paint.setShadowLayer(radius, dx, dy, shadowColor);
        return this;
    }

    public PaintScript clearShadow() {
        this.paint.clearShadowLayer();
        return this;
    }

    public PaintScript textAlign(Paint.Align align) {
        this.paint.setTextAlign(align);
        return this;
    }

    @TargetApi(value=17)
    public PaintScript textLocale(@NonNull Locale locale) {
        this.paint.setTextLocale(locale);
        return this;
    }

    @TargetApi(value=24)
    public PaintScript textLocales(@NonNull @Size(min=1L) LocaleList locales) {
        this.paint.setTextLocales(locales);
        return this;
    }

    public PaintScript textSize(float textSize) {
        this.paint.setTextSize(textSize);
        return this;
    }

    public PaintScript textScaleX(float scaleX) {
        this.paint.setTextScaleX(scaleX);
        return this;
    }

    public PaintScript textSkewX(float skewX) {
        this.paint.setTextSkewX(skewX);
        return this;
    }

    @TargetApi(value=21)
    public PaintScript letterSpacing(float letterSpacing) {
        this.paint.setLetterSpacing(letterSpacing);
        return this;
    }

    @TargetApi(value=21)
    public PaintScript fontFeatureSettings(String settings) {
        this.paint.setFontFeatureSettings(settings);
        return this;
    }

    public Paint build() {
        return this.paint;
    }
}

