/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import fiftyone.pipeline.web.mvc.components.FiftyOneInterceptor;
import fiftyone.pipeline.web.mvc.configuration.FiftyOneInterceptorConfig;
import fiftyone.pipeline.web.mvc.configuration.FiftyOneInterceptorConfigDefault;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@EnableWebMvc
@Configuration
@ComponentScan(value={"controller", "fiftyone.pipeline.web.mvc"})
public class ExampleConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    ServletContext servletContext;
    @Autowired
    FiftyOneInterceptor fiftyOneInterceptor;

    public void addViewControllers(ViewControllerRegistry registry) {
        FiftyOneInterceptor.enableClientsideProperties((ViewControllerRegistry)registry);
    }

    @Bean
    public FiftyOneInterceptorConfig fiftyOneInterceptorConfig() {
        FiftyOneInterceptorConfigDefault bean = new FiftyOneInterceptorConfigDefault();
        bean.setDataFilePath(this.servletContext.getRealPath("/WEB-INF/51Degrees.xml"));
        bean.setClientsidePropertiesEnabled(true);
        return bean;
    }

    @Bean
    public ViewResolver viewResolver() {
        InternalResourceViewResolver bean = new InternalResourceViewResolver();
        bean.setViewClass(JstlView.class);
        bean.setPrefix("/WEB-INF/views/");
        bean.setSuffix(".jsp");
        return bean;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.fiftyOneInterceptor);
    }
}

