/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.search;

import fiftyone.mobile.detection.search.SearchResult;
import java.io.IOException;

public abstract class SearchBase<T, K, L> {
    public int binarySearch(L list, K key) throws IOException {
        return this.binarySearch(list, key, 0, this.getCount(list) - 1);
    }

    public int binarySearch(L list, K key, int lower, int upper) throws IOException {
        while (lower <= upper) {
            int index = lower + (upper - lower) / 2;
            int comparisonResult = this.compareTo(this.getValue(list, index), key);
            if (comparisonResult == 0) {
                return index;
            }
            if (comparisonResult > 0) {
                upper = index - 1;
                continue;
            }
            lower = index + 1;
        }
        return ~lower;
    }

    public SearchResult binarySearchResults(L list, K key) throws IOException {
        SearchResult results = new SearchResult();
        int lower = 0;
        int upper = this.getCount(list) - 1;
        while (lower <= upper) {
            ++results.Iterations;
            results.Index = lower + (upper - lower) / 2;
            int comparisonResult = this.compareTo(this.getValue(list, results.Index), key);
            if (comparisonResult == 0) {
                return results;
            }
            if (comparisonResult > 0) {
                upper = results.Index - 1;
                continue;
            }
            lower = results.Index + 1;
        }
        results.Index = ~lower;
        return results;
    }

    protected abstract int getCount(L var1);

    protected abstract T getValue(L var1, int var2) throws IOException;

    protected abstract int compareTo(T var1, K var2) throws IOException;
}

