/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.readers;

import fiftyone.mobile.detection.readers.SourceFileBase;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class SourceFile
extends SourceFileBase {
    private final FileInputStream fileInputStream;
    private final FileChannel channel;

    public SourceFile(String fileName, boolean isTempFile) throws FileNotFoundException {
        super(fileName, isTempFile);
        this.fileInputStream = new FileInputStream(fileName);
        this.channel = this.fileInputStream.getChannel();
    }

    @Override
    ByteBuffer createStream() throws IOException {
        MappedByteBuffer byteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    @Override
    public void close() throws IOException {
        this.fileInputStream.close();
        System.gc();
        super.deleteFile();
    }
}

