/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.mobile.detection.readers.SourceBase;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class Pool {
    private final Queue<BinaryReader> readers = new LinkedList<BinaryReader>();
    private final SourceBase source;
    private final AtomicInteger readerCount = new AtomicInteger(0);

    Pool(SourceBase source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryReader getReader() throws IOException {
        Queue<BinaryReader> queue = this.readers;
        synchronized (queue) {
            if (!this.readers.isEmpty()) {
                return this.readers.poll();
            }
        }
        this.readerCount.incrementAndGet();
        return this.source.createReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(BinaryReader reader) {
        Queue<BinaryReader> queue = this.readers;
        synchronized (queue) {
            this.readers.add(reader);
        }
    }

    public int getReadersCreated() {
        return this.readerCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadersQueued() {
        Queue<BinaryReader> queue = this.readers;
        synchronized (queue) {
            return this.readers.size();
        }
    }
}

