/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SignatureV31
extends Signature {
    protected volatile Integer rank;
    private final List<Integer> nodeOffsets;

    public SignatureV31(Dataset ds, int index, BinaryReader reader) {
        super(ds, index, reader);
        List<Integer> list = SignatureV31.readPositiveAndZeroIntegers(reader, this.dataSet.signatureNodesCount);
        this.nodeOffsets = new ArrayList<Integer>(list.size());
        Iterator<Integer> iter = list.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.nodeOffsets.add(iter.next());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRank() throws IOException {
        Integer localRank = this.rank;
        if (localRank == null) {
            SignatureV31 signatureV31 = this;
            synchronized (signatureV31) {
                localRank = this.rank;
                if (localRank == null) {
                    this.rank = localRank = Integer.valueOf(this.getSignatureRank());
                }
            }
        }
        return localRank;
    }

    @Override
    public List<Integer> getNodeOffsets() {
        return this.nodeOffsets;
    }

    @Override
    protected int getSignatureLength() throws IOException {
        Node lastNode = this.dataSet.nodes.get(this.nodeOffsets.get(this.nodeOffsets.size() - 1));
        return lastNode.position + lastNode.getLength() + 1;
    }

    private int getSignatureRank() throws IOException {
        for (int tempRank = 0; tempRank < this.dataSet.rankedSignatureIndexes.size(); ++tempRank) {
            if (this.dataSet.rankedSignatureIndexes.get(tempRank) != this.index) continue;
            return tempRank;
        }
        return Integer.MAX_VALUE;
    }
}

