/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.IClosableIterator;
import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.stream.Dataset;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class StreamFixedListRangeIterator<T>
implements IClosableIterator<T> {
    private BinaryReader reader;
    private final int count;
    private final Dataset dataSet;
    private final BaseEntityFactory<T> entityFactory;
    private int currentIndex;
    private final int startIndex;

    public StreamFixedListRangeIterator(BaseEntityFactory<T> entityFactory, Dataset dataSet, int startPosition, int startIndex, int count) throws IOException {
        this.dataSet = dataSet;
        this.entityFactory = entityFactory;
        this.currentIndex = startIndex;
        this.startIndex = startIndex;
        this.reader = dataSet.pool.getReader();
        this.reader.setPos(startPosition);
        this.count = count;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.dataSet.pool.release(this.reader);
            this.reader = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex - this.startIndex < this.count;
    }

    @Override
    public T next() {
        T item = null;
        try {
            item = this.entityFactory.create(this.dataSet, this.currentIndex, this.reader);
            ++this.currentIndex;
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex.getMessage());
        }
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not a valid action for the StreamFixedListRangeIterator.");
    }
}

