/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.IClosableIterator;
import fiftyone.mobile.detection.entities.IntegerEntity;
import fiftyone.mobile.detection.entities.stream.Dataset;
import fiftyone.mobile.detection.entities.stream.Node;
import fiftyone.mobile.detection.factories.NodeFactoryShared;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class NodeV32
extends Node {
    private volatile int[] rankedSignatureIndexes;

    public NodeV32(Dataset dataSet, int offset, BinaryReader reader) throws IOException {
        super(dataSet, offset, reader);
        this.rankedSignatureCount = reader.readUInt16();
        this.children = NodeFactoryShared.readNodeIndexesV32(dataSet, reader, (int)((long)(offset + reader.getPos()) - this.nodeStartStreamPosition), this.childrenCount);
        this.numericChildrenPosition = reader.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRankedSignatureIndexes() throws IOException {
        int[] localRankedSignatureIndexes = this.rankedSignatureIndexes;
        if (localRankedSignatureIndexes == null) {
            NodeV32 nodeV32 = this;
            synchronized (nodeV32) {
                localRankedSignatureIndexes = this.rankedSignatureIndexes;
                if (localRankedSignatureIndexes == null) {
                    this.rankedSignatureIndexes = localRankedSignatureIndexes = this.getRankedSignatureIndexesAsArray();
                }
            }
        }
        return localRankedSignatureIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getRankedSignatureIndexesAsArray() throws IOException {
        int[] rsi;
        block11: {
            rsi = null;
            if (this.rankedSignatureCount == 0) {
                rsi = new int[]{};
            } else {
                BinaryReader reader = null;
                try {
                    reader = this.pool.getReader();
                    reader.setPos(this.numericChildrenPosition + 6 * this.getNumericChildrenLength());
                    int rankedSignatureIndex = reader.readInt32();
                    if (this.rankedSignatureCount == 1) {
                        rsi = new int[this.rankedSignatureCount];
                        rsi[0] = rankedSignatureIndex;
                        break block11;
                    }
                    IClosableIterator<IntegerEntity> range = this.dataSet.getNodeRankedSignatureIndexes().getRange(rankedSignatureIndex, this.rankedSignatureCount);
                    try {
                        int currentIndex = 0;
                        rsi = new int[this.rankedSignatureCount];
                        while (range.hasNext()) {
                            rsi[currentIndex] = ((IntegerEntity)range.next()).getValue();
                            ++currentIndex;
                        }
                    }
                    finally {
                        range.close();
                    }
                }
                finally {
                    if (reader != null) {
                        this.pool.release(reader);
                    }
                }
            }
        }
        return rsi;
    }
}

