/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.IntegerEntity;
import fiftyone.mobile.detection.entities.memory.Node;
import fiftyone.mobile.detection.factories.NodeFactoryShared;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class NodeV32
extends Node {
    private volatile int[] rankedSignatureIndexes;
    private int nodeRankedSignatureValue;

    public NodeV32(Dataset dataSet, int offset, BinaryReader reader) {
        super(dataSet, offset, reader);
        this.rankedSignatureCount = reader.readUInt16();
        this.children = NodeFactoryShared.readNodeIndexesV32(dataSet, reader, (int)((long)(offset + reader.getPos()) - this.nodeStartStreamPosition), this.childrenCount);
        this.numericChildren = this.readNodeNumericIndexes(dataSet, reader, this.numericChildrenCount);
        if (this.rankedSignatureCount > 0) {
            this.nodeRankedSignatureValue = reader.readInt32();
        }
    }

    @Override
    public void init() throws IOException {
        super.init();
        if (this.rankedSignatureIndexes == null) {
            this.rankedSignatureIndexes = this.getRankedSignatureIndexesAsArray();
        }
    }

    private int[] getRankedSignatureIndexesAsArray() throws IOException {
        int[] rsi = new int[this.rankedSignatureCount];
        if (this.rankedSignatureCount == 1) {
            rsi[0] = this.nodeRankedSignatureValue;
        } else if (this.rankedSignatureCount > 1) {
            for (int i = 0; i < this.rankedSignatureCount; ++i) {
                IntegerEntity ie = (IntegerEntity)this.dataSet.nodeRankedSignatureIndexes.get(this.nodeRankedSignatureValue + i);
                rsi[i] = ie.getValue();
            }
        }
        return rsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRankedSignatureIndexes() throws IOException {
        int[] localRankedSignatureIndexes = this.rankedSignatureIndexes;
        if (localRankedSignatureIndexes == null) {
            NodeV32 nodeV32 = this;
            synchronized (nodeV32) {
                localRankedSignatureIndexes = this.rankedSignatureIndexes;
                if (localRankedSignatureIndexes == null) {
                    this.rankedSignatureIndexes = localRankedSignatureIndexes = this.getRankedSignatureIndexesAsArray();
                }
            }
        }
        return localRankedSignatureIndexes;
    }
}

