/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.IClosableIterator;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;

public class MemoryFixedListIterator<T extends BaseEntity>
implements IClosableIterator<T> {
    private final MemoryFixedList<T> list;
    private final int max;
    private int current;

    MemoryFixedListIterator(MemoryFixedList<T> list, int start, int finish) {
        this.list = list;
        this.current = start;
        this.max = finish;
    }

    MemoryFixedListIterator(MemoryFixedList<T> list) {
        this.list = list;
        this.max = list.size();
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.max;
    }

    @Override
    public T next() {
        try {
            T t = this.list.get(this.current);
            ++this.current;
            return t;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Items can not be removed from DataSet lists.");
    }

    @Override
    public void close() {
    }
}

