/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.IClosableIterator;
import fiftyone.mobile.detection.entities.IntegerEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class SignatureV32
extends Signature {
    private volatile int[] nodeOffsets;
    private final int rank;
    private final int firstNodeOffsetIndex;
    private final byte flags;
    private final byte nodeCount;

    public SignatureV32(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index, reader);
        this.nodeCount = reader.readByte();
        this.firstNodeOffsetIndex = reader.readInt32();
        this.rank = reader.readInt32();
        this.flags = reader.readByte();
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getNodeOffsets() throws IOException {
        int[] localNodeOffsets = this.nodeOffsets;
        if (localNodeOffsets == null) {
            SignatureV32 signatureV32 = this;
            synchronized (signatureV32) {
                localNodeOffsets = this.nodeOffsets;
                if (localNodeOffsets == null) {
                    int[] tempNodeOffsets = new int[this.nodeCount];
                    IClosableIterator<IntegerEntity> iterator = this.dataSet.signatureNodeOffsets.getRange(this.firstNodeOffsetIndex, this.nodeCount);
                    for (int i = 0; i < this.nodeCount; ++i) {
                        tempNodeOffsets[i] = ((IntegerEntity)iterator.next()).value;
                    }
                    iterator.close();
                    localNodeOffsets = tempNodeOffsets;
                    this.nodeOffsets = tempNodeOffsets;
                }
            }
        }
        return localNodeOffsets;
    }

    @Override
    protected int getSignatureLength() {
        try {
            Node lastNode = this.dataSet.nodes.get(((IntegerEntity)this.dataSet.signatureNodeOffsets.get((int)(this.nodeCount + this.firstNodeOffsetIndex - 1))).value);
            return lastNode.position + lastNode.getLength() + 1;
        }
        catch (IOException ex) {
            return -1;
        }
    }
}

